/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.subscription;

import com.rti.dds.domain.DomainParticipant;
import com.rti.dds.domain.DomainParticipantFactory;
import com.rti.dds.domain.DomainParticipantImpl;
import com.rti.dds.infrastructure.Entity;
import com.rti.dds.infrastructure.EntityImpl;
import com.rti.dds.infrastructure.Listener;
import com.rti.dds.infrastructure.NativeFactoryMixin;
import com.rti.dds.infrastructure.NativeStructMixin;
import com.rti.dds.infrastructure.RETCODE_BAD_PARAMETER;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.subscription.DataReader;
import com.rti.dds.subscription.DataReaderImpl;
import com.rti.dds.subscription.DataReaderListener;
import com.rti.dds.subscription.DataReaderQos;
import com.rti.dds.subscription.DataReaderSeq;
import com.rti.dds.subscription.Subscriber;
import com.rti.dds.subscription.SubscriberListener;
import com.rti.dds.subscription.SubscriberListenerImpl;
import com.rti.dds.subscription.SubscriberQos;
import com.rti.dds.topic.KeyHash_t;
import com.rti.dds.topic.NativeTopicDescription;
import com.rti.dds.topic.Topic;
import com.rti.dds.topic.TopicDescription;
import com.rti.dds.topic.TopicQos;
import com.rti.dds.util.Utilities;
import com.rti.ndds.config.ModuleLogger;

public final class SubscriberImpl
extends EntityImpl
implements Subscriber {
    private final DataReaderFactoryMixin _dataReaderFactory = new DataReaderFactoryMixin();
    private static final RuntimeException NULL_PROFILE = new RETCODE_BAD_PARAMETER("null profile");
    private static final RuntimeException NULL_LIBRARY = new RETCODE_BAD_PARAMETER("null library");
    private boolean[] _needsEnableOut = new boolean[1];
    private final Object[] _serializeOption = new Object[1];
    private String _scratchTopicName = null;

    public SubscriberImpl(long l, SubscriberListener subscriberListener, int n) {
        super(l, new SubscriberListenerImpl(subscriberListener, n, l));
        this.initializeQosMixin(new SubscriberQosMixin());
    }

    public static native Object get_subscriberI(long var0);

    public void delete_builtin_datareaderI(String string) {
        DataReader dataReader = this.lookup_datareaderI(string, false);
        this.delete_datareader(dataReader);
    }

    public void get_default_datareader_qos(DataReaderQos dataReaderQos) {
        this._dataReaderFactory.get_untypedI(dataReaderQos, null);
    }

    public void get_default_datareader_qos_w_topic_name(DataReaderQos dataReaderQos, String string) {
        this._dataReaderFactory.get_untypedI(dataReaderQos, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_default_datareader_qos(DataReaderQos dataReaderQos) {
        boolean bl = dataReaderQos == DATAREADER_QOS_DEFAULT;
        this.lock();
        try {
            this._serializeOption[0] = bl ? null : dataReaderQos.type_support.plugin_data;
            this._dataReaderFactory.set_untypedI(dataReaderQos, bl, false, this._serializeOption);
        }
        finally {
            this.unlock();
        }
    }

    public void set_default_datareader_qos_with_profile(String string, String string2) {
        Object var3_3 = null;
        DataReaderQos dataReaderQos = new DataReaderQos();
        this.check_aliveI();
        if (string2 == null) {
            string2 = this.get_default_profile();
            string = this.get_default_profile_library();
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
            return;
        }
        if (string == null && (string = this.get_default_library()) == null) {
            Utilities.rethrow(NULL_LIBRARY);
            return;
        }
        this._dataReaderFactory.set_untypedI(dataReaderQos, false, true, new Object[]{string, string2});
        dataReaderQos = null;
    }

    public DataReader create_datareader(TopicDescription topicDescription, DataReaderQos dataReaderQos, DataReaderListener dataReaderListener, int n) {
        DataReader dataReader = null;
        if (topicDescription == null) {
            return null;
        }
        if (dataReaderQos == null) {
            return null;
        }
        boolean bl = dataReaderQos == DATAREADER_QOS_DEFAULT;
        try {
            dataReader = (DataReader)this._dataReaderFactory.create_entityI(dataReaderQos, bl, dataReaderListener, n, new Object[]{topicDescription, dataReaderQos == DATAREADER_QOS_USE_TOPIC_QOS ? Boolean.TRUE : Boolean.FALSE, bl || dataReaderQos == DATAREADER_QOS_USE_TOPIC_QOS ? null : dataReaderQos.type_support.plugin_data});
        }
        catch (RETCODE_ERROR rETCODE_ERROR) {
            ModuleLogger.DDS.logStackTrace(SubscriberImpl.class, "create_datareader", rETCODE_ERROR);
            return null;
        }
        return dataReader;
    }

    public DataReader create_datareader_with_profile(TopicDescription topicDescription, String string, String string2, DataReaderListener dataReaderListener, int n) {
        DataReaderQos dataReaderQos = new DataReaderQos();
        DataReader dataReader = null;
        this.check_aliveI();
        if (string2 == null) {
            string2 = SubscriberImpl.DDS_Subscriber_get_default_profile(this.get_native_pointer());
            string = SubscriberImpl.DDS_Subscriber_get_default_profile_library(this.get_native_pointer());
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
        }
        if (string == null) {
            string = SubscriberImpl.DDS_Subscriber_get_default_library(this.get_native_pointer());
        }
        if (string == null) {
            Utilities.rethrow(NULL_LIBRARY);
        }
        DomainParticipantFactory.get_instance().get_datareader_qos_from_profile_w_topic_name(dataReaderQos, string, string2, topicDescription.get_name());
        dataReader = this.create_datareader(topicDescription, dataReaderQos, dataReaderListener, n);
        dataReaderQos = null;
        return dataReader;
    }

    public void delete_datareader(DataReader dataReader) {
        this._dataReaderFactory.delete_entityI(dataReader);
    }

    public DataReader lookup_datareader(String string) {
        this.check_aliveI();
        this.check_for_null_argumentI(string);
        return this.lookup_datareaderI(string, true);
    }

    public void get_datareaders(DataReaderSeq dataReaderSeq, int n, int n2, int n3) {
        this.check_aliveI();
        this.check_for_null_argumentI(dataReaderSeq);
        int n4 = SubscriberImpl.DDS_Subscriber_get_datareaders(this.get_native_pointer(), dataReaderSeq.getNativeSequence(), n, n2, n3);
        RETCODE_ERROR.check_return_codeI(n4);
    }

    public void get_all_datareaders(DataReaderSeq dataReaderSeq) {
        this.check_aliveI();
        this.check_for_null_argumentI(dataReaderSeq);
        int n = SubscriberImpl.DDS_Subscriber_get_all_datareaders(this.get_native_pointer(), dataReaderSeq.getNativeSequence());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void notify_datareaders() {
        this.check_aliveI();
        int n = SubscriberImpl.DDS_Subscriber_notify_datareaders(this.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void get_qos(SubscriberQos subscriberQos) {
        this.get_untyped_qos(subscriberQos);
    }

    public void set_qos(SubscriberQos subscriberQos) {
        boolean bl = subscriberQos == DomainParticipant.SUBSCRIBER_QOS_DEFAULT;
        this.set_untyped_qos(subscriberQos, bl, null);
    }

    public void set_qos_with_profile(String string, String string2) {
        SubscriberQos subscriberQos = new SubscriberQos();
        this.check_aliveI();
        if (string2 == null) {
            string2 = SubscriberImpl.DDS_Subscriber_get_default_profile(this.get_native_pointer());
            string = SubscriberImpl.DDS_Subscriber_get_default_profile_library(this.get_native_pointer());
        }
        if (string2 == null) {
            Utilities.rethrow(NULL_PROFILE);
        }
        if (string == null) {
            string = SubscriberImpl.DDS_Subscriber_get_default_library(this.get_native_pointer());
        }
        if (string == null) {
            Utilities.rethrow(NULL_LIBRARY);
        }
        DomainParticipantFactory.get_instance().get_subscriber_qos_from_profile(subscriberQos, string, string2);
        this.set_qos(subscriberQos);
        subscriberQos = null;
    }

    public String get_default_library() {
        this.check_aliveI();
        String string = SubscriberImpl.DDS_Subscriber_get_default_library(this.get_native_pointer());
        return string;
    }

    public void set_default_library(String string) {
        this.check_aliveI();
        int n = SubscriberImpl.DDS_Subscriber_set_default_library(this.get_native_pointer(), string);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public String get_default_profile() {
        this.check_aliveI();
        String string = SubscriberImpl.DDS_Subscriber_get_default_profile(this.get_native_pointer());
        return string;
    }

    public void set_default_profile(String string, String string2) {
        this.check_aliveI();
        int n = SubscriberImpl.DDS_Subscriber_set_default_profile(this.get_native_pointer(), string, string2);
        RETCODE_ERROR.check_return_codeI(n);
    }

    public String get_default_profile_library() {
        this.check_aliveI();
        String string = SubscriberImpl.DDS_Subscriber_get_default_profile_library(this.get_native_pointer());
        return string;
    }

    public SubscriberListener get_listener() {
        return (SubscriberListener)this.get_untyped_listenerI();
    }

    public void set_listener(SubscriberListener subscriberListener, int n) {
        this.set_untyped_listenerI(subscriberListener, n);
    }

    public void call_listenerT(int n) {
        this.check_aliveI();
        SubscriberImpl.DDS_Subscriber_call_listener(this.get_native_pointer(), n);
    }

    public void begin_access() {
        this.check_aliveI();
        int n = SubscriberImpl.DDS_Subscriber_begin_access(this.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void end_access() {
        this.check_aliveI();
        int n = SubscriberImpl.DDS_Subscriber_end_access(this.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public void copy_from_topic_qos(DataReaderQos dataReaderQos, TopicQos topicQos) {
        this.check_aliveI();
        this.check_for_null_argumentI(dataReaderQos);
        this.check_for_null_argumentI(topicQos);
        dataReaderQos.durability.copy_from(topicQos.durability);
        dataReaderQos.deadline.copy_from(topicQos.deadline);
        dataReaderQos.latency_budget.copy_from(topicQos.latency_budget);
        dataReaderQos.liveliness.copy_from(topicQos.liveliness);
        dataReaderQos.reliability.copy_from(topicQos.reliability);
        dataReaderQos.destination_order.copy_from(topicQos.destination_order);
        dataReaderQos.history.copy_from(topicQos.history);
        dataReaderQos.resource_limits.copy_from(topicQos.resource_limits);
        dataReaderQos.ownership.copy_from(topicQos.ownership);
    }

    public void delete_contained_entities() {
        this.check_aliveI();
        int n = SubscriberImpl.DDS_Subscriber_delete_contained_entities(this.get_native_pointer());
        RETCODE_ERROR.check_return_codeI(n);
    }

    public DomainParticipant get_participant() {
        if (!this.is_alive()) {
            return null;
        }
        DomainParticipant domainParticipant = null;
        long l = SubscriberImpl.DDS_Subscriber_get_participant(this.get_native_pointer());
        if (l != 0L) {
            domainParticipant = (DomainParticipant)DomainParticipantImpl.get_participantI(l);
        }
        return domainParticipant;
    }

    public DataReader lookup_datareader_by_name(String string) {
        long l = SubscriberImpl.DDS_Subscriber_lookup_datareader_by_name(this.get_native_pointer(), string);
        if (l != 0L) {
            return (DataReader)DataReaderImpl.get_datareaderI(l);
        }
        return null;
    }

    public DataReader assert_topic_and_create_datareader(String string, String string2, String string3, String string4, DataReaderQos dataReaderQos, DataReaderListener dataReaderListener, int n) {
        this.check_for_null_argumentI(string3);
        this.check_for_null_argumentI(string4);
        this.check_for_null_argumentI(dataReaderQos);
        Topic topic = null;
        DataReader dataReader = null;
        topic = ((DomainParticipantImpl)this.get_participant()).check_create_and_enable_topic_if_no_existI(string3, string4);
        if (topic == null) {
            return null;
        }
        dataReader = this.create_datareader(topic, dataReaderQos, dataReaderListener, n);
        if (dataReader == null) {
            return null;
        }
        return dataReader;
    }

    public void release_topic_and_delete_datareader(String string, String string2, DataReader dataReader) {
        Topic topic = null;
        this.check_for_null_argumentI(dataReader);
        topic = (Topic)dataReader.get_topicdescription();
        this.delete_datareader(dataReader);
        this.get_participant().delete_topic(topic);
    }

    public void on_native_entity_finalized() {
        super.cleanup();
        this._dataReaderFactory.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataReader lookup_datareaderI(String string, boolean bl) {
        TopicDescription topicDescription = null;
        long l = 0L;
        if (bl && (topicDescription = this.get_participant().lookup_topicdescription(string)) != null) {
            l = ((NativeTopicDescription)topicDescription).get_native_topic_description_pointerI();
        }
        DataReader dataReader = null;
        this.lock();
        try {
            long l2 = SubscriberImpl.DDS_Subscriber_lookup_datareaderI(this.get_native_pointer(), this._needsEnableOut, l, string);
            if (l2 == 0L) {
                DataReader dataReader2 = null;
                return dataReader2;
            }
            dataReader = (DataReader)DataReaderImpl.get_datareaderI(l2);
            if (dataReader == null && bl) {
                dataReader = (DataReader)this._dataReaderFactory.wrap_with_java_entity(l2, null, 0, new Object[]{topicDescription});
                if (this._needsEnableOut[0]) {
                    dataReader.enable();
                }
            }
        }
        finally {
            this.unlock();
        }
        return dataReader;
    }

    private static native int DDS_Subscriber_get_qos(long var0, long var2);

    private static native int DDS_Subscriber_set_qos(long var0, long var2, boolean var4);

    private static native int DDS_Subscriber_set_qos_with_profile(long var0, String var2, String var3);

    private static native String DDS_Subscriber_get_default_library(long var0);

    private static native int DDS_Subscriber_set_default_library(long var0, String var2);

    private static native String DDS_Subscriber_get_default_profile(long var0);

    private static native int DDS_Subscriber_set_default_profile(long var0, String var2, String var3);

    private static native String DDS_Subscriber_get_default_profile_library(long var0);

    private static native long get_scratchpad_subscriber_qosI(long var0);

    private static native long DDS_Subscriber_create_datareader_disabledI(long var0, long var2, boolean[] var4, long var5, long var7, boolean var9, boolean var10, long var11, int var13, Object var14);

    private static native int DDS_Subscriber_delete_datareader(long var0, long var2);

    private static native int initialize_native_to_java_datareader_pointer(long var0, Object var2, Object var3);

    private static native int DDS_Subscriber_get_default_datareader_qos(long var0, long var2);

    private static native int DDS_Subscriber_get_default_datareader_qos_w_topic_name(long var0, long var2, String var4);

    private static native int DDS_Subscriber_set_default_datareader_qos(long var0, long var2, boolean var4, Object var5);

    private static native int DDS_Subscriber_set_default_datareader_qos_with_profile(long var0, String var2, String var3);

    private static native long get_scratchpad_datareader_qosI(long var0);

    private static native long DDS_Subscriber_lookup_datareaderI(long var0, boolean[] var2, long var3, String var5);

    private static native int DDS_Subscriber_notify_datareaders(long var0);

    private static native int DDS_Subscriber_begin_access(long var0);

    private static native int DDS_Subscriber_end_access(long var0);

    private static native int DDS_Subscriber_get_datareaders(long var0, long var2, int var4, int var5, int var6);

    private static native int DDS_Subscriber_call_listener(long var0, int var2);

    private static native int DDS_Subscriber_delete_contained_entities(long var0);

    private static native long DDS_Subscriber_get_participant(long var0);

    private static native int DDS_Subscriber_get_all_datareaders(long var0, long var2);

    private static native long DDS_Subscriber_lookup_datareader_by_name(long var0, String var2);

    private final class DataReaderFactoryMixin
    extends NativeFactoryMixin {
        public DataReaderFactoryMixin() {
            super(SubscriberImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return SubscriberImpl.get_scratchpad_datareader_qosI(l);
        }

        protected Entity wrap_with_java_entity(long l, Listener listener, int n, Object[] objectArray) {
            return super.wrap_with_java_entity(l, listener, n, objectArray);
        }

        protected long create_native_entity(long l, long l2, boolean bl, long l3, int n, boolean[] blArray, Object[] objectArray) {
            NativeTopicDescription nativeTopicDescription = (NativeTopicDescription)objectArray[0];
            nativeTopicDescription.check_aliveI();
            long l4 = nativeTopicDescription.get_native_topic_description_pointerI();
            Boolean bl2 = (Boolean)objectArray[1];
            long l5 = ((NativeTopicDescription)objectArray[0]).get_type_support_native_peer();
            Object object = objectArray[2];
            return SubscriberImpl.DDS_Subscriber_create_datareader_disabledI(l, l5, blArray, l4, l2, bl, bl2, l3, n, object);
        }

        protected Entity create_java_entity(long l, Listener listener, int n, Object[] objectArray) {
            NativeTopicDescription nativeTopicDescription = (NativeTopicDescription)objectArray[0];
            return nativeTopicDescription.create_datareaderI(l, (DataReaderListener)listener, n);
        }

        protected int initialize_native_to_java_pointer(long l, Entity entity) {
            KeyHash_t keyHash_t = ((DataReaderImpl)entity).get_key_hash();
            return SubscriberImpl.initialize_native_to_java_datareader_pointer(l, entity, keyHash_t);
        }

        protected int destroy_native_entity(long l, long l2) {
            return SubscriberImpl.DDS_Subscriber_delete_datareader(l, l2);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            String string = (String)object;
            return SubscriberImpl.DDS_Subscriber_get_default_datareader_qos_w_topic_name(l, l2, string);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            if (bl2) {
                return SubscriberImpl.DDS_Subscriber_set_default_datareader_qos_with_profile(l, (String)objectArray[0], (String)objectArray[1]);
            }
            return SubscriberImpl.DDS_Subscriber_set_default_datareader_qos(l, l2, bl, objectArray[0]);
        }
    }

    private final class SubscriberQosMixin
    extends NativeStructMixin {
        public SubscriberQosMixin() {
            super(SubscriberImpl.this);
        }

        protected long get_scratchpadI(long l) {
            return SubscriberImpl.get_scratchpad_subscriber_qosI(l);
        }

        protected int get_native_structI(long l, long l2, Object object) {
            return SubscriberImpl.DDS_Subscriber_get_qos(l, l2);
        }

        protected int set_native_structI(long l, long l2, boolean bl, boolean bl2, Object[] objectArray) {
            return SubscriberImpl.DDS_Subscriber_set_qos(l, l2, bl);
        }
    }
}

