/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.subscription;

import com.rti.dds.subscription.NativeSubscriber;
import com.rti.dds.subscription.Subscriber;
import com.rti.dds.util.AbstractNativeSequence;
import com.rti.dds.util.Utilities;
import java.util.Collection;

public final class SubscriberSeq
extends AbstractNativeSequence {
    public SubscriberSeq() {
        this(0);
    }

    public SubscriberSeq(Collection collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public SubscriberSeq(int n) {
        super(NativeSubscriber.class, SubscriberSeq.createNativeSequence(), n);
    }

    public int getMaximum() {
        return SubscriberSeq.DDS_SubscriberSeq_get_maximum(this.getNativeSequence());
    }

    public Object get(int n) {
        this.checkBounds(n, false);
        Subscriber subscriber = null;
        long l = SubscriberSeq.DDS_SubscriberSeq_get(this.getNativeSequence(), n);
        if (l != 0L) {
            subscriber = (Subscriber)SubscriberSeq.get_subscriber(l);
        }
        return subscriber;
    }

    public Object set(int n, Object object) {
        Object object2 = this.get(n);
        long l = ((NativeSubscriber)object).get_native_pointer();
        long l2 = SubscriberSeq.DDS_SubscriberSeq_get_reference(this.getNativeSequence(), n);
        if (l2 == 0L) {
            Utilities.rethrow(INCONSISTENT_STATE);
        }
        SubscriberSeq.DDS_SubscriberSeq_set(l2, l);
        return object2;
    }

    public void clear() {
        this.setSize(0);
    }

    public int size() {
        return SubscriberSeq.DDS_SubscriberSeq_get_length(this.getNativeSequence());
    }

    public long getNativeSequence() {
        return super.getNativeSequence();
    }

    protected native void destroyNativeSequence(long var1);

    protected void incrementSize() {
        this.setSize(this.size() + 1);
    }

    protected void decrementSize() {
        this.setSize(this.size() - 1);
    }

    protected void reallocate(int n) {
        int n2 = SubscriberSeq.DDS_SubscriberSeq_set_maximum(this.getNativeSequence(), n);
        if (n2 == 0) {
            Utilities.rethrow(FAILED_ALLOCATION);
        }
    }

    private static long createNativeSequence() {
        long l = SubscriberSeq.DDS_new_empty_sequence();
        if (l == 0L) {
            Utilities.rethrow(FAILED_ALLOCATION);
        }
        return l;
    }

    private void setSize(int n) {
        int n2 = SubscriberSeq.DDS_SubscriberSeq_set_length(this.getNativeSequence(), n);
        if ((long)n2 == 0L) {
            Utilities.rethrow(INCONSISTENT_STATE);
        }
    }

    private static native long DDS_new_empty_sequence();

    private static native int DDS_SubscriberSeq_get_maximum(long var0);

    private static native int DDS_SubscriberSeq_set_maximum(long var0, int var2);

    private static native int DDS_SubscriberSeq_get_length(long var0);

    private static native int DDS_SubscriberSeq_set_length(long var0, int var2);

    private static native long DDS_SubscriberSeq_get_reference(long var0, int var2);

    private static native long DDS_SubscriberSeq_get(long var0, int var2);

    private static native void DDS_SubscriberSeq_set(long var0, long var2);

    private static native Object get_subscriber(long var0);
}

