/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.type.builtin;

import com.rti.dds.cdr.CdrHelper;
import com.rti.dds.infrastructure.Copyable;
import java.io.Serializable;

public class Bytes
implements Copyable,
Serializable {
    private static final long serialVersionUID = -2208041440111813596L;
    public int length = 0;
    public int offset = 0;
    public byte[] value = null;

    public Bytes() {
    }

    public Bytes(Bytes bytes) {
        this.copy_from(bytes);
    }

    public Bytes(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("length can't be negative");
        }
        this.value = new byte[n];
        this.offset = 0;
        this.length = n;
    }

    public Bytes(byte[] byArray) {
        this.value = byArray;
        this.offset = 0;
        this.length = byArray == null ? 0 : byArray.length;
    }

    public static Object create() {
        return new Bytes();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Bytes bytes = (Bytes)object;
        if (this.length != bytes.length) {
            return false;
        }
        int n = this.offset;
        int n2 = bytes.offset;
        while (n < this.offset + this.length) {
            if (this.value[n] != bytes.value[n2]) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            n += this.value[i];
        }
        return n;
    }

    public Object copy_from(Object object) {
        if (object == null) {
            throw new NullPointerException("src");
        }
        Bytes bytes = (Bytes)object;
        Bytes bytes2 = this;
        bytes2.length = bytes.length;
        bytes2.offset = 0;
        if (bytes.value == null) {
            bytes2.value = null;
        } else {
            if (bytes2.value == null || bytes2.value.length < bytes.length) {
                bytes2.value = new byte[bytes.length];
            }
            System.arraycopy(bytes.value, bytes.offset, bytes2.value, bytes2.offset, bytes.length);
        }
        return this;
    }

    public String toString() {
        return this.toString("", 0);
    }

    public String toString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            CdrHelper.printIndent(stringBuffer, n);
            stringBuffer.append(string).append(":\n");
        }
        CdrHelper.printIndent(stringBuffer, n + 1);
        stringBuffer.append("length: ").append(this.length).append("\n");
        CdrHelper.printIndent(stringBuffer, n + 1);
        stringBuffer.append("value: ");
        for (int i = 0; i < this.length; ++i) {
            stringBuffer.append(this.value[i]);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

