/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.type.builtin;

import com.rti.dds.cdr.CdrBuffer;
import com.rti.dds.cdr.CdrEncapsulation;
import com.rti.dds.cdr.CdrInputStream;
import com.rti.dds.cdr.CdrOutputStream;
import com.rti.dds.cdr.CdrPrimitiveType;
import com.rti.dds.domain.DomainParticipant;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.publication.DataWriter;
import com.rti.dds.publication.DataWriterListener;
import com.rti.dds.subscription.DataReader;
import com.rti.dds.subscription.DataReaderListener;
import com.rti.dds.topic.DefaultEndpointBuiltinTypeConfigData;
import com.rti.dds.topic.DefaultEndpointData;
import com.rti.dds.topic.KeyHash_t;
import com.rti.dds.topic.TypeSupport;
import com.rti.dds.topic.TypeSupportImpl;
import com.rti.dds.topic.TypeSupportType;
import com.rti.dds.type.builtin.KeyedBytes;
import com.rti.dds.type.builtin.KeyedBytesDataReader;
import com.rti.dds.type.builtin.KeyedBytesDataWriter;

public class KeyedBytesTypeSupport
extends TypeSupportImpl
implements TypeSupport {
    static final String TYPE_NAME = "DDS::KeyedOctets";
    private static final char[] PLUGIN_VERSION = new char[]{'\u0002', '\u0000', '\u0000', '\u0000'};
    private static final KeyedBytesTypeSupport _singleton = new KeyedBytesTypeSupport();

    public static void register_type(DomainParticipant domainParticipant, String string) {
        _singleton.register_typeI(domainParticipant, string);
    }

    public static void unregister_type(DomainParticipant domainParticipant, String string) {
        _singleton.unregister_typeI(domainParticipant, string);
    }

    public static String get_type_name() {
        return _singleton.get_type_nameI();
    }

    public static KeyedBytesTypeSupport get_instance() {
        return _singleton;
    }

    public Object create_data() {
        return new KeyedBytes();
    }

    public Object create_data(Object object) {
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        return new KeyedBytes(defaultEndpointBuiltinTypeConfigData.allocSize);
    }

    public void destroy_data(Object object) {
    }

    public Object create_key() {
        return new KeyedBytes();
    }

    public Object create_key(Object object) {
        return new KeyedBytes();
    }

    public void destroy_key(Object object) {
    }

    public Object copy_data(Object object, Object object2) {
        KeyedBytes keyedBytes = (KeyedBytes)object;
        KeyedBytes keyedBytes2 = (KeyedBytes)object2;
        return keyedBytes.copy_from(keyedBytes2);
    }

    public Class get_type() {
        return KeyedBytes.class;
    }

    public long get_serialized_sample_max_size(Object object, boolean bl, short s, long l) {
        long l2 = l;
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        if (bl) {
            if (!CdrEncapsulation.isValidEncapsulationKind(s)) {
                throw new RETCODE_ERROR("Unsupported encapsulation");
            }
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
        }
        l += CdrPrimitiveType.getStringMaxSizeSerialized(l, defaultEndpointBuiltinTypeConfigData.allocKeySize);
        l += CdrPrimitiveType.INT.getMaxSizeSerialized(l);
        l += CdrPrimitiveType.BYTE.getArrayMaxSizeSerialized(l, defaultEndpointBuiltinTypeConfigData.allocSize);
        return l - l2;
    }

    public long get_serialized_sample_min_size(Object object, boolean bl, short s, long l) {
        long l2 = l;
        if (bl) {
            if (!CdrEncapsulation.isValidEncapsulationKind(s)) {
                throw new RETCODE_ERROR("Unsupported encapsulation");
            }
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
        }
        l += CdrPrimitiveType.getStringMaxSizeSerialized(l, 1L);
        l += CdrPrimitiveType.INT.getMaxSizeSerialized(l);
        return l - l2;
    }

    public long get_serialized_sample_size(Object object, boolean bl, short s, long l, Object object2) {
        long l2 = l;
        KeyedBytes keyedBytes = (KeyedBytes)object2;
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        if (bl) {
            if (!CdrEncapsulation.isValidEncapsulationKind(s)) {
                throw new RETCODE_ERROR("Unsupported encapsulation");
            }
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
        }
        if (keyedBytes.key == null) {
            throw new RETCODE_ERROR("key cannot be null");
        }
        l += CdrPrimitiveType.getStringSerializedSize(l, keyedBytes.key);
        l += CdrPrimitiveType.INT.getMaxSizeSerialized(l);
        if (keyedBytes.length > 0) {
            l += CdrPrimitiveType.BYTE.getArrayMaxSizeSerialized(l, keyedBytes.length);
        }
        return l - l2;
    }

    public long get_serialized_key_max_size(Object object, boolean bl, short s, long l) {
        long l2 = l;
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        if (bl) {
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
        }
        l += CdrPrimitiveType.getStringMaxSizeSerialized(l, defaultEndpointBuiltinTypeConfigData.allocKeySize);
        return l - l2;
    }

    public void serialize(Object object, Object object2, CdrOutputStream cdrOutputStream, boolean bl, short s, boolean bl2, Object object3) {
        KeyedBytes keyedBytes = (KeyedBytes)object2;
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        if (bl2) {
            if (keyedBytes.value == null && keyedBytes.length != 0) {
                throw new RETCODE_ERROR("value cannot be null");
            }
            if (keyedBytes.key == null) {
                throw new RETCODE_ERROR("key cannot be null");
            }
            if (keyedBytes.length > defaultEndpointBuiltinTypeConfigData.allocSize) {
                throw new RETCODE_ERROR("length cannot be greater than alloc size");
            }
        }
        if (bl) {
            cdrOutputStream.serializeAndSetCdrEncapsulation(s);
        }
        if (bl2) {
            cdrOutputStream.writeString(keyedBytes.key, defaultEndpointBuiltinTypeConfigData.allocKeySize - 1);
            cdrOutputStream.writeInt(keyedBytes.length);
            if (keyedBytes.length > 0) {
                cdrOutputStream.writeByteArray(keyedBytes.value, keyedBytes.offset, keyedBytes.length);
            }
        }
    }

    public void serialize_key(Object object, Object object2, CdrOutputStream cdrOutputStream, boolean bl, short s, boolean bl2, Object object3) {
        KeyedBytes keyedBytes = (KeyedBytes)object2;
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        if (bl2) {
            if (keyedBytes.key == null) {
                throw new RETCODE_ERROR("key cannot be null");
            }
            if (keyedBytes.key.length() >= defaultEndpointBuiltinTypeConfigData.allocKeySize) {
                throw new RETCODE_ERROR("key length cannot be greater or equal than alloc key size");
            }
        }
        if (bl) {
            cdrOutputStream.serializeAndSetCdrEncapsulation(s);
        }
        if (bl2) {
            cdrOutputStream.writeString(keyedBytes.key, defaultEndpointBuiltinTypeConfigData.allocKeySize - 1);
        }
    }

    public Object deserialize_sample(Object object, Object object2, CdrInputStream cdrInputStream, boolean bl, boolean bl2, Object object3) {
        KeyedBytes keyedBytes = (KeyedBytes)object2;
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        if (bl) {
            cdrInputStream.deserializeAndSetCdrEncapsulation();
        }
        if (bl2) {
            String string = cdrInputStream.readString();
            if (string.length() >= defaultEndpointBuiltinTypeConfigData.allocKeySize) {
                throw new RETCODE_ERROR("key length cannot be greater or equal than alloc key size");
            }
            keyedBytes.length = cdrInputStream.readInt();
            if (keyedBytes.length > defaultEndpointBuiltinTypeConfigData.allocSize) {
                throw new RETCODE_ERROR("length greater than value.length");
            }
            keyedBytes.offset = 0;
            if (keyedBytes.length > 0) {
                cdrInputStream.readByteArray(keyedBytes.value, keyedBytes.length);
            }
            keyedBytes.key = string;
        }
        return object2;
    }

    public Object deserialize_key_sample(Object object, Object object2, CdrInputStream cdrInputStream, boolean bl, boolean bl2, Object object3) {
        KeyedBytes keyedBytes = (KeyedBytes)object2;
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        if (bl) {
            cdrInputStream.deserializeAndSetCdrEncapsulation();
        }
        if (bl2) {
            String string = cdrInputStream.readString();
            if (string.length() >= defaultEndpointBuiltinTypeConfigData.allocKeySize) {
                throw new RETCODE_ERROR("key length cannot be greater or equal than alloc key size");
            }
            keyedBytes.key = string;
        }
        return object2;
    }

    public void skip(Object object, CdrInputStream cdrInputStream, boolean bl, boolean bl2, Object object2) {
        if (bl) {
            cdrInputStream.skipEncapsulation();
        }
        if (bl2) {
            cdrInputStream.skipString();
            int n = cdrInputStream.readInt();
            cdrInputStream.skipByteArray(n);
        }
    }

    public void key_to_instance(Object object, Object object2, Object object3) {
        KeyedBytes keyedBytes = (KeyedBytes)object2;
        KeyedBytes keyedBytes2 = (KeyedBytes)object3;
        keyedBytes.key = keyedBytes2.key;
    }

    public void instance_to_key(Object object, Object object2, Object object3) {
        KeyedBytes keyedBytes = (KeyedBytes)object2;
        KeyedBytes keyedBytes2 = (KeyedBytes)object3;
        keyedBytes.key = keyedBytes2.key;
    }

    public void instance_to_keyhash(Object object, KeyHash_t keyHash_t, Object object2) {
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        CdrOutputStream cdrOutputStream = defaultEndpointData.get_stream();
        CdrBuffer cdrBuffer = null;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = null;
        defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        if (cdrOutputStream == null) {
            throw new RETCODE_ERROR("Missing MD5 stream");
        }
        cdrOutputStream.resetAndSetDirtyBit(true);
        this.serialize_key(object, object2, cdrOutputStream, false, (short)0, true, null);
        if (defaultEndpointBuiltinTypeConfigData.maxKeySize > 16) {
            cdrOutputStream.computeMD5(keyHash_t.value);
        } else {
            cdrBuffer = cdrOutputStream.getBuffer();
            System.arraycopy(cdrBuffer.getBuffer(), 0, keyHash_t.value, 0, cdrBuffer.currentPosition());
            System.arraycopy(KeyHash_t.ZERO_KEYHASH.value, cdrBuffer.currentPosition(), keyHash_t.value, cdrBuffer.currentPosition(), 16 - cdrBuffer.currentPosition());
        }
        keyHash_t.length = 16;
    }

    public void serialized_sample_to_keyhash(Object object, CdrInputStream cdrInputStream, KeyHash_t keyHash_t, boolean bl, Object object2) {
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        Object object3 = null;
        KeyedBytes keyedBytes = null;
        object3 = defaultEndpointData.get_sample();
        if (object3 == null) {
            throw new RETCODE_ERROR("Missing intermediate sample");
        }
        if (bl) {
            cdrInputStream.deserializeAndSetCdrEncapsulation();
        }
        keyedBytes = (KeyedBytes)object3;
        keyedBytes.key = cdrInputStream.readString();
        if (keyedBytes.key.length() >= defaultEndpointBuiltinTypeConfigData.allocKeySize) {
            throw new RETCODE_ERROR("key length cannot be greater or equal than alloc key size");
        }
        this.instance_to_keyhash(object, keyHash_t, object3);
    }

    protected DataWriter create_datawriter(long l, DataWriterListener dataWriterListener, int n) {
        return new KeyedBytesDataWriter(l, dataWriterListener, n, this);
    }

    protected DataReader create_datareader(long l, DataReaderListener dataReaderListener, int n) {
        return new KeyedBytesDataReader(l, dataReaderListener, n, this);
    }

    protected KeyedBytesTypeSupport() {
        super(TYPE_NAME, true, null, KeyedBytes.class, TypeSupportType.TST_STRUCT, PLUGIN_VERSION);
    }

    protected KeyedBytesTypeSupport(boolean bl) {
        super(TYPE_NAME, bl, null, KeyedBytes.class, TypeSupportType.TST_STRUCT, PLUGIN_VERSION);
    }
}

