/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.type.builtin;

import com.rti.dds.cdr.CdrEncapsulation;
import com.rti.dds.cdr.CdrInputStream;
import com.rti.dds.cdr.CdrOutputStream;
import com.rti.dds.cdr.CdrPrimitiveType;
import com.rti.dds.domain.DomainParticipant;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.publication.DataWriter;
import com.rti.dds.publication.DataWriterListener;
import com.rti.dds.subscription.DataReader;
import com.rti.dds.subscription.DataReaderListener;
import com.rti.dds.topic.DefaultEndpointBuiltinTypeConfigData;
import com.rti.dds.topic.DefaultEndpointData;
import com.rti.dds.topic.TypeSupport;
import com.rti.dds.topic.TypeSupportImpl;
import com.rti.dds.topic.TypeSupportType;
import com.rti.dds.type.builtin.StringDataReader;
import com.rti.dds.type.builtin.StringDataWriter;
import com.rti.dds.type.builtin.StringWrapper;

public class StringTypeSupport
extends TypeSupportImpl
implements TypeSupport {
    static final String TYPE_NAME = "DDS::String";
    private static final char[] PLUGIN_VERSION = new char[]{'\u0002', '\u0000', '\u0000', '\u0000'};
    private static final StringTypeSupport _singleton = new StringTypeSupport();

    public static void register_type(DomainParticipant domainParticipant, String string) {
        _singleton.register_typeI(domainParticipant, string);
    }

    public static void unregister_type(DomainParticipant domainParticipant, String string) {
        _singleton.unregister_typeI(domainParticipant, string);
    }

    public static String get_type_name() {
        return _singleton.get_type_nameI();
    }

    public static StringTypeSupport get_instance() {
        return _singleton;
    }

    public Object create_data() {
        return new StringWrapper();
    }

    public Object create_data(Object object) {
        return new StringWrapper();
    }

    public void destroy_data(Object object) {
        ((StringWrapper)object).value = null;
    }

    public Object create_key() {
        return null;
    }

    public Object create_key(Object object) {
        return null;
    }

    public void destroy_key(Object object) {
    }

    public Object copy_data(Object object, Object object2) {
        if (object2.getClass().toString().indexOf("StringWrapper") == -1) {
            String string = (String)object2;
            if (object.getClass().toString().indexOf("StringWrapper") == -1) {
                String string2 = (String)object;
                string2 = string;
                return string2;
            }
            StringWrapper stringWrapper = (StringWrapper)object;
            stringWrapper.value = string;
            return stringWrapper;
        }
        StringWrapper stringWrapper = (StringWrapper)object2;
        if (object.getClass().toString().indexOf("StringWrapper") == -1) {
            String string = (String)object;
            string = stringWrapper.value;
            return string;
        }
        StringWrapper stringWrapper2 = (StringWrapper)object;
        stringWrapper2 = stringWrapper;
        return stringWrapper2;
    }

    public Class get_type() {
        return String.class;
    }

    public long get_serialized_sample_max_size(Object object, boolean bl, short s, long l) {
        long l2 = l;
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        if (bl) {
            if (!CdrEncapsulation.isValidEncapsulationKind(s)) {
                throw new RETCODE_ERROR("Unsupported encapsulation");
            }
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
        }
        l += CdrPrimitiveType.getStringMaxSizeSerialized(l, defaultEndpointBuiltinTypeConfigData.allocSize);
        return l - l2;
    }

    public long get_serialized_sample_min_size(Object object, boolean bl, short s, long l) {
        long l2 = l;
        if (bl) {
            if (!CdrEncapsulation.isValidEncapsulationKind(s)) {
                throw new RETCODE_ERROR("Unsupported encapsulation");
            }
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
        }
        l += CdrPrimitiveType.getStringMaxSizeSerialized(l, 1L);
        return l - l2;
    }

    public long get_serialized_sample_size(Object object, boolean bl, short s, long l, Object object2) {
        long l2 = l;
        String string = (String)object2;
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        if (bl) {
            if (!CdrEncapsulation.isValidEncapsulationKind(s)) {
                throw new RETCODE_ERROR("Unsupported encapsulation");
            }
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
        }
        if (string == null) {
            throw new RETCODE_ERROR("string cannot be null");
        }
        l += CdrPrimitiveType.getStringSerializedSize(l, string);
        return l - l2;
    }

    public long get_serialized_key_max_size(Object object, boolean bl, short s, long l) {
        long l2 = l;
        if (bl) {
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
            l += CdrPrimitiveType.SHORT.getMaxSizeSerialized(l);
        }
        return l - l2;
    }

    public void serialize(Object object, Object object2, CdrOutputStream cdrOutputStream, boolean bl, short s, boolean bl2, Object object3) {
        String string = null;
        if (object2 != null) {
            string = object2.getClass().equals(String.class) ? (String)object2 : ((StringWrapper)object2).value;
        }
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        if (bl2 && string == null) {
            throw new RETCODE_ERROR("string cannot be null");
        }
        if (bl) {
            cdrOutputStream.serializeAndSetCdrEncapsulation(s);
        }
        if (bl2) {
            cdrOutputStream.writeString(string, defaultEndpointBuiltinTypeConfigData.allocSize - 1);
        }
    }

    public void serialize_key(Object object, Object object2, CdrOutputStream cdrOutputStream, boolean bl, short s, boolean bl2, Object object3) {
        if (bl) {
            cdrOutputStream.serializeAndSetCdrEncapsulation(s);
        }
    }

    public Object deserialize_sample(Object object, Object object2, CdrInputStream cdrInputStream, boolean bl, boolean bl2, Object object3) {
        DefaultEndpointData defaultEndpointData = (DefaultEndpointData)object;
        DefaultEndpointBuiltinTypeConfigData defaultEndpointBuiltinTypeConfigData = defaultEndpointData.getBuiltinTypeConfigData();
        if (bl) {
            cdrInputStream.deserializeAndSetCdrEncapsulation();
        }
        if (bl2) {
            StringWrapper stringWrapper = (StringWrapper)object2;
            String string = cdrInputStream.readString();
            if (string.length() >= defaultEndpointBuiltinTypeConfigData.allocSize) {
                throw new RETCODE_ERROR("string length cannot be greater or equal than alloc size");
            }
            stringWrapper.value = string;
        }
        return object2;
    }

    public Object deserialize_key_sample(Object object, Object object2, CdrInputStream cdrInputStream, boolean bl, boolean bl2, Object object3) {
        if (bl) {
            cdrInputStream.deserializeAndSetCdrEncapsulation();
        }
        return object2;
    }

    public void skip(Object object, CdrInputStream cdrInputStream, boolean bl, boolean bl2, Object object2) {
        if (bl) {
            cdrInputStream.skipEncapsulation();
        }
        if (bl2) {
            cdrInputStream.skipString();
        }
    }

    protected DataWriter create_datawriter(long l, DataWriterListener dataWriterListener, int n) {
        return new StringDataWriter(l, dataWriterListener, n, this);
    }

    protected DataReader create_datareader(long l, DataReaderListener dataReaderListener, int n) {
        return new StringDataReader(l, dataReaderListener, n, this);
    }

    protected StringTypeSupport() {
        super(TYPE_NAME, false, null, StringWrapper.class, TypeSupportType.TST_STRUCT, PLUGIN_VERSION);
    }

    protected StringTypeSupport(boolean bl) {
        super(TYPE_NAME, bl, null, StringWrapper.class, TypeSupportType.TST_STRUCT, PLUGIN_VERSION);
    }
}

