/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.typecode;

import com.rti.dds.cdr.CdrInputStream;
import com.rti.dds.infrastructure.BAD_PARAM;
import com.rti.dds.infrastructure.BAD_TYPECODE;
import com.rti.dds.infrastructure.IntSeq;
import com.rti.dds.infrastructure.StringSeq;
import com.rti.dds.typecode.EnumMember;
import com.rti.dds.typecode.ExtensibilityKind;
import com.rti.dds.typecode.SparseMember;
import com.rti.dds.typecode.StructMember;
import com.rti.dds.typecode.TCKind;
import com.rti.dds.typecode.TypeCode;
import com.rti.dds.typecode.TypeCodeRepresentation;
import com.rti.dds.typecode.UnionMember;
import com.rti.dds.typecode.ValueMember;

public final class TypeCodeFactory {
    public static final TypeCodeFactory TheTypeCodeFactory = new TypeCodeFactory();

    public static final TypeCodeFactory get_instance() {
        return TheTypeCodeFactory;
    }

    public TypeCode create_struct_tc(String string, ExtensibilityKind extensibilityKind, StructMember[] structMemberArray) throws BAD_PARAM {
        return new TypeCode(string, extensibilityKind, structMemberArray);
    }

    public TypeCode create_struct_tc(String string, StructMember[] structMemberArray) throws BAD_PARAM {
        return new TypeCode(string, ExtensibilityKind.EXTENSIBLE_EXTENSIBILITY, structMemberArray);
    }

    public TypeCode create_value_tc(String string, ExtensibilityKind extensibilityKind, short s, TypeCode typeCode, ValueMember[] valueMemberArray) throws BAD_PARAM {
        return new TypeCode(string, extensibilityKind, s, typeCode, valueMemberArray);
    }

    public TypeCode create_value_tc(String string, short s, TypeCode typeCode, ValueMember[] valueMemberArray) throws BAD_PARAM {
        return new TypeCode(string, ExtensibilityKind.EXTENSIBLE_EXTENSIBILITY, s, typeCode, valueMemberArray);
    }

    public TypeCode create_sparse_tc(String string, short s, TypeCode typeCode) throws BAD_PARAM {
        return new TypeCode(string, s, typeCode);
    }

    public TypeCode create_union_tc(String string, ExtensibilityKind extensibilityKind, TypeCode typeCode, int n, UnionMember[] unionMemberArray) throws BAD_PARAM {
        return new TypeCode(string, extensibilityKind, typeCode, n, unionMemberArray);
    }

    public TypeCode create_union_tc(String string, TypeCode typeCode, int n, UnionMember[] unionMemberArray) throws BAD_PARAM {
        return new TypeCode(string, ExtensibilityKind.EXTENSIBLE_EXTENSIBILITY, typeCode, n, unionMemberArray);
    }

    public TypeCode create_enum_tc(String string, ExtensibilityKind extensibilityKind, EnumMember[] enumMemberArray) throws BAD_PARAM {
        return new TypeCode(string, extensibilityKind, enumMemberArray);
    }

    public TypeCode create_enum_tc(String string, EnumMember[] enumMemberArray) throws BAD_PARAM {
        return new TypeCode(string, ExtensibilityKind.EXTENSIBLE_EXTENSIBILITY, enumMemberArray);
    }

    public TypeCode create_alias_tc(String string, TypeCode typeCode, boolean bl) throws BAD_PARAM {
        return new TypeCode(string, typeCode, bl);
    }

    public TypeCode create_string_tc(int n) throws BAD_PARAM {
        return new TypeCode(TCKind.TK_STRING, n);
    }

    public TypeCode create_wstring_tc(int n) throws BAD_PARAM {
        return new TypeCode(TCKind.TK_WSTRING, n);
    }

    public TypeCode create_sequence_tc(int n, TypeCode typeCode) throws BAD_PARAM {
        return new TypeCode(n, typeCode);
    }

    public TypeCode create_array_tc(int[] nArray, TypeCode typeCode) throws BAD_PARAM {
        return new TypeCode(nArray, typeCode);
    }

    public TypeCode create_array_tc(int n, TypeCode typeCode) throws BAD_PARAM {
        return this.create_array_tc(new int[]{n}, typeCode);
    }

    public TypeCode clone_tc(TypeCode typeCode) {
        return new TypeCode(typeCode);
    }

    public void delete_tc(TypeCode typeCode) {
        if (typeCode != null) {
            typeCode.delete();
        }
    }

    public TypeCode get_primitive_tc(TCKind tCKind) throws BAD_PARAM {
        if (tCKind == null) {
            throw new BAD_PARAM("tcKind is null");
        }
        if (tCKind.equals(TCKind.TK_NULL)) {
            return TypeCode.TC_NULL;
        }
        if (tCKind.equals(TCKind.TK_SHORT)) {
            return TypeCode.TC_SHORT;
        }
        if (tCKind.equals(TCKind.TK_LONG)) {
            return TypeCode.TC_LONG;
        }
        if (tCKind.equals(TCKind.TK_USHORT)) {
            return TypeCode.TC_USHORT;
        }
        if (tCKind.equals(TCKind.TK_ULONG)) {
            return TypeCode.TC_ULONG;
        }
        if (tCKind.equals(TCKind.TK_FLOAT)) {
            return TypeCode.TC_FLOAT;
        }
        if (tCKind.equals(TCKind.TK_DOUBLE)) {
            return TypeCode.TC_DOUBLE;
        }
        if (tCKind.equals(TCKind.TK_BOOLEAN)) {
            return TypeCode.TC_BOOLEAN;
        }
        if (tCKind.equals(TCKind.TK_CHAR)) {
            return TypeCode.TC_CHAR;
        }
        if (tCKind.equals(TCKind.TK_OCTET)) {
            return TypeCode.TC_OCTET;
        }
        if (tCKind.equals(TCKind.TK_LONGLONG)) {
            return TypeCode.TC_LONGLONG;
        }
        if (tCKind.equals(TCKind.TK_ULONGLONG)) {
            return TypeCode.TC_ULONGLONG;
        }
        if (tCKind.equals(TCKind.TK_LONGDOUBLE)) {
            return TypeCode.TC_LONGDOUBLE;
        }
        if (tCKind.equals(TCKind.TK_WCHAR)) {
            return TypeCode.TC_WCHAR;
        }
        throw new BAD_PARAM("TCKind is not a basic kind (primitive type or TK_NULL)");
    }

    private StructMember create_struct_member(CdrInputStream cdrInputStream) throws BAD_TYPECODE, BAD_PARAM {
        String string = cdrInputStream.readString();
        boolean bl = cdrInputStream.readBoolean();
        short s = cdrInputStream.readShort();
        boolean bl2 = cdrInputStream.readBoolean();
        TypeCode typeCode = this.create_tc_from_stream(cdrInputStream);
        return new StructMember(string, bl, s, bl2, typeCode);
    }

    private ValueMember create_value_member(CdrInputStream cdrInputStream) throws BAD_TYPECODE, BAD_PARAM {
        String string = cdrInputStream.readString();
        boolean bl = cdrInputStream.readBoolean();
        short s = cdrInputStream.readShort();
        boolean bl2 = cdrInputStream.readBoolean();
        short s2 = cdrInputStream.readShort();
        TypeCode typeCode = this.create_tc_from_stream(cdrInputStream);
        return new ValueMember(string, bl, s, bl2, s2, typeCode);
    }

    private UnionMember create_union_member(CdrInputStream cdrInputStream) throws BAD_TYPECODE, BAD_PARAM {
        String string = cdrInputStream.readString();
        boolean bl = cdrInputStream.readBoolean();
        IntSeq intSeq = new IntSeq();
        cdrInputStream.readIntSequence(intSeq, -1);
        TypeCode typeCode = this.create_tc_from_stream(cdrInputStream);
        return new UnionMember(string, bl, (int[])intSeq.getPrimitiveArray(), typeCode);
    }

    private SparseMember create_sparse_member(CdrInputStream cdrInputStream) throws BAD_TYPECODE, BAD_PARAM {
        TypeCodeRepresentation[] typeCodeRepresentationArray = null;
        String string = cdrInputStream.readString();
        byte by = cdrInputStream.readByte();
        short s = cdrInputStream.readShort();
        int n = cdrInputStream.readShort();
        typeCodeRepresentationArray = new TypeCodeRepresentation[n];
        for (int i = 0; i < n; ++i) {
            cdrInputStream.readShort();
            short s2 = cdrInputStream.readShort();
            boolean bl = cdrInputStream.readBoolean();
            short s3 = cdrInputStream.readShort();
            TypeCode typeCode = this.create_tc_from_stream(cdrInputStream);
            typeCodeRepresentationArray[i] = new TypeCodeRepresentation(s2, bl, s3, typeCode);
        }
        return new SparseMember(string, typeCodeRepresentationArray, by, s);
    }

    public TypeCode create_tc_from_xml_file(String string, String string2, StringSeq stringSeq, int n, int n2) throws BAD_PARAM {
        long l = 0L;
        TypeCode typeCode = null;
        if (string == null) {
            throw new BAD_PARAM("file_name is null");
        }
        if (string2 == null) {
            throw new BAD_PARAM("type_name is null");
        }
        if (stringSeq != null) {
            l = TypeCodeFactory.DDS_TypeCodeFactory_create_native_stringseqI(stringSeq.getMaximum());
            stringSeq.push_to_nativeI(l);
        }
        long l2 = TypeCodeFactory.DDS_TypeCodeFactory_create_tc_from_xml_file(string, string2, l, n, n2);
        if (stringSeq != null) {
            TypeCodeFactory.DDS_TypeCodeFactory_delete_native_stringseqI(l);
        }
        if (l2 != 0L) {
            typeCode = this.create_tc_from_native(l2);
            TypeCodeFactory.DDS_TypeCodeFactory_delete_native_tc(l2);
        }
        return typeCode;
    }

    public TypeCode create_tc_from_stream(CdrInputStream cdrInputStream) throws BAD_TYPECODE, BAD_PARAM {
        ExtensibilityKind extensibilityKind = ExtensibilityKind.EXTENSIBLE_EXTENSIBILITY;
        if (cdrInputStream == null) {
            throw new BAD_PARAM("input is null");
        }
        try {
            int n = cdrInputStream.readInt();
            if ((n & 0x4000) != 0) {
                extensibilityKind = ExtensibilityKind.FINAL_EXTENSIBILITY;
            } else if ((n & 0x2000) != 0) {
                extensibilityKind = ExtensibilityKind.MUTABLE_EXTENSIBILITY;
            }
            cdrInputStream.readShort();
            if ((n &= 0x7FFF00FF) == TCKind.TK_STRING.ordinal()) {
                return this.create_string_tc(cdrInputStream.readInt());
            }
            if (n == TCKind.TK_WSTRING.ordinal()) {
                return this.create_wstring_tc(cdrInputStream.readInt());
            }
            if (n == TCKind.TK_ARRAY.ordinal()) {
                IntSeq intSeq = new IntSeq();
                cdrInputStream.readIntSequence(intSeq, -1);
                TypeCode typeCode = this.create_tc_from_stream(cdrInputStream);
                return this.create_array_tc((int[])intSeq.getPrimitiveArray(), typeCode);
            }
            if (n == TCKind.TK_SEQUENCE.ordinal()) {
                int n2 = cdrInputStream.readInt();
                TypeCode typeCode = this.create_tc_from_stream(cdrInputStream);
                return this.create_sequence_tc(n2, typeCode);
            }
            if (n == TCKind.TK_ALIAS.ordinal()) {
                String string = cdrInputStream.readString();
                boolean bl = cdrInputStream.readBoolean();
                TypeCode typeCode = this.create_tc_from_stream(cdrInputStream);
                return this.create_alias_tc(string, typeCode, bl);
            }
            if (n == TCKind.TK_STRUCT.ordinal()) {
                String string = cdrInputStream.readString();
                int n3 = cdrInputStream.readInt();
                StructMember[] structMemberArray = new StructMember[n3];
                for (int i = 0; i < n3; ++i) {
                    cdrInputStream.readShort();
                    structMemberArray[i] = this.create_struct_member(cdrInputStream);
                }
                return this.create_struct_tc(string, extensibilityKind, structMemberArray);
            }
            if (n == TCKind.TK_VALUE.ordinal()) {
                String string = cdrInputStream.readString();
                short s = cdrInputStream.readShort();
                TypeCode typeCode = this.create_tc_from_stream(cdrInputStream);
                int n4 = cdrInputStream.readInt();
                ValueMember[] valueMemberArray = new ValueMember[n4];
                for (int i = 0; i < n4; ++i) {
                    cdrInputStream.readShort();
                    valueMemberArray[i] = this.create_value_member(cdrInputStream);
                }
                return this.create_value_tc(string, extensibilityKind, s, typeCode, valueMemberArray);
            }
            if (n == TCKind.TK_UNION.ordinal()) {
                String string = cdrInputStream.readString();
                int n5 = cdrInputStream.readInt();
                TypeCode typeCode = this.create_tc_from_stream(cdrInputStream);
                int n6 = cdrInputStream.readInt();
                UnionMember[] unionMemberArray = new UnionMember[n6];
                for (int i = 0; i < n6; ++i) {
                    cdrInputStream.readShort();
                    unionMemberArray[i] = this.create_union_member(cdrInputStream);
                }
                return this.create_union_tc(string, extensibilityKind, typeCode, n5, unionMemberArray);
            }
            if (n == TCKind.TK_ENUM.ordinal()) {
                String string = cdrInputStream.readString();
                int n7 = cdrInputStream.readInt();
                EnumMember[] enumMemberArray = new EnumMember[n7];
                for (int i = 0; i < n7; ++i) {
                    cdrInputStream.readShort();
                    String string2 = cdrInputStream.readString();
                    int n8 = cdrInputStream.readInt();
                    enumMemberArray[i] = new EnumMember(string2, n8);
                }
                return this.create_enum_tc(string, extensibilityKind, enumMemberArray);
            }
            if (n == TCKind.TK_SPARSE.ordinal()) {
                String string = cdrInputStream.readString();
                short s = cdrInputStream.readShort();
                TypeCode typeCode = this.create_tc_from_stream(cdrInputStream);
                TypeCode typeCode2 = this.create_sparse_tc(string, s, typeCode);
                int n9 = cdrInputStream.readInt();
                SparseMember[] sparseMemberArray = new SparseMember[n9];
                for (int i = 0; i < n9; ++i) {
                    cdrInputStream.readShort();
                    sparseMemberArray[i] = this.create_sparse_member(cdrInputStream);
                    typeCode2.add_member(sparseMemberArray[i].name, sparseMemberArray[i].member_representation_id(0), sparseMemberArray[i].get_type(), sparseMemberArray[i].member_flags, sparseMemberArray[i].access, sparseMemberArray[i].is_pointer(), sparseMemberArray[i].bits());
                    if (sparseMemberArray[i].member_representation_count() <= 1) continue;
                    for (int j = 1; j < sparseMemberArray[i].member_representation_count(); ++j) {
                        typeCode2.add_representation(sparseMemberArray[i].name, sparseMemberArray[i].member_representation_id(j), sparseMemberArray[i].member_representation_type(j), sparseMemberArray[i].is_member_representation_pointer(j), sparseMemberArray[i].member_representation_bitfield_bits(j));
                    }
                }
                return typeCode2;
            }
            if (n == TCKind.TK_SHORT.ordinal()) {
                return TypeCode.TC_SHORT;
            }
            if (n == TCKind.TK_LONG.ordinal()) {
                return TypeCode.TC_LONG;
            }
            if (n == TCKind.TK_USHORT.ordinal()) {
                return TypeCode.TC_USHORT;
            }
            if (n == TCKind.TK_ULONG.ordinal()) {
                return TypeCode.TC_ULONG;
            }
            if (n == TCKind.TK_FLOAT.ordinal()) {
                return TypeCode.TC_FLOAT;
            }
            if (n == TCKind.TK_DOUBLE.ordinal()) {
                return TypeCode.TC_DOUBLE;
            }
            if (n == TCKind.TK_BOOLEAN.ordinal()) {
                return TypeCode.TC_BOOLEAN;
            }
            if (n == TCKind.TK_CHAR.ordinal()) {
                return TypeCode.TC_CHAR;
            }
            if (n == TCKind.TK_OCTET.ordinal()) {
                return TypeCode.TC_OCTET;
            }
            if (n == TCKind.TK_LONGLONG.ordinal()) {
                return TypeCode.TC_LONGLONG;
            }
            if (n == TCKind.TK_ULONGLONG.ordinal()) {
                return TypeCode.TC_ULONGLONG;
            }
            if (n == TCKind.TK_LONGDOUBLE.ordinal()) {
                return TypeCode.TC_LONGDOUBLE;
            }
            if (n == TCKind.TK_WCHAR.ordinal()) {
                return TypeCode.TC_WCHAR;
            }
            if (n == TCKind.TK_NULL.ordinal()) {
                return TypeCode.TC_NULL;
            }
            throw new BAD_TYPECODE();
        }
        catch (BAD_PARAM bAD_PARAM) {
            throw bAD_PARAM;
        }
        catch (Exception exception) {
            throw new BAD_TYPECODE("Error deserializing type code");
        }
    }

    public TypeCode create_tc_from_native(long l) throws BAD_TYPECODE, BAD_PARAM {
        TypeCode typeCode = null;
        ExtensibilityKind extensibilityKind = ExtensibilityKind.EXTENSIBLE_EXTENSIBILITY;
        if (l == 0L) {
            throw new BAD_PARAM("input is null");
        }
        try {
            int n = TypeCodeFactory.native_kind(l);
            if (TCKind.isPrimitive(n)) {
                return this.get_primitive_tc(TCKind.valueOf(n));
            }
            if (n == TCKind.TK_STRUCT.ordinal()) {
                typeCode = this.create_struct_tc(TypeCodeFactory.native_name(l), ExtensibilityKind.valueOf(TypeCodeFactory.native_extensibility_kind(l)), null);
                int n2 = TypeCodeFactory.native_member_count(l);
                for (int i = 0; i < n2; ++i) {
                    typeCode.add_member(TypeCodeFactory.native_member_name(l, i), TypeCodeFactory.native_member_id(l, i), this.create_tc_from_native(TypeCodeFactory.native_member_type(l, i)), TypeCodeFactory.native_member_flags(l, i), TypeCodeFactory.native_member_visibility(l, i), TypeCodeFactory.native_is_member_pointer(l, i), TypeCodeFactory.native_member_bitfield_bits(l, i));
                }
            } else if (n == TCKind.TK_ENUM.ordinal()) {
                typeCode = this.create_enum_tc(TypeCodeFactory.native_name(l), ExtensibilityKind.valueOf(TypeCodeFactory.native_extensibility_kind(l)), null);
                int n3 = TypeCodeFactory.native_member_count(l);
                for (int i = 0; i < n3; ++i) {
                    typeCode.add_member_to_enum(TypeCodeFactory.native_member_name(l, i), TypeCodeFactory.native_member_ordinal(l, i));
                }
            } else if (n == TCKind.TK_UNION.ordinal()) {
                typeCode = this.create_union_tc(TypeCodeFactory.native_name(l), ExtensibilityKind.valueOf(TypeCodeFactory.native_extensibility_kind(l)), this.create_tc_from_native(TypeCodeFactory.native_discriminator_type(l)), TypeCodeFactory.native_default_index(l), null);
                int n4 = TypeCodeFactory.native_member_count(l);
                for (int i = 0; i < n4; ++i) {
                    int n5 = TypeCodeFactory.native_member_label_count(l, i);
                    int[] nArray = new int[n5];
                    for (int j = 0; j < n5; ++j) {
                        nArray[j] = TypeCodeFactory.native_member_label(l, i, j);
                    }
                    typeCode.add_member_to_union(TypeCodeFactory.native_member_name(l, i), TypeCodeFactory.native_member_id(l, i), nArray, this.create_tc_from_native(TypeCodeFactory.native_member_type(l, i)), TypeCodeFactory.native_is_member_pointer(l, i));
                }
            } else if (n == TCKind.TK_VALUE.ordinal()) {
                long l2 = TypeCodeFactory.native_concrete_base_type(l);
                TypeCode typeCode2 = null;
                if (l2 != 0L) {
                    typeCode2 = this.create_tc_from_native(l2);
                }
                typeCode = this.create_value_tc(TypeCodeFactory.native_name(l), ExtensibilityKind.valueOf(TypeCodeFactory.native_extensibility_kind(l)), TypeCodeFactory.native_type_modifier(l), typeCode2, null);
                int n6 = TypeCodeFactory.native_member_count(l);
                for (int i = 0; i < n6; ++i) {
                    typeCode.add_member(TypeCodeFactory.native_member_name(l, i), TypeCodeFactory.native_member_id(l, i), this.create_tc_from_native(TypeCodeFactory.native_member_type(l, i)), TypeCodeFactory.native_member_flags(l, i), TypeCodeFactory.native_member_visibility(l, i), TypeCodeFactory.native_is_member_pointer(l, i), TypeCodeFactory.native_member_bitfield_bits(l, i));
                }
            } else if (n == TCKind.TK_SPARSE.ordinal()) {
                typeCode = this.create_sparse_tc(TypeCodeFactory.native_name(l), TypeCodeFactory.native_type_modifier(l), this.create_tc_from_native(TypeCodeFactory.native_concrete_base_type(l)));
                int n7 = TypeCodeFactory.native_member_count(l);
                for (int i = 0; i < n7; ++i) {
                    typeCode.add_member(TypeCodeFactory.native_member_name(l, i), TypeCodeFactory.native_member_id(l, i), this.create_tc_from_native(TypeCodeFactory.native_member_type(l, i)), TypeCodeFactory.native_member_flags(l, i), TypeCodeFactory.native_member_visibility(l, i), TypeCodeFactory.native_is_member_pointer(l, i), TypeCodeFactory.native_member_bitfield_bits(l, i));
                }
            } else if (n == TCKind.TK_SEQUENCE.ordinal()) {
                typeCode = this.create_sequence_tc(TypeCodeFactory.native_length(l), this.create_tc_from_native(TypeCodeFactory.native_content_type(l)));
            } else if (n == TCKind.TK_ARRAY.ordinal()) {
                int n8 = TypeCodeFactory.native_array_dimension_count(l);
                int[] nArray = new int[n8];
                for (int i = 0; i < n8; ++i) {
                    nArray[i] = TypeCodeFactory.native_array_dimension(l, i);
                }
                typeCode = this.create_array_tc(nArray, this.create_tc_from_native(TypeCodeFactory.native_content_type(l)));
            } else if (n == TCKind.TK_ALIAS.ordinal()) {
                typeCode = this.create_alias_tc(TypeCodeFactory.native_name(l), this.create_tc_from_native(TypeCodeFactory.native_content_type(l)), TypeCodeFactory.native_is_alias_pointer(l));
            } else if (n == TCKind.TK_WSTRING.ordinal()) {
                typeCode = this.create_wstring_tc(TypeCodeFactory.native_length(l));
            } else if (n == TCKind.TK_STRING.ordinal()) {
                typeCode = this.create_string_tc(TypeCodeFactory.native_length(l));
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            throw bAD_PARAM;
        }
        catch (Exception exception) {
            throw new BAD_TYPECODE("Error creating type code");
        }
        return typeCode;
    }

    private TypeCodeFactory() {
    }

    private static native long DDS_TypeCodeFactory_create_native_stringseqI(int var0);

    private static native void DDS_TypeCodeFactory_delete_native_stringseqI(long var0);

    private static native long DDS_TypeCodeFactory_create_tc_from_xml_file(String var0, String var1, long var2, int var4, int var5);

    private static native void DDS_TypeCodeFactory_delete_native_tc(long var0);

    private static native int native_kind(long var0);

    private static native String native_name(long var0);

    private static native int native_extensibility_kind(long var0);

    private static native int native_member_count(long var0);

    private static native String native_member_name(long var0, long var2);

    private static native byte native_member_flags(long var0, long var2);

    private static native short native_member_visibility(long var0, long var2);

    private static native boolean native_is_member_pointer(long var0, long var2);

    private static native short native_member_bitfield_bits(long var0, long var2);

    private static native long native_member_type(long var0, long var2);

    private static native int native_member_ordinal(long var0, long var2);

    private static native long native_discriminator_type(long var0);

    private static native int native_default_index(long var0);

    private static native short native_type_modifier(long var0);

    private static native long native_concrete_base_type(long var0);

    private static native long native_content_type(long var0);

    private static native int native_length(long var0);

    private static native boolean native_is_alias_pointer(long var0);

    private static native int native_member_label_count(long var0, long var2);

    private static native int native_member_label(long var0, long var2, long var4);

    private static native int native_array_dimension_count(long var0);

    private static native int native_array_dimension(long var0, long var2);

    private static native int native_member_id(long var0, long var2);
}

