/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.typecode;

import com.rti.dds.cdr.CdrOutputStream;
import com.rti.dds.cdr.CdrPrimitiveType;
import com.rti.dds.typecode.TypeCode;
import com.rti.dds.util.Utilities;

public class TypeCodeRepresentation {
    public int pid;
    public boolean is_pointer;
    public short bits;
    public TypeCode type;

    public TypeCodeRepresentation(int n, boolean bl, short s, TypeCode typeCode) {
        this.pid = n;
        this.is_pointer = bl;
        this.bits = s;
        this.type = typeCode;
    }

    public int get_serialized_size(int n, boolean bl) {
        int n2 = n;
        n += CdrPrimitiveType.SHORT.getMaxSizeSerialized(n);
        n += CdrPrimitiveType.SHORT.getMaxSizeSerialized(n);
        n += CdrPrimitiveType.BOOLEAN.getMaxSizeSerialized(n);
        n += CdrPrimitiveType.SHORT.getMaxSizeSerialized(n);
        n += this.type.get_serialized_size(n, bl);
        return n - n2;
    }

    public int get_serialized_size(int n) {
        return this.get_serialized_size(n, false);
    }

    public void serialize(CdrOutputStream cdrOutputStream, boolean bl) {
        cdrOutputStream.getBuffer().align(CdrPrimitiveType.SHORT.alignment);
        int n = cdrOutputStream.getBuffer().currentPosition();
        int n2 = this.get_serialized_size(n + CdrPrimitiveType.SHORT.size);
        cdrOutputStream.writeShort(n2);
        cdrOutputStream.writeShort(this.pid);
        cdrOutputStream.writeBoolean(this.is_pointer);
        cdrOutputStream.writeShort(this.bits);
        this.type.serialize(cdrOutputStream, bl);
    }

    public void serialize(CdrOutputStream cdrOutputStream) {
        this.serialize(cdrOutputStream, false);
    }

    public int hashCode() {
        int n = 0;
        n += this.pid;
        n += this.is_pointer ? 1 : 0;
        n += this.bits;
        return n += Utilities.hashCodeNullSafe(this.type);
    }

    public boolean equal(TypeCodeRepresentation typeCodeRepresentation) {
        if (this.pid != typeCodeRepresentation.pid) {
            return false;
        }
        if (this.is_pointer != typeCodeRepresentation.is_pointer) {
            return false;
        }
        if (this.bits != typeCodeRepresentation.bits) {
            return false;
        }
        return Utilities.equalsNullSafe(this.type, typeCodeRepresentation.type);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof TypeCodeRepresentation) {
            return this.equal((TypeCodeRepresentation)object);
        }
        return false;
    }
}

