/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.util;

import com.rti.dds.infrastructure.Copyable;
import com.rti.dds.util.AbstractSequence;
import com.rti.dds.util.Sequence;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;

public abstract class AbstractPrimitiveSequence
extends AbstractSequence
implements Sequence,
Externalizable,
Copyable {
    private static final long serialVersionUID = -6374459295811621293L;
    protected int _size = 0;
    private boolean _loanedJavaElems = false;
    private final Class _primitiveType;

    public final Class getElementType() {
        return this._primitiveType;
    }

    public abstract void add(int var1, Object var2);

    public abstract Object get(int var1);

    public final void readExternal(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        if (n < 0) {
            throw new StreamCorruptedException("unexpected sequence size: " + n);
        }
        if (n > 0) {
            this.ensureMaximum(n);
            this.readElements(objectInput, n);
        }
        this.setSize(n);
    }

    public final void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.size();
        objectOutput.writeInt(n);
        this.writeElements(objectOutput, n);
    }

    public void loan(Object object, int n) {
        if (this.getMaximum() != 0) {
            throw new UnsupportedOperationException("max size must be 0");
        }
        this.setPrimitiveArray(object, n);
        this._loanedJavaElems = true;
    }

    public void unloan() {
        if (!this._loanedJavaElems) {
            throw new UnsupportedOperationException("buffer must be loaned");
        }
        this.setPrimitiveArray(null, 0);
        this._loanedJavaElems = false;
    }

    public final boolean hasOwnership() {
        return !this._loanedJavaElems;
    }

    public abstract Object getPrimitiveArray();

    public abstract void setPrimitiveArray(Object var1, int var2);

    public abstract Object set(int var1, Object var2);

    public final void clear() {
        this._size = 0;
    }

    public final void truncate(int n) {
        if (n > this._size) {
            throw new IndexOutOfBoundsException(n + " > " + this._size);
        }
        this.setSize(n);
    }

    public final void setSize(int n) {
        int n2 = this.getMaximum();
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("New size " + n + " isn't in the range [0, " + n2 + ")");
        }
        this._size = n;
    }

    public final int size() {
        return this._size;
    }

    public final Object copy_from(Object object) {
        AbstractPrimitiveSequence abstractPrimitiveSequence = (AbstractPrimitiveSequence)object;
        this.clear();
        this.ensureMaximum(abstractPrimitiveSequence.size());
        if (abstractPrimitiveSequence.size() > 0) {
            System.arraycopy(abstractPrimitiveSequence.getPrimitiveArray(), 0, this.getPrimitiveArray(), 0, abstractPrimitiveSequence.size());
        }
        this._size = abstractPrimitiveSequence.size();
        return this;
    }

    protected AbstractPrimitiveSequence(Class clazz, Class clazz2, int n) {
        super(clazz);
        AbstractPrimitiveSequence.checkNullElementType(clazz2);
        this._primitiveType = clazz2;
        this.setMaximum(n);
    }

    protected abstract void readElements(ObjectInput var1, int var2) throws IOException;

    protected abstract void writeElements(ObjectOutput var1, int var2) throws IOException;

    protected final boolean addAllPrimitive(Object object, int n, int n2) {
        boolean bl = false;
        if (n2 > 0) {
            this.ensureSpaceForAdditionalElements(n2);
            Object object2 = this.getPrimitiveArray();
            System.arraycopy(object, n, object2, this._size, n2);
            this._size += n2;
            bl = true;
        }
        return bl;
    }

    protected final void setPrimitive(int n, Object object, int n2, int n3) {
        if (n + n3 > this._size) {
            throw new IndexOutOfBoundsException(n + n3 + " > " + this._size);
        }
        Object object2 = this.getPrimitiveArray();
        System.arraycopy(object, n2, object2, n, n3);
    }

    protected final Object toArrayPrimitive(Object object, int n) {
        Object object2;
        object2 = n < this._size || object == null ? (object2 = this.createArray(this._size)) : object;
        Object object3 = this.getPrimitiveArray();
        if (this._size != 0) {
            System.arraycopy(object3, 0, object2, 0, this._size);
        }
        return object2;
    }

    protected abstract void setPrimitiveArray(Object var1);

    protected abstract Object createArray(int var1);

    protected final void shiftRightByOne(int n) {
        Object object = this.getPrimitiveArray();
        System.arraycopy(object, n, object, n + 1, this._size - n - 1);
    }

    protected void shiftLeftByOne(int n) {
        Object object = this.getPrimitiveArray();
        System.arraycopy(object, n + 1, object, n, this._size - n - 1);
    }

    protected final void reallocate(int n) {
        if (this._loanedJavaElems) {
            throw new UnsupportedOperationException("buffer must not be loaned");
        }
        Object object = this.createArray(n);
        this._size = Math.min(this._size, n);
        Object object2 = this.getPrimitiveArray();
        if (object2 != null) {
            System.arraycopy(object2, 0, object, 0, this._size);
        }
        this.setPrimitiveArray(object);
    }

    final void incrementSize() {
        ++this._size;
    }

    final void decrementSize() {
        --this._size;
    }
}

