/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.util;

import com.rti.dds.util.AbstractSequence;
import com.rti.dds.util.Sequence;
import com.rti.dds.util.Sequences;
import com.rti.dds.util.Utilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ArraySequence
extends ArrayList
implements Sequence {
    private static final long serialVersionUID = -1941836975119605901L;
    private final Class _elementType;
    private int _maximum = 0;

    public ArraySequence(Class clazz) {
        this(clazz, 0);
    }

    public ArraySequence(Class clazz, int n) {
        super(n);
        AbstractSequence.checkNullElementType(clazz);
        this._elementType = clazz;
        this.ensureCapacity(n);
    }

    public ArraySequence(Class clazz, Collection collection) {
        this(clazz, collection.size());
        this.addAll(collection);
    }

    public final int getMaximum() {
        return this._maximum;
    }

    public final void setMaximum(int n) {
        AbstractSequence.checkNegativeMaximum(n);
        for (int i = this.size() - 1; i >= n; --i) {
            this.remove(i);
        }
        if (this.size() == n) {
            this.trimToSize();
        } else if (n > this.getMaximum()) {
            this.ensureCapacity(n);
        } else {
            this._maximum = n;
        }
    }

    public final Class getElementType() {
        return this._elementType;
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        if (collection instanceof Sequence) {
            Sequences.checkType(this._elementType, ((Sequence)collection).getElementType());
            bl = super.addAll(collection);
        } else {
            this.ensureCapacity(this.size() + collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                bl = this.add(iterator.next()) || bl;
            }
        }
        return bl;
    }

    public boolean addAll(int n, Collection collection) {
        boolean bl = true;
        if (collection instanceof Sequence) {
            Sequences.checkType(this._elementType, ((Sequence)collection).getElementType());
            bl = super.addAll(n, collection);
        } else {
            this.ensureCapacity(this.size() + collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.add(n++, iterator.next());
            }
        }
        return bl;
    }

    public boolean add(Object object) {
        Sequences.checkElementType(this._elementType, object);
        this.ensureCapacity(this.size() + 1);
        return super.add(object);
    }

    public void add(int n, Object object) {
        Sequences.checkElementType(this._elementType, object);
        if (n >= 0 && n <= this.size()) {
            this.ensureCapacity(this.size() + 1);
        }
        super.add(n, object);
    }

    public Object set(int n, Object object) {
        Sequences.checkElementType(this._elementType, object);
        return super.set(n, object);
    }

    public final void ensureCapacity(int n) {
        if (n > this._maximum) {
            super.ensureCapacity(n);
            this._maximum = n;
        }
    }

    public final void trimToSize() {
        super.trimToSize();
        this._maximum = this.size();
    }

    public boolean equals(Object object) {
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Sequence sequence = (Sequence)object;
        if (this.size() != sequence.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (Utilities.equalsNullSafe(this.get(i), sequence.get(i))) continue;
            return false;
        }
        return true;
    }
}

