/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.util;

import com.rti.dds.infrastructure.ObjectHolder;
import com.rti.dds.util.AbstractSequence;
import com.rti.dds.util.ArraySequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.Collection;

public class LoanableSequence
extends AbstractSequence {
    protected static final int LOAN_LENGTH_NO_LOAN_SENTINEL = -1;
    private static final long serialVersionUID = -4602153131338436740L;
    private static final boolean _standalone;
    private final ArraySequence _ownedJavaElems;
    private transient long _loanedNativeElems = 0L;
    private transient int _loanLength = -1;

    public LoanableSequence(Class clazz) {
        this(clazz, 0);
    }

    public LoanableSequence(Class clazz, int n) {
        super(clazz);
        this._ownedJavaElems = new ArraySequence(clazz, n);
    }

    public LoanableSequence(Class clazz, Collection collection) {
        super(clazz);
        this._ownedJavaElems = new ArraySequence(clazz, collection);
    }

    public final boolean hasOwnership() {
        return this._loanedNativeElems == 0L;
    }

    public void loan(long l, int n) {
        if (_standalone) {
            throw new UnsupportedOperationException("loaning not supported in the standalone package");
        }
        this.checkLoan();
        if (!this.isEmpty()) {
            throw new UnsupportedOperationException("clear existing elements before loaning");
        }
        this._loanedNativeElems = l;
        this._loanLength = n;
    }

    public void unloan() {
        if (this.hasOwnership()) {
            throw new UnsupportedOperationException("no existing loan");
        }
        this._loanedNativeElems = 0L;
        this._loanLength = -1;
    }

    public final long getNativeElements() {
        return this._loanedNativeElems;
    }

    public final long getNativeLength() {
        return this._loanLength;
    }

    public static native Object getSampleHolder(long var0, int var2);

    public static Object getSample(long l, int n) {
        ObjectHolder objectHolder = (ObjectHolder)LoanableSequence.getSampleHolder(l, n);
        if (objectHolder != null) {
            return objectHolder.value;
        }
        return objectHolder;
    }

    public int getMaximum() {
        if (!this.hasOwnership()) {
            return this._loanLength;
        }
        return this._ownedJavaElems.getMaximum();
    }

    public void setMaximum(int n) {
        this.checkLoan();
        super.setMaximum(n);
    }

    public Object set(int n, Object object) {
        this.checkLoan();
        return this._ownedJavaElems.set(n, object);
    }

    public Object get(int n) {
        if (!this.hasOwnership()) {
            return this.getNative(this._loanedNativeElems, n);
        }
        return this._ownedJavaElems.get(n);
    }

    public int size() {
        if (!this.hasOwnership()) {
            return this._loanLength;
        }
        return this._ownedJavaElems.size();
    }

    protected Object getNative(long l, int n) {
        return LoanableSequence.getSample(l, n);
    }

    protected void reallocate(int n) {
        this.checkLoan();
        this._ownedJavaElems.setMaximum(n);
    }

    void incrementSize() {
        this.checkLoan();
        this._ownedJavaElems.add((Object)null);
    }

    void decrementSize() {
        this.checkLoan();
        this._ownedJavaElems.remove(this._ownedJavaElems.size() - 1);
    }

    private void checkLoan() {
        if (!this.hasOwnership()) {
            throw new UnsupportedOperationException("modifying loaned array not allowed");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._loanedNativeElems = 0L;
        this._loanLength = -1;
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.rti.dds.util.NativeInterface");
            Method method = clazz.getMethod("getInstance", null);
            Object object = method.invoke(null, null);
            Method method2 = clazz.getMethod("loadNativeLibraries", null);
            method2.invoke(object, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        _standalone = clazz == null;
    }
}

