/*
 * Decompiled with CFR 0.152.
 */
package com.rti.dds.util;

import com.rti.dds.util.Enum;

public final class NativeInterface {
    private static final String NDDS_LIB_NAME = "nddsjava";
    private static boolean _allLibsLoaded = false;
    private static final String DEBUG_PROPERTY_NAME = "com.rti.debug";
    private static final String DEBUG_CLASS_NAME = "DebugToken";
    private Boolean _isDebug = null;
    private static final NativeInterface _instance = new NativeInterface();
    private Architecture _architecture = null;

    public static NativeInterface getInstance() {
        return _instance;
    }

    public synchronized void loadNativeLibraries() {
        if (!_allLibsLoaded) {
            Architecture architecture = this.getArchitecture();
            if (architecture == Architecture.VXWORKS) {
                NativeInterface.initNativeInterface();
            } else {
                this.loadNativeLibrary(NDDS_LIB_NAME);
            }
            _allLibsLoaded = true;
        }
    }

    public synchronized void loadNativeLibrary(String string) {
        String[] stringArray;
        String string2 = string + 'd';
        if (this.isDebug()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = string2;
            stringArray = stringArray2;
            stringArray2[1] = string;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = string;
            stringArray = stringArray3;
            stringArray3[1] = string2;
        }
        String[] stringArray4 = stringArray;
        UnsatisfiedLinkError unsatisfiedLinkError = null;
        for (int i = 0; i < stringArray4.length; ++i) {
            try {
                System.loadLibrary(stringArray4[i]);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                if (unsatisfiedLinkError != null) continue;
                unsatisfiedLinkError = unsatisfiedLinkError2;
                continue;
            }
        }
        if (unsatisfiedLinkError != null) {
            String string3 = System.mapLibraryName(stringArray4[0]);
            Architecture architecture = this.getArchitecture();
            System.err.println("The library " + string3 + " could not be loaded by " + architecture.name() + ".");
            if (architecture == Architecture.SOLARIS || architecture == Architecture.LINUX || architecture == Architecture.LYNX) {
                System.err.println("Make sure that the library is in your LD_LIBRARY_PATH environment variable.");
            } else if (architecture == Architecture.WINDOWS) {
                System.err.println("Make sure that the library is in your Path environment variable.");
            }
            throw unsatisfiedLinkError;
        }
    }

    public boolean isNativeByteOrderLittleEndian() {
        this.loadNativeLibraries();
        return this.isNativeByteOrderLittleEndianInternal();
    }

    private native boolean isNativeByteOrderLittleEndianInternal();

    private static native boolean initNativeInterface();

    public int networkToHost(int n) {
        int n2 = n;
        if (this.isNativeByteOrderLittleEndian()) {
            int n3 = n >>> 24;
            int n4 = n >>> 8 & 0xFF00;
            int n5 = n << 8 & 0xFF0000;
            int n6 = n << 24 & 0xFF000000;
            n2 = n6 | n5 | n4 | n3;
        }
        return n2;
    }

    public Architecture getArchitecture() {
        if (this._architecture == null) {
            String string = System.getProperty("os.name").toLowerCase();
            this._architecture = string.indexOf("win") >= 0 ? Architecture.WINDOWS : (string.indexOf("sun") >= 0 ? Architecture.SOLARIS : (string.indexOf("linux") >= 0 ? Architecture.LINUX : (string.indexOf("lynx") >= 0 ? Architecture.LYNX : (string.indexOf("vxworks") >= 0 ? Architecture.VXWORKS : Architecture.OTHER))));
        }
        return this._architecture;
    }

    private NativeInterface() {
    }

    private boolean isDebug() {
        if (this._isDebug == null) {
            boolean bl = false;
            String string = System.getProperty(DEBUG_PROPERTY_NAME);
            bl = string != null ? Boolean.valueOf(string) : NativeInterface.debugTokenExists();
            this._isDebug = new Boolean(bl);
        }
        return this._isDebug;
    }

    private static boolean debugTokenExists() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(NativeInterface.class.getPackage().getName());
        stringBuffer.append('.').append(DEBUG_CLASS_NAME);
        try {
            Class.forName(stringBuffer.toString());
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public static final class Architecture
    extends Enum {
        private static final long serialVersionUID = 1199799835817653239L;
        public static final Architecture WINDOWS = new Architecture(0, "Windows");
        public static final Architecture SOLARIS = new Architecture(1, "Solaris");
        public static final Architecture LINUX = new Architecture(2, "Linux");
        public static final Architecture LYNX = new Architecture(3, "Lynx");
        public static final Architecture VXWORKS = new Architecture(4, "VxWorks");
        public static final Architecture OTHER = new Architecture(100, "your operating system");

        private Architecture(int n, String string) {
            super(string, n);
        }
    }
}

