/*
 * Decompiled with CFR 0.152.
 */
package com.rti.ndds.config;

import com.rti.dds.util.NativeInterface;
import com.rti.ndds.config.LogCategory;
import com.rti.ndds.config.LogPrintFormat;
import com.rti.ndds.config.LogVerbosity;
import com.rti.ndds.config.LoggerDevice;
import com.rti.ndds.config.LoggerDeviceImpl;
import com.rti.ndds.config.LoggerMode;
import com.rti.ndds.config.ModuleLogger;
import java.io.File;
import java.io.IOException;

public final class Logger {
    private static final String VERBOSITY_PROPERTY_NAME = "com.rti.ndds.config.Logger.verbosity";
    private static final String FILE_PROPERTY_NAME = "com.rti.ndds.config.Logger.file";
    private static final Logger _singleton;
    private static final IOException CANT_OPEN_FILE;
    private static final IOException CANT_INSTALL_DEVICE;
    private final long _nativeLogger;
    private LoggerDevice _device = null;
    private LoggerDeviceImpl _deviceImpl = null;
    private File _out = null;

    public static Logger get_instance() {
        return _singleton;
    }

    public void initialize_from_system_properties() {
        Object object;
        String string = System.getProperty(VERBOSITY_PROPERTY_NAME);
        if (string != null && string.length() > 0) {
            object = LogVerbosity.valueOf(string);
            this.set_verbosity((LogVerbosity)object);
        }
        if ((object = System.getProperty(FILE_PROPERTY_NAME)) != null && ((String)object).length() > 0) {
            File file = new File((String)object);
            try {
                this.set_output_file(file);
            }
            catch (IOException iOException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(iOException.getMessage());
                illegalArgumentException.initCause(iOException);
                throw illegalArgumentException;
            }
        }
        ModuleLogger.initialize_all_from_system_properties();
    }

    public LogVerbosity get_verbosity() {
        int n = Logger.NDDS_Config_Logger_get_verbosity(this._nativeLogger);
        return LogVerbosity.valueOf(n);
    }

    public LogVerbosity get_verbosity_by_category(LogCategory logCategory) {
        int n = Logger.NDDS_Config_Logger_get_verbosity_by_category(this._nativeLogger, logCategory.ordinal());
        return LogVerbosity.valueOf(n);
    }

    public void set_verbosity(LogVerbosity logVerbosity) {
        Logger.NDDS_Config_Logger_set_verbosity(this._nativeLogger, logVerbosity.ordinal());
    }

    public void set_verbosity_by_category(LogCategory logCategory, LogVerbosity logVerbosity) {
        Logger.NDDS_Config_Logger_set_verbosity_by_category(this._nativeLogger, logCategory.ordinal(), logVerbosity.ordinal());
    }

    public File get_output_file() {
        return this._out;
    }

    public void set_output_file(File file) throws IOException {
        String string = file == null ? null : file.getPath();
        boolean bl = Logger.NDDS_Config_Logger_set_output_file(this._nativeLogger, string);
        if (!bl) {
            CANT_OPEN_FILE.fillInStackTrace();
            throw CANT_OPEN_FILE;
        }
        this._out = file;
    }

    public LoggerDevice get_output_device() {
        return this._device;
    }

    public void set_output_device(LoggerDevice loggerDevice) throws IOException {
        long l = 0L;
        LoggerDeviceImpl loggerDeviceImpl = this._deviceImpl;
        if (loggerDevice != null) {
            this._deviceImpl = new LoggerDeviceImpl(loggerDevice);
            l = this._deviceImpl.get_native_device();
        } else {
            this._deviceImpl = null;
        }
        if (!Logger.NDDS_Config_Logger_set_output_device(this._nativeLogger, l)) {
            CANT_INSTALL_DEVICE.fillInStackTrace();
            throw CANT_INSTALL_DEVICE;
        }
        if (loggerDeviceImpl != null) {
            loggerDeviceImpl.destroy();
        }
        this._device = loggerDevice;
    }

    public LogPrintFormat get_print_format() {
        int n = Logger.NDDS_Config_Logger_get_print_format(this._nativeLogger);
        return LogPrintFormat.valueOf(n);
    }

    public boolean set_print_format(LogPrintFormat logPrintFormat) {
        return Logger.NDDS_Config_Logger_set_print_format(this._nativeLogger, logPrintFormat.ordinal());
    }

    public boolean set_mode(LoggerMode loggerMode) {
        return Logger.NDDS_Config_Logger_set_mode(this._nativeLogger, loggerMode.ordinal());
    }

    private Logger(long l) {
        if (l == 0L) {
            throw new IllegalArgumentException("NULL native logger");
        }
        this._nativeLogger = l;
    }

    private static native long NDDS_Config_Logger_get_instance();

    private static native int NDDS_Config_Logger_get_verbosity(long var0);

    private static native int NDDS_Config_Logger_get_verbosity_by_category(long var0, int var2);

    private static native void NDDS_Config_Logger_set_verbosity(long var0, int var2);

    private static native void NDDS_Config_Logger_set_verbosity_by_category(long var0, int var2, int var3);

    private static native boolean NDDS_Config_Logger_set_output_file(long var0, String var2);

    private static native boolean NDDS_Config_Logger_set_output_device(long var0, long var2);

    private static native int NDDS_Config_Logger_get_print_format(long var0);

    private static native boolean NDDS_Config_Logger_set_print_format(long var0, int var2);

    private static native boolean NDDS_Config_Logger_set_mode(long var0, int var2);

    static {
        NativeInterface.getInstance().loadNativeLibraries();
        _singleton = new Logger(Logger.NDDS_Config_Logger_get_instance());
        CANT_OPEN_FILE = new IOException("unable to open file");
        CANT_INSTALL_DEVICE = new IOException("unable to install device");
    }
}

