/*
 * Decompiled with CFR 0.152.
 */
package com.rti.ndds.config;

import com.rti.dds.infrastructure.AbstractNativeObject;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.util.Utilities;
import com.rti.ndds.config.LogMessage;
import com.rti.ndds.config.LoggerDevice;

class LoggerDeviceImpl
extends AbstractNativeObject {
    private static final RuntimeException NO_NATIVE_DEVICE = new RETCODE_ERROR("failed to initialize native device");
    private long _nativeDevice = this.initialize_native_deviceI();
    private LoggerDevice _javaDevice;

    public LoggerDeviceImpl(LoggerDevice loggerDevice) {
        if (this._nativeDevice == 0L) {
            this.destroy_native_deviceI(this._nativeDevice);
            Utilities.rethrow(NO_NATIVE_DEVICE);
        }
        this.set_output_deviceI(loggerDevice);
    }

    public void write(long l) {
        LogMessage logMessage = new LogMessage();
        logMessage.pull_from_nativeI(l);
        if (this._javaDevice != null) {
            this._javaDevice.write(logMessage);
        } else {
            System.out.println("ERROR: device has been destroyed, trying to print:");
            System.out.print("MESSAGE = " + logMessage.text);
        }
    }

    public void close() {
        this._javaDevice.close();
    }

    public long get_native_device() {
        return this._nativeDevice;
    }

    public final void destroy() {
        if (this._nativeDevice != 0L) {
            long l = this._nativeDevice;
            this.set_output_deviceI(null);
            this._nativeDevice = 0L;
            this.destroy_native_deviceI(l);
        }
    }

    private final void set_output_deviceI(LoggerDevice loggerDevice) {
        this._javaDevice = loggerDevice;
    }

    private native long initialize_native_deviceI();

    private native void destroy_native_deviceI(long var1);
}

