/*
 * Decompiled with CFR 0.152.
 */
package com.rti.ndds.config;

import com.rti.dds.util.Enum;
import com.rti.dds.util.NativeInterface;
import com.rti.ndds.config.CdrModuleLogger;
import com.rti.ndds.config.ClockModuleLogger;
import com.rti.ndds.config.CommEndModuleLogger;
import com.rti.ndds.config.CoreVersionModuleLogger;
import com.rti.ndds.config.DdsModuleLogger;
import com.rti.ndds.config.DiscoveryModuleLogger;
import com.rti.ndds.config.EventModuleLogger;
import com.rti.ndds.config.LogBitmap;
import com.rti.ndds.config.MigModuleLogger;
import com.rti.ndds.config.NetIoModuleLogger;
import com.rti.ndds.config.OsApiModuleLogger;
import com.rti.ndds.config.PresentationModuleLogger;
import com.rti.ndds.config.RedaModuleLogger;
import com.rti.ndds.config.TransportModuleLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class ModuleLogger
extends Enum {
    private static final String PROPERTY_NAME_PREFIX = "com.rti.ndds.config.ModuleLogger.";
    private static final String SUBMODULE_MASK_PROPERTY_NAME_SUFFIX = ".submoduleMask";
    private static final String INSTRUMENTATION_MASK_PROPERTY_NAME_SUFFIX = ".instrumentationMask";
    private static final List _constants = new ArrayList(12);
    private static final List _unmodifiableConstants = Collections.unmodifiableList(_constants);
    public static final ModuleLogger CDR;
    public static final ModuleLogger CLOCK;
    public static final ModuleLogger COMMEND;
    public static final ModuleLogger CORE_VERSION;
    public static final DdsModuleLogger DDS;
    public static final ModuleLogger DISCOVERY;
    public static final ModuleLogger EVENT;
    public static final ModuleLogger MIG;
    public static final ModuleLogger NETIO;
    public static final ModuleLogger OSAPI;
    public static final ModuleLogger PRESENTATION;
    public static final ModuleLogger REDA;
    public static final ModuleLogger TRANSPORT;

    public final void initialize_from_system_properties() {
        StringBuffer stringBuffer = new StringBuffer(PROPERTY_NAME_PREFIX.length() + 10);
        stringBuffer.append(PROPERTY_NAME_PREFIX).append(this.name());
        int n = stringBuffer.length();
        stringBuffer.append(INSTRUMENTATION_MASK_PROPERTY_NAME_SUFFIX);
        String string = stringBuffer.toString();
        String string2 = System.getProperty(string);
        if (string2 != null && string2.length() > 0) {
            int n2 = LogBitmap.parse(string2, true);
            stringBuffer.setLength(n);
            stringBuffer.append(SUBMODULE_MASK_PROPERTY_NAME_SUFFIX);
            String string3 = stringBuffer.toString();
            String string4 = System.getProperty(string3);
            int n3 = 255;
            if (string4 != null && string4.length() > 0) {
                n3 = LogBitmap.parse(string4, false);
            }
            this.setBitmaps(n3, n2);
        }
    }

    public abstract int getSubmoduleBitmap();

    public abstract int getInstrumentationBitmap();

    public abstract void setBitmaps(int var1, int var2);

    public static final Iterator values() {
        return _unmodifiableConstants.iterator();
    }

    ModuleLogger(String string, int n) {
        super(string, n);
        _constants.add(this);
    }

    static void initialize_all_from_system_properties() {
        Iterator iterator = ModuleLogger.values();
        while (iterator.hasNext()) {
            ((ModuleLogger)iterator.next()).initialize_from_system_properties();
        }
    }

    static {
        NativeInterface.getInstance().loadNativeLibraries();
        CDR = new CdrModuleLogger(0);
        CLOCK = new ClockModuleLogger(1);
        COMMEND = new CommEndModuleLogger(2);
        CORE_VERSION = new CoreVersionModuleLogger(3);
        DDS = new DdsModuleLogger(4);
        DISCOVERY = new DiscoveryModuleLogger(5);
        EVENT = new EventModuleLogger(6);
        MIG = new MigModuleLogger(7);
        NETIO = new NetIoModuleLogger(8);
        OSAPI = new OsApiModuleLogger(9);
        PRESENTATION = new PresentationModuleLogger(10);
        REDA = new RedaModuleLogger(11);
        TRANSPORT = new TransportModuleLogger(12);
    }
}

