/*
 * Decompiled with CFR 0.152.
 */
package com.rti.ndds.config;

import com.rti.dds.infrastructure.ProductVersion_t;
import com.rti.dds.util.NativeInterface;
import com.rti.ndds.config.LibraryVersion_t;

public final class Version {
    private static final Version _singleton;
    private final ProductVersion_t _productVersion;
    private final LibraryVersion_t _javaVersion;
    private final LibraryVersion_t _cVersion;
    private final LibraryVersion_t _coreVersion;
    private final String _stringified;

    public static Version get_instance() {
        return _singleton;
    }

    public ProductVersion_t get_product_version() {
        return this._productVersion;
    }

    public LibraryVersion_t get_java_api_version() {
        return this._javaVersion;
    }

    public String get_java_api_build_number_string() {
        return "Java_API_0";
    }

    public String get_jni_build_number_string() {
        return this.get_jni_library_build_number_string();
    }

    public LibraryVersion_t get_c_api_version() {
        return this._cVersion;
    }

    public LibraryVersion_t get_core_version() {
        return this._coreVersion;
    }

    public String toString() {
        return this._stringified;
    }

    private Version() {
        int[] nArray = new int[4];
        this.get_core_library_versions(nArray);
        this._coreVersion = new LibraryVersion_t("nddscore", nArray);
        this.get_c_library_versions(nArray);
        this._cVersion = new LibraryVersion_t("nddsc", nArray);
        this.get_java_library_versions(nArray);
        this._javaVersion = new LibraryVersion_t("nddsjava", nArray);
        this.get_product_versions(nArray);
        this._productVersion = new ProductVersion_t(nArray);
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this._coreVersion).append('-').append(this._cVersion).append('-');
        stringBuffer.append(this._javaVersion);
        this._stringified = stringBuffer.toString();
    }

    private native void get_core_library_versions(int[] var1);

    private native void get_c_library_versions(int[] var1);

    private native void get_java_library_versions(int[] var1);

    private native void get_product_versions(int[] var1);

    private native String get_jni_library_build_number_string();

    static {
        NativeInterface.getInstance().loadNativeLibraries();
        _singleton = new Version();
    }
}

