/*
 * Decompiled with CFR 0.152.
 */
package com.rti.ndds.transport;

import com.rti.dds.infrastructure.StringSeq;
import com.rti.dds.infrastructure.Struct;
import com.rti.dds.util.NativeInterface;

public interface Transport {

    public static class Property_t
    extends Struct {
        public static final int NDDS_TRANSPORT_CLASSID_INVALID = -1;
        public static final int NDDS_TRANSPORT_CLASSID_RESERVED_RANGE = 1000;
        public static final int NDDS_TRANSPORT_PROPERTY_BIT_BUFFER_ALWAYS_LOANED = 2;
        public static final int NDDS_TRANSPORT_PROPERTY_GATHER_SEND_BUFFER_COUNT_MIN = 3;
        public final int classid;
        public final int address_bit_count;
        public final int properties_bitmap;
        public int gather_send_buffer_count_max;
        public int message_size_max;
        public final StringSeq allow_interfaces_list = new StringSeq();
        public final StringSeq deny_interfaces_list = new StringSeq();
        public final StringSeq allow_multicast_interfaces_list = new StringSeq();
        public final StringSeq deny_multicast_interfaces_list = new StringSeq();

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Property_t)) {
                return false;
            }
            Property_t property_t = (Property_t)object;
            return this.classid == property_t.classid && this.address_bit_count == property_t.address_bit_count && this.properties_bitmap == property_t.properties_bitmap && this.gather_send_buffer_count_max == property_t.gather_send_buffer_count_max && this.message_size_max == property_t.message_size_max && this.allow_interfaces_list.equals(property_t.allow_interfaces_list) && this.deny_interfaces_list.equals(property_t.deny_interfaces_list) && this.allow_multicast_interfaces_list.equals(property_t.allow_multicast_interfaces_list) && this.deny_multicast_interfaces_list.equals(property_t.deny_multicast_interfaces_list);
        }

        public int hashCode() {
            return this.classid + this.address_bit_count + this.properties_bitmap + this.gather_send_buffer_count_max + this.message_size_max + this.allow_interfaces_list.size() + this.deny_interfaces_list.size() + this.allow_multicast_interfaces_list.size() + this.deny_multicast_interfaces_list.size();
        }

        protected Property_t(int n, int n2, int n3, int n4, int n5) {
            this.classid = n;
            this.address_bit_count = n2;
            this.properties_bitmap = n3;
            this.gather_send_buffer_count_max = n4;
            this.message_size_max = n5;
        }

        protected void pull_from_nativeI(long l) {
            this.gather_send_buffer_count_max = Property_t.get_native_gather_send_buffer_count_maxI(l);
            this.message_size_max = Property_t.get_native_message_size_max_countI(l);
            this.allow_interfaces_list.pull_from_nativeI(Property_t.get_native_allow_interfaces_listI(l));
            this.deny_interfaces_list.pull_from_nativeI(Property_t.get_native_deny_interfaces_listI(l));
            this.allow_multicast_interfaces_list.pull_from_nativeI(Property_t.get_native_allow_multicast_interfaces_listI(l));
            this.deny_multicast_interfaces_list.pull_from_nativeI(Property_t.get_native_deny_multicast_interfaces_listI(l));
        }

        protected void push_to_nativeI(long l) {
            Property_t.set_native_gather_send_buffer_count_maxI(l, this.gather_send_buffer_count_max);
            Property_t.set_native_message_size_max_countI(l, this.message_size_max);
            this.allow_interfaces_list.push_to_nativeI(Property_t.get_native_allow_interfaces_listI(l));
            this.deny_interfaces_list.push_to_nativeI(Property_t.get_native_deny_interfaces_listI(l));
            this.allow_multicast_interfaces_list.push_to_nativeI(Property_t.get_native_allow_multicast_interfaces_listI(l));
            this.deny_multicast_interfaces_list.push_to_nativeI(Property_t.get_native_deny_multicast_interfaces_listI(l));
        }

        private static native int get_native_gather_send_buffer_count_maxI(long var0);

        private static native void set_native_gather_send_buffer_count_maxI(long var0, int var2);

        private static native int get_native_message_size_max_countI(long var0);

        private static native void set_native_message_size_max_countI(long var0, int var2);

        private static native long get_native_allow_interfaces_listI(long var0);

        private static native long get_native_deny_interfaces_listI(long var0);

        private static native long get_native_allow_multicast_interfaces_listI(long var0);

        private static native long get_native_deny_multicast_interfaces_listI(long var0);

        static {
            NativeInterface.getInstance().loadNativeLibraries();
        }
    }
}

