/*
 * Decompiled with CFR 0.152.
 */
package com.rti.ndds.transport;

import com.rti.dds.domain.DomainParticipant;
import com.rti.dds.domain.DomainParticipantImpl;
import com.rti.dds.infrastructure.RETCODE_BAD_PARAMETER;
import com.rti.dds.infrastructure.RETCODE_ERROR;
import com.rti.dds.infrastructure.RETCODE_UNSUPPORTED;
import com.rti.dds.util.NativeInterface;
import com.rti.ndds.transport.ShmemTransport;
import com.rti.ndds.transport.Transport;
import com.rti.ndds.transport.UDPv4Transport;
import com.rti.ndds.transport.UDPv6Transport;

public final class TransportSupport {
    public static void get_builtin_transport_property(DomainParticipant domainParticipant, Transport.Property_t property_t) {
        if (domainParticipant == null || property_t == null) {
            throw new RETCODE_BAD_PARAMETER("null argument");
        }
        DomainParticipantImpl domainParticipantImpl = (DomainParticipantImpl)domainParticipant;
        domainParticipantImpl.check_aliveI();
        long l = domainParticipantImpl.get_native_pointer();
        long l2 = 0L;
        int n = 0;
        if (property_t instanceof UDPv4Transport.Property_t) {
            l2 = DomainParticipantImpl.get_transport_property_holder_udpv4I(l);
            n = 1;
        } else if (property_t instanceof ShmemTransport.Property_t) {
            l2 = DomainParticipantImpl.get_transport_property_holder_shmemI(l);
            n = 2;
        } else if (property_t instanceof UDPv6Transport.Property_t) {
            l2 = DomainParticipantImpl.get_transport_property_holder_udpv6I(l);
            n = 8;
        } else {
            throw new RETCODE_UNSUPPORTED();
        }
        int n2 = TransportSupport.NDDS_Transport_Support_get_builtin_transport_property(l, n, l2);
        RETCODE_ERROR.check_return_codeI(n2);
        property_t.pull_from_nativeI(l2);
    }

    public static void set_builtin_transport_property(DomainParticipant domainParticipant, Transport.Property_t property_t) {
        if (domainParticipant == null || property_t == null) {
            throw new RETCODE_BAD_PARAMETER("null argument");
        }
        DomainParticipantImpl domainParticipantImpl = (DomainParticipantImpl)domainParticipant;
        domainParticipantImpl.check_aliveI();
        long l = domainParticipantImpl.get_native_pointer();
        long l2 = 0L;
        int n = 0;
        if (property_t instanceof UDPv4Transport.Property_t) {
            l2 = DomainParticipantImpl.get_transport_property_holder_udpv4I(l);
            n = 1;
        } else if (property_t instanceof ShmemTransport.Property_t) {
            l2 = DomainParticipantImpl.get_transport_property_holder_shmemI(l);
            n = 2;
        } else if (property_t instanceof UDPv6Transport.Property_t) {
            l2 = DomainParticipantImpl.get_transport_property_holder_udpv6I(l);
            n = 8;
        } else {
            throw new RETCODE_UNSUPPORTED();
        }
        property_t.push_to_nativeI(l2);
        int n2 = TransportSupport.NDDS_Transport_Support_set_builtin_transport_property(l, n, l2);
        RETCODE_ERROR.check_return_codeI(n2);
    }

    private TransportSupport() {
    }

    private static native int NDDS_Transport_Support_get_builtin_transport_property(long var0, int var2, long var3);

    private static native int NDDS_Transport_Support_set_builtin_transport_property(long var0, int var2, long var3);

    static {
        NativeInterface.getInstance().loadNativeLibraries();
    }
}

