/*
 * Decompiled with CFR 0.152.
 */
package com.rti.ndds.transport;

import com.rti.ndds.transport.Transport;

public interface UDPv6Transport
extends Transport {
    public static final int CLASSID = 5;
    public static final int ADDRESS_BIT_COUNT = 128;
    public static final int BLOCKING_NEVER = 0;
    public static final int BLOCKING_ALWAYS = 1;
    public static final int BLOCKING_UNICAST_ONLY = 2;

    public static class Property_t
    extends Transport.Property_t {
        public int send_socket_buffer_size = 9216;
        public int recv_socket_buffer_size = 9216;
        public int unicast_enabled = 1;
        public int multicast_enabled = 1;
        public int multicast_ttl = 1;
        public int multicast_loopback_disabled = 0;
        public int ignore_loopback_interface = -1;
        public int ignore_nonrunning_interfaces = 0;
        public int no_zero_copy = 0;
        public int send_blocking = 1;
        public int enable_v4mapped = 0;
        public long transport_priority_mask = 0L;
        public int transport_priority_mapping_low = 0;
        public int transport_priority_mapping_high = 255;

        public Property_t() {
            super(5, 128, 0, 16, 9216);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Property_t)) {
                return false;
            }
            Property_t property_t = (Property_t)object;
            return super.equals(object) && this.send_socket_buffer_size == property_t.send_socket_buffer_size && this.recv_socket_buffer_size == property_t.recv_socket_buffer_size && this.unicast_enabled == property_t.unicast_enabled && this.multicast_enabled == property_t.multicast_enabled && this.multicast_ttl == property_t.multicast_ttl && this.multicast_loopback_disabled == property_t.multicast_loopback_disabled && this.ignore_loopback_interface == property_t.ignore_loopback_interface && this.ignore_nonrunning_interfaces == property_t.ignore_nonrunning_interfaces && this.no_zero_copy == property_t.no_zero_copy && this.send_blocking == property_t.send_blocking && this.enable_v4mapped == property_t.enable_v4mapped && this.transport_priority_mask == property_t.transport_priority_mask && this.transport_priority_mapping_low == property_t.transport_priority_mapping_low && this.transport_priority_mapping_high == property_t.transport_priority_mapping_high;
        }

        public int hashCode() {
            return super.hashCode() + this.send_socket_buffer_size + this.recv_socket_buffer_size + this.unicast_enabled + this.multicast_enabled + this.multicast_ttl + this.multicast_loopback_disabled + this.ignore_loopback_interface + this.ignore_nonrunning_interfaces + this.no_zero_copy + this.send_blocking + this.enable_v4mapped + this.transport_priority_mapping_low + this.transport_priority_mapping_high;
        }

        protected void pull_from_nativeI(long l) {
            super.pull_from_nativeI(l);
            this.send_socket_buffer_size = Property_t.get_native_send_socket_buffer_sizeI(l);
            this.recv_socket_buffer_size = Property_t.get_native_recv_socket_buffer_sizeI(l);
            this.unicast_enabled = Property_t.get_native_unicast_enabledI(l);
            this.multicast_enabled = Property_t.get_native_multicast_enabledI(l);
            this.multicast_ttl = Property_t.get_native_multicast_ttlI(l);
            this.multicast_loopback_disabled = Property_t.get_native_multicast_loopback_diabledI(l);
            this.ignore_loopback_interface = Property_t.get_native_ignore_loopback_interfaceI(l);
            this.ignore_nonrunning_interfaces = Property_t.get_native_ignore_nonrunning_interfacesI(l);
            this.no_zero_copy = Property_t.get_native_no_zero_copyI(l);
            this.send_blocking = Property_t.get_native_send_blockingI(l);
            this.enable_v4mapped = Property_t.get_native_enable_v4mappedI(l);
            this.transport_priority_mask = Property_t.get_native_transport_priority_maskI(l);
            this.transport_priority_mapping_low = Property_t.get_native_transport_priority_mapping_lowI(l);
            this.transport_priority_mapping_high = Property_t.get_native_transport_priority_mapping_highI(l);
        }

        protected void push_to_nativeI(long l) {
            super.push_to_nativeI(l);
            Property_t.set_native_send_socket_buffer_sizeI(l, this.send_socket_buffer_size);
            Property_t.set_native_recv_socket_buffer_sizeI(l, this.recv_socket_buffer_size);
            Property_t.set_native_unicast_enabledI(l, this.unicast_enabled);
            Property_t.set_native_multicast_enabledI(l, this.multicast_enabled);
            Property_t.set_native_multicast_ttlI(l, this.multicast_ttl);
            Property_t.set_native_multicast_loopback_diabledI(l, this.multicast_loopback_disabled);
            Property_t.set_native_ignore_loopback_interfaceI(l, this.ignore_loopback_interface);
            Property_t.set_native_ignore_nonrunning_interfacesI(l, this.ignore_nonrunning_interfaces);
            Property_t.set_native_no_zero_copyI(l, this.no_zero_copy);
            Property_t.set_native_send_blockingI(l, this.send_blocking);
            Property_t.set_native_enable_v4mappedI(l, this.enable_v4mapped);
            Property_t.set_native_transport_priority_maskI(l, this.transport_priority_mask);
            Property_t.set_native_transport_priority_mapping_lowI(l, this.transport_priority_mapping_low);
            Property_t.set_native_transport_priority_mapping_highI(l, this.transport_priority_mapping_high);
        }

        private static native int get_native_send_socket_buffer_sizeI(long var0);

        private static native void set_native_send_socket_buffer_sizeI(long var0, int var2);

        private static native int get_native_recv_socket_buffer_sizeI(long var0);

        private static native void set_native_recv_socket_buffer_sizeI(long var0, int var2);

        private static native int get_native_unicast_enabledI(long var0);

        private static native void set_native_unicast_enabledI(long var0, int var2);

        private static native int get_native_multicast_enabledI(long var0);

        private static native void set_native_multicast_enabledI(long var0, int var2);

        private static native int get_native_multicast_ttlI(long var0);

        private static native void set_native_multicast_ttlI(long var0, int var2);

        private static native int get_native_multicast_loopback_diabledI(long var0);

        private static native void set_native_multicast_loopback_diabledI(long var0, int var2);

        private static native int get_native_ignore_loopback_interfaceI(long var0);

        private static native void set_native_ignore_loopback_interfaceI(long var0, int var2);

        private static native int get_native_ignore_nonrunning_interfacesI(long var0);

        private static native void set_native_ignore_nonrunning_interfacesI(long var0, int var2);

        private static native int get_native_no_zero_copyI(long var0);

        private static native void set_native_no_zero_copyI(long var0, int var2);

        private static native int get_native_send_blockingI(long var0);

        private static native void set_native_send_blockingI(long var0, int var2);

        private static native int get_native_enable_v4mappedI(long var0);

        private static native void set_native_enable_v4mappedI(long var0, int var2);

        private static native long get_native_transport_priority_maskI(long var0);

        private static native void set_native_transport_priority_maskI(long var0, long var2);

        private static native int get_native_transport_priority_mapping_lowI(long var0);

        private static native void set_native_transport_priority_mapping_lowI(long var0, int var2);

        private static native int get_native_transport_priority_mapping_highI(long var0);

        private static native void set_native_transport_priority_mapping_highI(long var0, int var2);
    }
}

