/*
 * Decompiled with CFR 0.152.
 */
package com.toc.coredx.DDS;

import com.toc.coredx.DDS.CoreDX_DiscoveryQosPolicy;
import com.toc.coredx.DDS.DiscoveryQosPolicyDiscoveryKind;
import com.toc.coredx.DDS.Duration_t;

public class DiscoveryQosPolicy {
    public Duration_t heartbeat_period = new Duration_t(0, 10000000L);
    public Duration_t dpd_push_period;
    public Duration_t dpd_lease_duration;
    public Duration_t nack_response_delay = new Duration_t(0, 1000L);
    public Duration_t nack_suppress_delay = new Duration_t(0, 0L);
    public long min_buffer_size = 1024L;
    public long max_buffer_size = 32768L;
    public Duration_t heartbeat_response_delay;
    public DiscoveryQosPolicyDiscoveryKind discovery_kind;
    public int guid_pid = 0;
    public boolean send_initial_nack = true;
    public boolean send_msglen_submsg = true;

    public DiscoveryQosPolicy() {
        this.dpd_push_period = new Duration_t(5, 0L);
        this.dpd_lease_duration = new Duration_t(120, 0L);
        this.heartbeat_response_delay = new Duration_t(0, 0L);
        this.discovery_kind = DiscoveryQosPolicyDiscoveryKind.PEER_DISCOVERY_QOS;
    }

    void copyFromCore(CoreDX_DiscoveryQosPolicy coreDX_DiscoveryQosPolicy) {
        this.dpd_push_period = new Duration_t(coreDX_DiscoveryQosPolicy.getDpd_push_period());
        this.dpd_lease_duration = new Duration_t(coreDX_DiscoveryQosPolicy.getDpd_lease_duration());
        this.heartbeat_period = new Duration_t(coreDX_DiscoveryQosPolicy.getHeartbeat_period());
        this.nack_response_delay = new Duration_t(coreDX_DiscoveryQosPolicy.getNack_response_delay());
        this.nack_suppress_delay = new Duration_t(coreDX_DiscoveryQosPolicy.getNack_suppress_delay());
        this.min_buffer_size = coreDX_DiscoveryQosPolicy.getMin_buffer_size();
        this.max_buffer_size = coreDX_DiscoveryQosPolicy.getMax_buffer_size();
        this.heartbeat_response_delay = new Duration_t(coreDX_DiscoveryQosPolicy.getHeartbeat_response_delay());
        this.discovery_kind = DiscoveryQosPolicyDiscoveryKind.coreToEnum(coreDX_DiscoveryQosPolicy.getDiscovery_kind());
        this.guid_pid = coreDX_DiscoveryQosPolicy.getGuid_pid();
        this.send_initial_nack = coreDX_DiscoveryQosPolicy.getSend_initial_nack() != 0;
        this.send_msglen_submsg = coreDX_DiscoveryQosPolicy.getSend_msglen_submsg() != 0;
    }

    CoreDX_DiscoveryQosPolicy toCore() {
        CoreDX_DiscoveryQosPolicy coreDX_DiscoveryQosPolicy = new CoreDX_DiscoveryQosPolicy();
        coreDX_DiscoveryQosPolicy.setDpd_push_period(this.dpd_push_period.toCore());
        coreDX_DiscoveryQosPolicy.setDpd_lease_duration(this.dpd_lease_duration.toCore());
        coreDX_DiscoveryQosPolicy.setHeartbeat_period(this.heartbeat_period.toCore());
        coreDX_DiscoveryQosPolicy.setNack_response_delay(this.nack_response_delay.toCore());
        coreDX_DiscoveryQosPolicy.setNack_suppress_delay(this.nack_suppress_delay.toCore());
        coreDX_DiscoveryQosPolicy.setMin_buffer_size(this.min_buffer_size);
        coreDX_DiscoveryQosPolicy.setMax_buffer_size(this.max_buffer_size);
        coreDX_DiscoveryQosPolicy.setHeartbeat_response_delay(this.heartbeat_response_delay.toCore());
        coreDX_DiscoveryQosPolicy.setDiscovery_kind(DiscoveryQosPolicyDiscoveryKind.toCore(this.discovery_kind));
        coreDX_DiscoveryQosPolicy.setGuid_pid(this.guid_pid);
        coreDX_DiscoveryQosPolicy.setSend_initial_nack((short)(this.send_initial_nack ? 1 : 0));
        coreDX_DiscoveryQosPolicy.setSend_msglen_submsg((short)(this.send_msglen_submsg ? 1 : 0));
        return coreDX_DiscoveryQosPolicy;
    }
}

