/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.IComponent;
import java.util.concurrent.Semaphore;

public abstract class AbstractComponentWrapper<ComponentType extends IComponent<State, ConstructionParameters>, State, ConstructionParameters>
implements IComponent<State, ConstructionParameters> {
    protected ComponentType componentInstance;
    protected ComponentType futureComponentInstance;
    protected final Semaphore semaphore = new Semaphore(Integer.MAX_VALUE);

    public void setComponentInstance(IComponent<?, ?> componentInstance) {
        this.componentInstance = componentInstance;
    }

    public void setFutureComponentInstance(IComponent<?, ?> futureComponentInstance) {
        this.futureComponentInstance = futureComponentInstance;
    }

    public void rollbackComponentInstance() {
        this.futureComponentInstance = null;
        if (this.semaphore.availablePermits() == 0) {
            this.writeUnlock();
        }
    }

    public void commitUpdateComponentInstance() {
        if (this.semaphore.availablePermits() == 0) {
            this.componentInstance = this.futureComponentInstance;
            this.futureComponentInstance = null;
            this.writeUnlock();
        }
    }

    public void updateComponentInstance(boolean transactionalAdaptation) throws Exception {
        Exception exception;
        block10: {
            if (this.futureComponentInstance == null || this.componentInstance == null) {
                System.err.println("this.futureComponentInstance " + this.futureComponentInstance);
                System.err.println("this.componentInstance " + this.componentInstance);
                throw new NullPointerException("Component instance is NULL!");
            }
            this.writeLock();
            exception = null;
            try {
                try {
                    this.futureComponentInstance.loadState(this.componentInstance.getState());
                }
                catch (Exception e) {
                    exception = e;
                    if (!transactionalAdaptation) {
                        this.componentInstance = this.futureComponentInstance;
                        this.futureComponentInstance = null;
                        this.writeUnlock();
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (!transactionalAdaptation) {
                    this.componentInstance = this.futureComponentInstance;
                    this.futureComponentInstance = null;
                    this.writeUnlock();
                }
                throw throwable;
            }
            if (!transactionalAdaptation) {
                this.componentInstance = this.futureComponentInstance;
                this.futureComponentInstance = null;
                this.writeUnlock();
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public boolean loadState(State state) {
        boolean result = this.futureComponentInstance.loadState(state);
        return result;
    }

    @Override
    public boolean initialize(ConstructionParameters state) {
        this.writeLock();
        boolean result = this.componentInstance.initialize(state);
        this.writeUnlock();
        return result;
    }

    private void writeLock() {
        this.semaphore.acquireUninterruptibly(Integer.MAX_VALUE);
    }

    private void writeUnlock() {
        this.semaphore.release(Integer.MAX_VALUE);
    }

    protected void readLock() {
        this.semaphore.acquireUninterruptibly(1);
    }

    protected void readUnlock() {
        this.semaphore.release(1);
    }

    @Override
    public State getState() {
        this.writeLock();
        Object state = this.componentInstance.getState();
        this.writeUnlock();
        return state;
    }

    @Override
    public String getVersion() {
        return this.componentInstance.getVersion();
    }
}

