/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.IComponent;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class BackupCopyOfAbstractComponentWrapper<ComponentType extends IComponent<State, ConstructionParameters>, State, ConstructionParameters>
implements IComponent<State, ConstructionParameters> {
    protected ComponentType componentInstance;
    protected ComponentType futureComponentInstance;
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);

    public void setComponentInstance(IComponent<?, ?> componentInstance) {
        this.componentInstance = componentInstance;
    }

    public void setFutureComponentInstance(IComponent<?, ?> futureComponentInstance) {
        this.futureComponentInstance = futureComponentInstance;
    }

    public void unlockComponentInstance() {
        this.lock.writeLock().unlock();
    }

    public void updateComponentInstance(boolean transactionalAdaptation) {
        this.lock.writeLock().lock();
        this.futureComponentInstance.loadState(this.componentInstance.getState());
        this.componentInstance = this.futureComponentInstance;
        this.futureComponentInstance = null;
        if (!transactionalAdaptation) {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean loadState(State state) {
        boolean result = this.futureComponentInstance.loadState(state);
        return result;
    }

    @Override
    public boolean initialize(ConstructionParameters state) {
        this.lock.writeLock().lock();
        boolean result = this.componentInstance.initialize(state);
        this.lock.writeLock().unlock();
        return result;
    }

    @Override
    public State getState() {
        this.lock.writeLock().lock();
        Object state = this.componentInstance.getState();
        this.lock.writeLock().unlock();
        return state;
    }

    @Override
    public String getVersion() {
        return this.componentInstance.getVersion();
    }
}

