/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.poa;

import java.net.SocketAddress;
import java.util.List;
import java.util.logging.Logger;
import lac.cnclib.helloworld.ReplyServer;
import lac.cnclib.net.NodeConnection;
import lac.cnclib.net.NodeConnectionListener;
import lac.cnclib.net.NodeConnectionServerListener;
import lac.cnclib.net.mrudp.MrUdpNodeConnectionServer;
import lac.cnclib.sddl.PointsOfAttachment;
import lac.cnclib.sddl.message.ApplicationMessage;
import lac.cnclib.sddl.message.ClientLibProtocol;
import lac.cnclib.sddl.message.Message;

public class PoAServer
implements NodeConnectionServerListener,
NodeConnectionListener {
    private static final Logger LOGGER = Logger.getLogger(ReplyServer.class.getCanonicalName());
    private int port = 5500;
    private int handoverPort = 5510;
    private boolean mainServer = false;
    private int msgCounter;
    public MrUdpNodeConnectionServer server;

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("ARGS: \tPORT HANDOVERPORT MAINSERVER");
            System.out.println("SAMPLE:\t5500 5510 true");
        } else {
            int portArg = Integer.parseInt(args[0]);
            int handoverPortArg = Integer.parseInt(args[1]);
            boolean mainSrv = Boolean.parseBoolean(args[2]);
            new PoAServer(portArg, handoverPortArg, mainSrv);
        }
    }

    public PoAServer(int port, int hoverPort, boolean mainSrv) {
        try {
            this.handoverPort = hoverPort;
            this.mainServer = mainSrv;
            this.msgCounter = 0;
            this.server = new MrUdpNodeConnectionServer(port);
            this.server.addListener(this);
            this.server.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void newNodeConnection(NodeConnection remoteCon) {
        LOGGER.fine("Node \t" + remoteCon.getUuid() + "\t connected.");
        remoteCon.addNodeConnectionListener(this);
    }

    @Override
    public void newMessageReceived(NodeConnection remoteCon, Message message) {
        System.out.println("Server 127.0.0.1:" + this.port + " Received Message \t" + message);
        ++this.msgCounter;
        if (this.msgCounter == 4 && this.mainServer) {
            ApplicationMessage appMSG = new ApplicationMessage();
            appMSG.setRecipientID(remoteCon.getUuid());
            PointsOfAttachment poa = new PointsOfAttachment();
            poa.setMustSwitchGateway(false);
            poa.setGatewayList(new String[]{"127.0.0.1:" + this.handoverPort});
            appMSG.setContentObject(poa);
            appMSG.setMsgType(ClientLibProtocol.MSGType.POA);
        }
    }

    @Override
    public void connected(NodeConnection remoteCon) {
        System.out.println("We connected");
    }

    @Override
    public void reconnected(NodeConnection remoteCon, SocketAddress endPoint, boolean wasHandover, boolean wasMandatory) {
        System.out.println("CONNECTED");
    }

    @Override
    public void disconnected(NodeConnection remoteCon) {
        System.out.println("DISCONNECTED FROM " + remoteCon.getUuid());
    }

    @Override
    public void unsentMessages(NodeConnection remoteCon, List<Message> unsentMessages) {
        System.out.println("UNSENT MESSAGES " + remoteCon.getUuid());
        for (Message m : unsentMessages) {
            System.out.println(m);
        }
    }

    @Override
    public void internalException(NodeConnection remoteCon, Exception e) {
    }
}

