/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.sddl.serialization;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import lac.cnclib.net.groups.Group;
import lac.cnclib.net.groups.message.GroupMembershipOperation;
import lac.cnclib.net.groups.message.GroupcastMessage;
import lac.cnclib.net.pubsub.Information;
import lac.cnclib.net.pubsub.InformationData;
import lac.cnclib.net.pubsub.Subscription;
import lac.cnclib.net.pubsub.message.InformationDataMessage;
import lac.cnclib.net.pubsub.message.PublishSubscribeMessage;
import lac.cnclib.net.pubsub.message.SubscriptionMessage;
import lac.cnclib.sddl.Ping;
import lac.cnclib.sddl.PointsOfAttachment;
import lac.cnclib.sddl.message.ApplicationMessage;
import lac.cnclib.sddl.message.ClientLibProtocol;
import lac.cnclib.sddl.message.GroupMembershipMessage;
import lac.cnclib.sddl.message.GroupcastMessage;
import lac.cnclib.sddl.message.Message;
import lac.cnclib.sddl.message.PingMessage;
import lac.cnclib.sddl.message.PointsOfAttachmentMessage;
import lac.cnclib.sddl.message.PublishMessage;
import lac.cnclib.sddl.message.SubscribeMessage;

public class Serialization {
    private static Logger LOGGER;

    static {
        try {
            LOGGER = Logger.getLogger(Serialization.class.getCanonicalName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] toProtocolMessage(Message message) {
        ClientLibProtocol.ClientLibMessage.Builder builder = ClientLibProtocol.ClientLibMessage.newBuilder();
        builder.setMsgType(message.getType());
        if (message.getSenderID() != null) {
            builder.setSenderID(Serialization.uuidBuilder(message.getSenderID()));
        }
        if (message.getSenderGatewayID() != null) {
            builder.setSenderGatewayUUID(Serialization.uuidBuilder(message.getSenderGatewayID()));
        }
        if (message.getRecipientID() != null) {
            builder.setRecipientID(Serialization.uuidBuilder(message.getRecipientID()));
        }
        if (message.getRecipientGatewayID() != null) {
            builder.setRecipientGatewayUUID(Serialization.uuidBuilder(message.getRecipientGatewayID()));
        }
        if (message.getGatewayLogicalTime() != -100L) {
            builder.setGatewayLogicalTime(message.getGatewayLogicalTime());
        }
        builder.addTagList("_default");
        if (message.getTagList() != null && message.getTagList().size() != 0) {
            for (String tag : message.getTagList()) {
                builder.addTagList(tag);
            }
        }
        if (((ApplicationMessage)message).hasContentObject()) {
            builder.setContentPayload(ByteString.copyFrom(Serialization.payloadSerialization(message, message.getContentObject(), message.getType())));
        } else if (message.getContent() != null) {
            builder.setContentPayload(ByteString.copyFrom(message.getContent()));
        } else {
            builder.setContentPayload(ByteString.copyFrom(new byte[]{112}));
        }
        if (message.getPayloadSerialization() != null) {
            builder.setContentType(message.getPayloadSerialization());
        } else {
            builder.setContentType(ClientLibProtocol.PayloadSerialization.JAVA);
        }
        return builder.build().toByteArray();
    }

    private static byte[] payloadSerialization(Message message, Serializable content, ClientLibProtocol.MSGType operationType) {
        ByteString payloadBytes = null;
        try {
            switch (operationType) {
                case APPLICATION: {
                    switch (message.getPayloadSerialization()) {
                        case JAVA: {
                            payloadBytes = ByteString.copyFrom(Serialization.toJavaByteStream(content));
                            break;
                        }
                        case JSON: {
                            payloadBytes = ByteString.copyFrom(((String)((Object)content)).getBytes());
                            break;
                        }
                        default: {
                            payloadBytes = ByteString.copyFrom(Serialization.toJavaByteStream(content));
                        }
                    }
                    if (message.getPayloadSerialization() == null) {
                        message.setPayloadType(ClientLibProtocol.PayloadSerialization.JAVA);
                    }
                    message.setType(ClientLibProtocol.MSGType.APPLICATION);
                    break;
                }
                case GROUPMEMBERSHIP: {
                    payloadBytes = ByteString.copyFrom(Serialization.groupMembershipSerialization(content));
                    message.setPayloadType(ClientLibProtocol.PayloadSerialization.PROTOCOLBUFFER);
                    message.setType(ClientLibProtocol.MSGType.GROUPMEMBERSHIP);
                    break;
                }
                case GROUPCAST: {
                    payloadBytes = ByteString.copyFrom(Serialization.groupcastSerialization(content, Serialization.toProtocolMessage((Message)((GroupcastMessage)content).getMessage())));
                    message.setPayloadType(ClientLibProtocol.PayloadSerialization.PROTOCOLBUFFER);
                    message.setType(ClientLibProtocol.MSGType.GROUPCAST);
                    break;
                }
                case PING: {
                    payloadBytes = ByteString.copyFrom(Serialization.pingSerialization(content));
                    message.setPayloadType(ClientLibProtocol.PayloadSerialization.PROTOCOLBUFFER);
                    message.setType(ClientLibProtocol.MSGType.PING);
                    break;
                }
                case POA: {
                    payloadBytes = ByteString.copyFrom(Serialization.poaSerialization(content));
                    message.setPayloadType(ClientLibProtocol.PayloadSerialization.PROTOCOLBUFFER);
                    message.setType(ClientLibProtocol.MSGType.POA);
                    break;
                }
                case SUBSCRIPTION: {
                    byte[] subscriptionMessage = Serialization.pubsubSubscriptionSerialization(((GroupcastMessage)content).getMessage());
                    payloadBytes = ByteString.copyFrom(Serialization.groupcastSerialization(content, subscriptionMessage));
                    message.setPayloadType(ClientLibProtocol.PayloadSerialization.PROTOCOLBUFFER);
                    message.setType(ClientLibProtocol.MSGType.SUBSCRIPTION);
                    break;
                }
                case PUBSUBEVENT: {
                    byte[] pubsubMessage = Serialization.pubsubPublishSerialization(((GroupcastMessage)content).getMessage());
                    payloadBytes = ByteString.copyFrom(Serialization.groupcastSerialization(content, pubsubMessage));
                    message.setPayloadType(ClientLibProtocol.PayloadSerialization.PROTOCOLBUFFER);
                    message.setType(ClientLibProtocol.MSGType.PUBSUBEVENT);
                    break;
                }
                default: {
                    payloadBytes = ByteString.copyFrom(Serialization.toJavaByteStream(content));
                    message.setPayloadType(ClientLibProtocol.PayloadSerialization.JAVA);
                    break;
                }
            }
        }
        catch (IOException ex) {
            payloadBytes = ByteString.copyFrom(new byte[]{112});
        }
        return payloadBytes.toByteArray();
    }

    public static Message fromProtocolMessage(byte[] byteStream) {
        ApplicationMessage javaMessage = new ApplicationMessage();
        try {
            ClientLibProtocol.ClientLibMessage clientLibMessage = ClientLibProtocol.ClientLibMessage.parseFrom(byteStream);
            if (clientLibMessage.hasSenderID()) {
                javaMessage.setSenderID(Serialization.toJavaUUID(clientLibMessage.getSenderID()));
            }
            if (clientLibMessage.hasSenderGatewayUUID()) {
                javaMessage.setSenderGatewayID(Serialization.toJavaUUID(clientLibMessage.getSenderGatewayUUID()));
            }
            if (clientLibMessage.hasRecipientID()) {
                javaMessage.setRecipientID(Serialization.toJavaUUID(clientLibMessage.getRecipientID()));
            }
            if (clientLibMessage.hasRecipientGatewayUUID()) {
                javaMessage.setRecipientGatewayID(Serialization.toJavaUUID(clientLibMessage.getRecipientGatewayUUID()));
            }
            if (clientLibMessage.hasGatewayLogicalTime()) {
                javaMessage.setGatewayLogicalTime(clientLibMessage.getGatewayLogicalTime());
            }
            if (clientLibMessage.getTagListCount() != 0) {
                javaMessage.setTagList(clientLibMessage.getTagListList());
            }
            if (clientLibMessage.hasContentType()) {
                javaMessage.setPayloadType(clientLibMessage.getContentType());
            }
            javaMessage.setType(clientLibMessage.getMsgType());
            javaMessage.setContent(clientLibMessage.getContentPayload().toByteArray());
            javaMessage.setContentObject(Serialization.payloadDeserialization(clientLibMessage));
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        return javaMessage;
    }

    private static Serializable payloadDeserialization(ClientLibProtocol.ClientLibMessage clientLibMessage) {
        Serializable payload = null;
        byte[] contentPayload = clientLibMessage.getContentPayload().toByteArray();
        switch (clientLibMessage.getMsgType()) {
            case APPLICATION: {
                break;
            }
            case GROUPMEMBERSHIP: {
                payload = Serialization.groupMembershipDeserialization(contentPayload);
                break;
            }
            case GROUPCAST: {
                payload = Serialization.groupcastDeserialization(contentPayload, clientLibMessage.getContentType());
                break;
            }
            case PING: {
                payload = Serialization.pingDeserialization(contentPayload);
                break;
            }
            case POA: {
                payload = Serialization.poaDeserialization(contentPayload);
                break;
            }
            case SUBSCRIPTION: {
                payload = Serialization.pubsubSubscriptionDeserialization(Serialization.groupcastDeserialization(contentPayload, ClientLibProtocol.PayloadSerialization.PROTOCOLBUFFER));
                break;
            }
            case PUBSUBEVENT: {
                payload = Serialization.pubsubPublishDeserialization(Serialization.groupcastDeserialization(contentPayload, ClientLibProtocol.PayloadSerialization.PROTOCOLBUFFER));
                break;
            }
            default: {
                payload = Serialization.fromJavaByteStream(contentPayload);
            }
        }
        return payload;
    }

    private static byte[] pingSerialization(Serializable message) {
        Ping ping = (Ping)message;
        PingMessage.Ping.Builder msgbuilder = PingMessage.Ping.newBuilder();
        msgbuilder.setId(ping.getId());
        msgbuilder.setPong(ping.isPong());
        return msgbuilder.build().toByteArray();
    }

    private static Ping pingDeserialization(byte[] message) {
        PingMessage.Ping pingMessage = null;
        try {
            pingMessage = PingMessage.Ping.parseFrom(message);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        Ping ping = new Ping((byte)pingMessage.getId());
        ping.setPong(ping.isPong());
        return ping;
    }

    private static byte[] poaSerialization(Serializable message) {
        PointsOfAttachment poa = (PointsOfAttachment)message;
        PointsOfAttachmentMessage.PointsOfAttachment.Builder msgbuilder = PointsOfAttachmentMessage.PointsOfAttachment.newBuilder();
        msgbuilder.setSwitchGateway(poa.mustSwitchGateway());
        if (poa.getGatewayList() != null && poa.getGatewayList().length != 0) {
            String[] stringArray = poa.getGatewayList();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String gateway = stringArray[n2];
                msgbuilder.addGatewayList(gateway);
                ++n2;
            }
        }
        return msgbuilder.build().toByteArray();
    }

    private static PointsOfAttachment poaDeserialization(byte[] message) {
        PointsOfAttachment poa = new PointsOfAttachment();
        try {
            PointsOfAttachmentMessage.PointsOfAttachment poaMessage = PointsOfAttachmentMessage.PointsOfAttachment.parseFrom(message);
            int gwListSize = poaMessage.getGatewayListCount();
            String[] gwList = new String[gwListSize];
            int i = 0;
            while (i < gwListSize) {
                gwList[i] = poaMessage.getGatewayList(i);
                ++i;
            }
            poa.setGatewayList(gwList);
            poa.setMustSwitchGateway(poaMessage.getSwitchGateway());
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        return poa;
    }

    private static byte[] groupMembershipSerialization(Serializable message) {
        ClientLibProtocol.Group.Builder groupBuilder;
        GroupMembershipOperation groupMembership = (GroupMembershipOperation)message;
        GroupMembershipMessage.GroupMembership.Builder msgbuilder = GroupMembershipMessage.GroupMembership.newBuilder();
        if (groupMembership.getJoinedGroup() != null && groupMembership.getJoinedGroup().size() != 0) {
            for (Group g : groupMembership.getJoinedGroup()) {
                groupBuilder = ClientLibProtocol.Group.newBuilder();
                groupBuilder.setGroupID(g.getGroupID());
                groupBuilder.setGroupType(g.getGroupType());
                msgbuilder.addGroupsJoined(groupBuilder.build());
            }
        }
        if (groupMembership.getLeftGroup() != null && groupMembership.getLeftGroup().size() != 0) {
            for (Group g : groupMembership.getLeftGroup()) {
                groupBuilder = ClientLibProtocol.Group.newBuilder();
                groupBuilder.setGroupID(g.getGroupID());
                groupBuilder.setGroupType(g.getGroupType());
                msgbuilder.addGroupsLeft(groupBuilder.build());
            }
        }
        return msgbuilder.build().toByteArray();
    }

    private static GroupMembershipOperation groupMembershipDeserialization(byte[] message) {
        GroupMembershipOperation groupMembership = null;
        try {
            GroupMembershipMessage.GroupMembership groupMembershipMessage = GroupMembershipMessage.GroupMembership.parseFrom(message);
            ArrayList<Group> groupsJoined = new ArrayList<Group>();
            ArrayList<Group> groupsLeft = new ArrayList<Group>();
            for (ClientLibProtocol.Group pbufferGroup : groupMembershipMessage.getGroupsJoinedList()) {
                groupsJoined.add(new Group(pbufferGroup.getGroupType(), pbufferGroup.getGroupID()));
            }
            for (ClientLibProtocol.Group pbufferGroup : groupMembershipMessage.getGroupsLeftList()) {
                groupsLeft.add(new Group(pbufferGroup.getGroupType(), pbufferGroup.getGroupID()));
            }
            groupMembership = new GroupMembershipOperation(groupsJoined, groupsLeft);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        return groupMembership;
    }

    private static byte[] groupcastSerialization(Serializable message, byte[] content) {
        GroupcastMessage groupcast = (GroupcastMessage)message;
        GroupcastMessage.Groupcast.Builder msgbuilder = GroupcastMessage.Groupcast.newBuilder();
        if (groupcast.getGroups() != null && groupcast.getGroups().size() != 0) {
            for (Group g : groupcast.getGroups()) {
                ClientLibProtocol.Group.Builder groupBuilder = ClientLibProtocol.Group.newBuilder();
                groupBuilder.setGroupID(g.getGroupID());
                groupBuilder.setGroupType(g.getGroupType());
                msgbuilder.addGroupsToSend(groupBuilder.build());
            }
        }
        msgbuilder.addContent(ByteString.copyFrom(content));
        return msgbuilder.build().toByteArray();
    }

    private static GroupcastMessage groupcastDeserialization(byte[] message, ClientLibProtocol.PayloadSerialization payloadType) {
        ArrayList<Group> groupsToSendJava = new ArrayList<Group>();
        Object payload = null;
        try {
            GroupcastMessage.Groupcast groupcastMessage = GroupcastMessage.Groupcast.parseFrom(message);
            if (!groupcastMessage.getGroupsToSendList().isEmpty()) {
                for (ClientLibProtocol.Group protocolBufferGroup : groupcastMessage.getGroupsToSendList()) {
                    groupsToSendJava.add(new Group(protocolBufferGroup.getGroupType(), protocolBufferGroup.getGroupID()));
                }
            }
            switch (payloadType) {
                case JAVA: {
                    payload = Serialization.fromJavaByteStream(ByteString.copyFrom(groupcastMessage.getContentList()).toByteArray());
                    break;
                }
                case PROTOCOLBUFFER: {
                    payload = ByteString.copyFrom(groupcastMessage.getContentList()).toByteArray();
                    break;
                }
                default: {
                    payload = Serialization.fromJavaByteStream(ByteString.copyFrom(groupcastMessage.getContentList()).toByteArray());
                    break;
                }
            }
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        return new GroupcastMessage((Serializable)payload, (List<Group>)groupsToSendJava);
    }

    private static byte[] pubsubSubscriptionSerialization(Serializable message) {
        SubscriptionMessage submessage = (SubscriptionMessage)((PublishSubscribeMessage)message).getContentObject();
        SubscribeMessage.SubscribeInformation.Builder msgbuilder = SubscribeMessage.SubscribeInformation.newBuilder();
        msgbuilder.setTopic(submessage.getSubscription().getInformation().getInformationClass());
        return msgbuilder.build().toByteArray();
    }

    private static Serializable pubsubSubscriptionDeserialization(Serializable message) {
        GroupcastMessage wrapperMsg = (GroupcastMessage)message;
        PublishSubscribeMessage pubsubMsg = new PublishSubscribeMessage();
        try {
            SubscribeMessage.SubscribeInformation subscriptionInformation = SubscribeMessage.SubscribeInformation.parseFrom((byte[])wrapperMsg.getMessage());
            Subscription sub = new Subscription(new Information(subscriptionInformation.getTopic()));
            SubscriptionMessage sm = new SubscriptionMessage(sub);
            pubsubMsg.setContentObject(sm);
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        return pubsubMsg;
    }

    private static byte[] pubsubPublishSerialization(Serializable message) {
        String key;
        int n;
        int n2;
        String[] stringArray;
        ClientLibProtocol.MapEntry.Builder entry;
        InformationDataMessage infoDataMsg = (InformationDataMessage)((PublishSubscribeMessage)message).getContentObject();
        PublishMessage.PublishInformation.Builder msgbuilder = PublishMessage.PublishInformation.newBuilder();
        if (infoDataMsg.getInformationData().getInformationsProvided().length != 0) {
            ClientLibProtocol.Map.Builder protoBufferInfoMap = ClientLibProtocol.Map.newBuilder();
            entry = ClientLibProtocol.MapEntry.newBuilder();
            stringArray = infoDataMsg.getInformationData().getInformationsProvided();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                key = stringArray[n];
                entry.setKey(key);
                entry.setValue(infoDataMsg.getInformationData().getInformation(key));
                protoBufferInfoMap.addEntries(entry.build());
                ++n;
            }
            msgbuilder.setInformation(protoBufferInfoMap.build());
        }
        if (infoDataMsg.getInformationData().getPropertiesProvided().length != 0) {
            ClientLibProtocol.Map.Builder protoBufferPropMap = ClientLibProtocol.Map.newBuilder();
            entry = ClientLibProtocol.MapEntry.newBuilder();
            stringArray = infoDataMsg.getInformationData().getPropertiesProvided();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                key = stringArray[n];
                entry.setKey(key);
                entry.setValue(infoDataMsg.getInformationData().getProperty(key));
                protoBufferPropMap.addEntries(entry.build());
                ++n;
            }
            msgbuilder.setInformation(protoBufferPropMap.build());
        }
        msgbuilder.setOriginUuid(Serialization.uuidBuilder(((PublishSubscribeMessage)message).getSenderID()));
        return msgbuilder.build().toByteArray();
    }

    private static Serializable pubsubPublishDeserialization(Serializable message) {
        GroupcastMessage wrapperMsg = (GroupcastMessage)message;
        PublishSubscribeMessage pubsubMsg = new PublishSubscribeMessage();
        try {
            PublishMessage.PublishInformation publishInformation = PublishMessage.PublishInformation.parseFrom((byte[])wrapperMsg.getMessage());
            InformationData informationData = new InformationData(publishInformation.getInformationClass());
            if (!publishInformation.hasInformation()) {
                ClientLibProtocol.Map protoBufferInfoMap = publishInformation.getInformation();
                for (ClientLibProtocol.MapEntry entry : protoBufferInfoMap.getEntriesList()) {
                    informationData.addInformation(entry.getKey(), entry.getValue());
                }
            }
            if (!publishInformation.hasProperties()) {
                ClientLibProtocol.Map protoBufferPropMap = publishInformation.getProperties();
                for (ClientLibProtocol.MapEntry entry : protoBufferPropMap.getEntriesList()) {
                    informationData.addProperty(entry.getKey(), entry.getValue());
                }
            }
            pubsubMsg.setContentObject(new InformationDataMessage(informationData));
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        return pubsubMsg;
    }

    private static ClientLibProtocol.UUID uuidBuilder(UUID uuid) {
        ClientLibProtocol.UUID.Builder uuidBuilder = ClientLibProtocol.UUID.newBuilder();
        return uuidBuilder.setLeastSignBits(uuid.getLeastSignificantBits()).setMostSignBits(uuid.getMostSignificantBits()).build();
    }

    private static UUID toJavaUUID(ClientLibProtocol.UUID uuid) {
        return new UUID(uuid.getMostSignBits(), uuid.getLeastSignBits());
    }

    public static byte[] toJavaByteStream(Serializable object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.flush();
        return baos.toByteArray();
    }

    public static Serializable fromJavaByteStream(byte[] byteStream) {
        Serializable reconstructedObject;
        block3: {
            reconstructedObject = null;
            if (byteStream.length != 1 || byteStream[0] != 112) break block3;
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(byteStream);
            ObjectInputStream ois = new ObjectInputStream(bais);
            reconstructedObject = (Serializable)ois.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reconstructedObject;
    }
}

