/*
 * Decompiled with CFR 0.152.
 */
package lac.cnclib.stress;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import lac.cnclib.net.NodeConnection;
import lac.cnclib.net.NodeConnectionListener;
import lac.cnclib.net.mrudp.MrUdpNodeConnection;
import lac.cnclib.sddl.message.ApplicationMessage;
import lac.cnclib.sddl.message.Message;
import lac.cnclib.stress.SomeData;

public class MobileNode
implements Runnable,
NodeConnectionListener {
    protected MrUdpNodeConnection conn;
    protected int id;
    protected boolean ready;
    protected Random random;
    private static int count = 1;

    public MobileNode(int id, InetSocketAddress addr, ScheduledThreadPoolExecutor executor) throws IOException {
        this.id = id;
        this.ready = false;
        this.random = new Random();
        this.conn = new MrUdpNodeConnection();
        this.conn.addNodeConnectionListener(this);
        this.conn.connect(addr);
    }

    @Override
    public void run() {
        if (this.ready) {
            SomeData data = new SomeData(this.id);
            data.setLatitude(this.random.nextDouble() * (double)this.random.nextInt(180));
            data.setLongitude(this.random.nextDouble() * (double)this.random.nextInt(180));
            data.setLuminosity(this.random.nextDouble() * (double)this.random.nextInt(30));
            data.setTemperature(this.random.nextDouble() * (double)this.random.nextInt(50));
            ApplicationMessage msg = new ApplicationMessage();
            msg.setContentObject(data);
            try {
                this.conn.sendMessage(msg);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void connected(NodeConnection remoteCon) {
        System.out.println("NUMBER OF CONNECTIONS: " + count++);
        this.ready = true;
    }

    @Override
    public void reconnected(NodeConnection remoteCon, SocketAddress endPoint, boolean wasHandover, boolean wasMandatory) {
        System.out.println("Reconnected");
    }

    @Override
    public void disconnected(NodeConnection remoteCon) {
        System.out.println("Disconnected");
    }

    @Override
    public void newMessageReceived(NodeConnection remoteCon, Message message) {
        System.out.println("Received");
    }

    @Override
    public void unsentMessages(NodeConnection remoteCon, List<Message> unsentMessages) {
        System.out.println("Unsent");
    }

    @Override
    public void internalException(NodeConnection remoteCon, Exception e) {
        System.out.println("Internal Exception");
    }
}

