/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.gateway.components;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import lac.cnclib.net.groups.message.GroupcastMessage;
import lac.cnet.gateway.data.LocalLogicalTime;
import lac.contextnet.highlyscalablemap.ReadWriteLockMap;

public class FastTotalOrder {
    private final Map<LocalLogicalTime, GroupcastMessage> buffer = new ReadWriteLockMap<LocalLogicalTime, GroupcastMessage>();
    private final Map<UUID, Long> gatewayLogicalTimeCollection;

    public FastTotalOrder(Map<UUID, Long> gatewayLogicalTimeCollection) {
        this.gatewayLogicalTimeCollection = gatewayLogicalTimeCollection;
    }

    public void addMessageIntoBuffer(long time, UUID gatewayId, GroupcastMessage message) {
        LocalLogicalTime localLogicalTime = new LocalLogicalTime(time, gatewayId);
        this.buffer.put(localLogicalTime, message);
    }

    public Map<LocalLogicalTime, GroupcastMessage> checkDeliverableMessages() {
        LinkedHashMap<LocalLogicalTime, GroupcastMessage> deliverable = new LinkedHashMap<LocalLogicalTime, GroupcastMessage>(this.buffer.size(), 1.0f);
        for (Map.Entry<LocalLogicalTime, GroupcastMessage> message : this.buffer.entrySet()) {
            boolean messageDeliverable = true;
            long messageTime = message.getKey().getLocalLogicalTime();
            for (Long gatewayTime : this.gatewayLogicalTimeCollection.values()) {
                if (messageTime < gatewayTime) continue;
                messageDeliverable = false;
                break;
            }
            if (!messageDeliverable) break;
            deliverable.put(message.getKey(), message.getValue());
            this.buffer.remove(message.getKey());
        }
        return deliverable;
    }
}

