/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.groupdefiner.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import lac.cnclib.net.groups.Group;

public class Node
implements Comparable<Node> {
    private UUID nodeId;
    private final Set<Group> groups;

    public Node(UUID nodeId) {
        this.nodeId = nodeId;
        this.groups = new TreeSet<Group>();
    }

    public Node(long MostSignificantBitsID, long LeastSignificantBitsID) {
        this.nodeId = new UUID(MostSignificantBitsID, LeastSignificantBitsID);
        this.groups = new TreeSet<Group>();
    }

    public boolean addGroup(Group group) {
        return this.groups.add(group);
    }

    public void addAllGroups(Collection<Group> groupCollection) {
        this.groups.addAll(groupCollection);
    }

    public void addAllGroups(Set<Integer> groupCollection, int groupType) {
        ArrayList<Group> groups = new ArrayList<Group>(groupCollection.size());
        for (Integer groupId : groupCollection) {
            groups.add(new Group(groupType, groupId));
        }
        this.groups.addAll(groups);
    }

    public void removeAllGroups(Collection<Group> toBeRemovedGroupCollection) {
        this.groups.removeAll(toBeRemovedGroupCollection);
    }

    public void removeAllGroups(Set<Integer> toBeRemovedGroupCollection, int groupType) {
        ArrayList<Group> groups = new ArrayList<Group>(toBeRemovedGroupCollection.size());
        for (Integer groupId : toBeRemovedGroupCollection) {
            groups.add(new Group(groupType, groupId));
        }
        this.groups.removeAll(groups);
    }

    public void setNodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public UUID getNodeId() {
        return this.nodeId;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    @Override
    public int compareTo(Node specifiedNode) {
        return this.nodeId.compareTo(specifiedNode.nodeId);
    }
}

