/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects;

import SddlOpenSpliceTopics.AllGroupsInfoTopic;
import java.util.Arrays;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.objects.GroupInfoStructure;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;

public class AllGroupsInfo
implements ApplicationObject {
    private int requestId;
    private GroupInfoStructure[] groups;

    public AllGroupsInfo() {
    }

    public AllGroupsInfo(int requestId, GroupInfoStructure[] groups) {
        this.requestId = requestId;
        this.groups = groups;
    }

    public AllGroupsInfo(AllGroupsInfoTopic allGroupsInfotTopic) {
        this.requestId = allGroupsInfotTopic.requestId;
        this.groups = this.convertGroups(allGroupsInfotTopic.groups);
    }

    private GroupInfoStructure[] convertGroups(SddlOpenSpliceTopics.GroupInfoStructure[] groupTopic) {
        GroupInfoStructure[] groups = new GroupInfoStructure[groupTopic.length];
        int i = 0;
        while (i < groups.length) {
            groups[i] = new GroupInfoStructure(groupTopic[i]);
            ++i;
        }
        return groups;
    }

    private SddlOpenSpliceTopics.GroupInfoStructure[] convertGroups(GroupInfoStructure[] groupTopic, UniversalDDSLayerFactory.SupportedDDSVendors vendor) {
        SddlOpenSpliceTopics.GroupInfoStructure[] groups = new SddlOpenSpliceTopics.GroupInfoStructure[groupTopic.length];
        int i = 0;
        while (i < groups.length) {
            groups[i] = (SddlOpenSpliceTopics.GroupInfoStructure)groupTopic[i].getSpecificDdsTopic(vendor);
            ++i;
        }
        return groups;
    }

    @Override
    public Object getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        switch (ddsVendor) {
            case OpenSplice: {
                return this.getOpenSpliceTopic();
            }
        }
        return null;
    }

    @Override
    public String getTopicTypeName(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        switch (ddsVendor) {
            case OpenSplice: {
                return AllGroupsInfoTopic.class.getCanonicalName();
            }
        }
        return null;
    }

    AllGroupsInfoTopic getOpenSpliceTopic() {
        AllGroupsInfoTopic allGroupsInfoTopic = new AllGroupsInfoTopic();
        allGroupsInfoTopic.requestId = this.requestId;
        allGroupsInfoTopic.groups = this.convertGroups(this.groups, UniversalDDSLayerFactory.SupportedDDSVendors.OpenSplice);
        return allGroupsInfoTopic;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public void setRequestId(int requestId) {
        this.requestId = requestId;
    }

    public GroupInfoStructure[] getGroups() {
        return this.groups;
    }

    public void setGroups(GroupInfoStructure[] groups) {
        this.groups = groups;
    }

    public String toString() {
        return "AllGroupsInfoTopic [requestId=" + this.requestId + ", groups=" + Arrays.toString(this.groups) + "]";
    }
}

