/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects;

import java.util.UUID;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.topics.rti.ConnectionReportTopic;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;

public class ConnectionReport
implements ApplicationObject {
    private UUID nodeId;
    private UUID gatewayId;
    private boolean connected;

    public ConnectionReport() {
    }

    public ConnectionReport(UUID nodeId, UUID gatewayId, boolean connected) {
        this.nodeId = nodeId;
        this.gatewayId = gatewayId;
        this.connected = connected;
    }

    public ConnectionReport(lac.cnet.sddl.topics.coredx.ConnectionReportTopic connectionReportTopic) {
        this.nodeId = new UUID(connectionReportTopic.mostSignificantBitsVehicleId, connectionReportTopic.leastSignificantBitsVehicleId);
        this.gatewayId = new UUID(connectionReportTopic.mostSignificantBitsGatewayId, connectionReportTopic.leastSignificantBitsGatewayId);
        this.connected = connectionReportTopic.connected;
    }

    public ConnectionReport(ConnectionReportTopic connectionReportTopic) {
        this.nodeId = new UUID(connectionReportTopic.mostSignificantBitsVehicleId, connectionReportTopic.leastSignificantBitsVehicleId);
        this.gatewayId = new UUID(connectionReportTopic.mostSignificantBitsGatewayId, connectionReportTopic.leastSignificantBitsGatewayId);
        this.connected = connectionReportTopic.connected;
    }

    public ConnectionReport(SddlOpenSpliceTopics.ConnectionReportTopic connectionReportTopic) {
        this.nodeId = new UUID(connectionReportTopic.mostSignificantBitsVehicleId, connectionReportTopic.leastSignificantBitsVehicleId);
        this.gatewayId = new UUID(connectionReportTopic.mostSignificantBitsGatewayId, connectionReportTopic.leastSignificantBitsGatewayId);
        this.connected = connectionReportTopic.connected;
    }

    @Override
    public Object getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        if (this.nodeId == null) {
            this.nodeId = new UUID(0L, 0L);
        }
        if (this.gatewayId == null) {
            this.gatewayId = new UUID(0L, 0L);
        }
        switch (ddsVendor) {
            case CoreDX: {
                return this.getCoreDxTopic();
            }
            case RTI: {
                return this.getRtiTopic();
            }
            case OpenSplice: {
                return this.getOpenSpliceTopic();
            }
        }
        return null;
    }

    @Override
    public String getTopicTypeName(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        switch (ddsVendor) {
            case CoreDX: {
                return lac.cnet.sddl.topics.coredx.ConnectionReportTopic.class.getCanonicalName();
            }
            case RTI: {
                return ConnectionReportTopic.class.getCanonicalName();
            }
            case OpenSplice: {
                return SddlOpenSpliceTopics.ConnectionReportTopic.class.getCanonicalName();
            }
        }
        return null;
    }

    lac.cnet.sddl.topics.coredx.ConnectionReportTopic getCoreDxTopic() {
        lac.cnet.sddl.topics.coredx.ConnectionReportTopic connectionReportTopic = new lac.cnet.sddl.topics.coredx.ConnectionReportTopic();
        connectionReportTopic.connected = this.connected;
        connectionReportTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        connectionReportTopic.leastSignificantBitsVehicleId = this.nodeId.getLeastSignificantBits();
        connectionReportTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        connectionReportTopic.mostSignificantBitsVehicleId = this.nodeId.getMostSignificantBits();
        return connectionReportTopic;
    }

    SddlOpenSpliceTopics.ConnectionReportTopic getOpenSpliceTopic() {
        SddlOpenSpliceTopics.ConnectionReportTopic connectionReportTopic = new SddlOpenSpliceTopics.ConnectionReportTopic();
        connectionReportTopic.connected = this.connected;
        connectionReportTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        connectionReportTopic.leastSignificantBitsVehicleId = this.nodeId.getLeastSignificantBits();
        connectionReportTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        connectionReportTopic.mostSignificantBitsVehicleId = this.nodeId.getMostSignificantBits();
        return connectionReportTopic;
    }

    ConnectionReportTopic getRtiTopic() {
        ConnectionReportTopic connectionReportTopic = new ConnectionReportTopic();
        connectionReportTopic.connected = this.connected;
        connectionReportTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        connectionReportTopic.leastSignificantBitsVehicleId = this.nodeId.getLeastSignificantBits();
        connectionReportTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        connectionReportTopic.mostSignificantBitsVehicleId = this.nodeId.getMostSignificantBits();
        return connectionReportTopic;
    }

    public UUID getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public UUID getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(UUID gatewayId) {
        this.gatewayId = gatewayId;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public String toString() {
        return "ConnectionReport [nodeId=" + this.nodeId + ", gatewayId=" + this.gatewayId + ", connected=" + this.connected + "]";
    }
}

