/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects;

import SddlOpenSpliceTopics.GroupTopic;
import java.util.ArrayList;
import java.util.Collection;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.objects.Utils;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;

public class GroupCollection
implements ApplicationObject {
    private int groupType;
    private Collection<Integer> groupIdCollection;

    public GroupCollection() {
    }

    public GroupCollection(int groupType, Collection<Integer> groupIdCollection) {
        this.groupType = groupType;
        this.groupIdCollection = groupIdCollection;
    }

    public GroupCollection(lac.cnet.sddl.topics.coredx.GroupTopic groupTopic) {
        this.groupType = groupTopic.groupType;
        this.groupIdCollection = Utils.convertArrayToCollection(groupTopic.groupIDCollection);
    }

    public GroupCollection(GroupTopic groupTopic) {
        this.groupType = groupTopic.groupType;
        this.groupIdCollection = Utils.convertArrayToCollection(groupTopic.groupIDCollection);
    }

    public GroupCollection(lac.cnet.sddl.topics.rti.GroupTopic groupTopic) {
        this.groupType = groupTopic.groupType;
        this.groupIdCollection = groupTopic.groupIDCollection.subList(0, groupTopic.groupIDCollection.size());
    }

    @Override
    public Object getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        if (this.groupIdCollection == null) {
            this.groupIdCollection = new ArrayList<Integer>(0);
        }
        switch (ddsVendor) {
            case CoreDX: {
                return this.getCoreDxTopic();
            }
            case RTI: {
                return this.getRtiTopic();
            }
            case OpenSplice: {
                return this.getOpenSpliceTopic();
            }
        }
        return null;
    }

    @Override
    public String getTopicTypeName(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        if (this.groupIdCollection == null) {
            this.groupIdCollection = new ArrayList<Integer>(0);
        }
        switch (ddsVendor) {
            case CoreDX: {
                return lac.cnet.sddl.topics.coredx.GroupTopic.class.getCanonicalName();
            }
            case RTI: {
                return lac.cnet.sddl.topics.rti.GroupTopic.class.getCanonicalName();
            }
            case OpenSplice: {
                return GroupTopic.class.getCanonicalName();
            }
        }
        return null;
    }

    lac.cnet.sddl.topics.coredx.GroupTopic getCoreDxTopic() {
        lac.cnet.sddl.topics.coredx.GroupTopic groupTopic = new lac.cnet.sddl.topics.coredx.GroupTopic();
        groupTopic.groupType = this.groupType;
        groupTopic.groupIDCollection = Utils.convertCollectionToArray(this.groupIdCollection);
        return groupTopic;
    }

    GroupTopic getOpenSpliceTopic() {
        GroupTopic groupTopic = new GroupTopic();
        groupTopic.groupType = this.groupType;
        groupTopic.groupIDCollection = Utils.convertCollectionToArray(this.groupIdCollection);
        return groupTopic;
    }

    lac.cnet.sddl.topics.rti.GroupTopic getRtiTopic() {
        lac.cnet.sddl.topics.rti.GroupTopic groupTopic = new lac.cnet.sddl.topics.rti.GroupTopic();
        groupTopic.groupType = this.groupType;
        groupTopic.groupIDCollection.addAll(this.groupIdCollection);
        return groupTopic;
    }

    public int getGroupType() {
        return this.groupType;
    }

    public void setGroupType(int groupType) {
        this.groupType = groupType;
    }

    public Collection<Integer> getGroupIdCollection() {
        return this.groupIdCollection;
    }

    public void setGroupIdCollection(Collection<Integer> groupIdCollection) {
        this.groupIdCollection = groupIdCollection;
    }

    public void addGroupId(int groupId) {
        if (this.groupIdCollection == null) {
            this.groupIdCollection = new ArrayList<Integer>();
        }
        this.groupIdCollection.add(groupId);
    }

    public boolean equals(Object arg0) {
        GroupCollection groupCollection = (GroupCollection)arg0;
        return this.getGroupType() == groupCollection.getGroupType() && this.groupIdCollection.equals(groupCollection.getGroupIdCollection());
    }
}

