/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects;

import java.util.Arrays;
import java.util.UUID;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;

public class GroupInfoStructure
implements ApplicationObject {
    private int groupType;
    private int groupId;
    private UUID[] mobileNodesIds;

    public GroupInfoStructure() {
    }

    public GroupInfoStructure(int groupType, int groupId, UUID[] mobileNodesIds) {
        this.groupId = groupId;
        this.groupType = groupType;
        this.mobileNodesIds = mobileNodesIds;
    }

    private UUID[] convertStringToUUID(String[] ids) {
        UUID[] mobileNodesIds = new UUID[ids.length];
        int i = 0;
        while (i < mobileNodesIds.length) {
            mobileNodesIds[i] = UUID.fromString(ids[i]);
            ++i;
        }
        return mobileNodesIds;
    }

    private String[] convertUUIDToString(UUID[] ids) {
        String[] mobileNodesIds = new String[ids.length];
        int i = 0;
        while (i < mobileNodesIds.length) {
            mobileNodesIds[i] = ids[i].toString();
            ++i;
        }
        return mobileNodesIds;
    }

    public GroupInfoStructure(SddlOpenSpliceTopics.GroupInfoStructure groupInfoStructure) {
        this.groupId = groupInfoStructure.groupId;
        this.groupType = groupInfoStructure.groupType;
        this.mobileNodesIds = this.convertStringToUUID(groupInfoStructure.mobileNodesIds);
    }

    @Override
    public Object getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        switch (ddsVendor) {
            case OpenSplice: {
                return this.getOpenSpliceTopic();
            }
        }
        return null;
    }

    @Override
    public String getTopicTypeName(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        switch (ddsVendor) {
            case OpenSplice: {
                return SddlOpenSpliceTopics.GroupInfoStructure.class.getCanonicalName();
            }
        }
        return null;
    }

    SddlOpenSpliceTopics.GroupInfoStructure getOpenSpliceTopic() {
        SddlOpenSpliceTopics.GroupInfoStructure groupInfoStructure = new SddlOpenSpliceTopics.GroupInfoStructure();
        groupInfoStructure.groupId = this.groupId;
        groupInfoStructure.groupType = this.groupType;
        groupInfoStructure.mobileNodesIds = this.convertUUIDToString(this.mobileNodesIds);
        return groupInfoStructure;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public int getGroupType() {
        return this.groupType;
    }

    public UUID[] getMobileNodesIds() {
        return this.mobileNodesIds;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public void setGroupType(int groupType) {
        this.groupType = groupType;
    }

    public void setMobileNodesIds(UUID[] mobileNodesIds) {
        this.mobileNodesIds = mobileNodesIds;
    }

    public String toString() {
        return "GroupInfoStructure [groupType=" + this.groupType + ", groupId=" + this.groupId + ", mobileNodesIds=" + Arrays.toString(this.mobileNodesIds) + "]";
    }
}

