/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects;

import com.rti.dds.infrastructure.ByteSeq;
import java.util.UUID;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.topics.rti.GroupMessageTopic;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;

public class GroupMessage
implements ApplicationObject {
    private UUID gatewayId;
    private long localLogicalTime;
    private byte[] message;

    public GroupMessage() {
    }

    public GroupMessage(UUID gatewayId, long localLogicalTime, byte[] message) {
        this.gatewayId = gatewayId;
        this.localLogicalTime = localLogicalTime;
        this.message = message;
    }

    public GroupMessage(lac.cnet.sddl.topics.coredx.GroupMessageTopic groupMessageTopic) {
        this.gatewayId = new UUID(groupMessageTopic.mostSignificantBitsGatewayId, groupMessageTopic.leastSignificantBitsGatewayId);
        this.localLogicalTime = groupMessageTopic.localLogicalTime;
        this.message = groupMessageTopic.message;
    }

    public GroupMessage(SddlOpenSpliceTopics.GroupMessageTopic groupMessageTopic) {
        this.gatewayId = new UUID(groupMessageTopic.mostSignificantBitsGatewayId, groupMessageTopic.leastSignificantBitsGatewayId);
        this.localLogicalTime = groupMessageTopic.localLogicalTime;
        this.message = groupMessageTopic.message;
    }

    @Override
    public Object getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        if (this.gatewayId == null) {
            this.gatewayId = new UUID(0L, 0L);
        }
        if (this.message == null) {
            this.message = new byte[0];
        }
        switch (ddsVendor) {
            case CoreDX: {
                return this.getCoreDxTopic();
            }
            case RTI: {
                return this.getRtiTopic();
            }
            case OpenSplice: {
                return this.getOpenSpliceTopic();
            }
        }
        return null;
    }

    @Override
    public String getTopicTypeName(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        switch (ddsVendor) {
            case CoreDX: {
                return lac.cnet.sddl.topics.coredx.GroupMessageTopic.class.getCanonicalName();
            }
            case OpenSplice: {
                return SddlOpenSpliceTopics.GroupMessageTopic.class.getCanonicalName();
            }
            case RTI: {
                return GroupMessageTopic.class.getCanonicalName();
            }
        }
        return null;
    }

    private lac.cnet.sddl.topics.coredx.GroupMessageTopic getCoreDxTopic() {
        lac.cnet.sddl.topics.coredx.GroupMessageTopic groupMessageTopic = new lac.cnet.sddl.topics.coredx.GroupMessageTopic();
        groupMessageTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        groupMessageTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        groupMessageTopic.localLogicalTime = this.localLogicalTime;
        groupMessageTopic.message = this.message;
        return groupMessageTopic;
    }

    private SddlOpenSpliceTopics.GroupMessageTopic getOpenSpliceTopic() {
        SddlOpenSpliceTopics.GroupMessageTopic groupMessageTopic = new SddlOpenSpliceTopics.GroupMessageTopic();
        groupMessageTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        groupMessageTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        groupMessageTopic.localLogicalTime = this.localLogicalTime;
        groupMessageTopic.message = this.message;
        return groupMessageTopic;
    }

    private GroupMessageTopic getRtiTopic() {
        GroupMessageTopic groupMessageTopic = new GroupMessageTopic();
        groupMessageTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        groupMessageTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        groupMessageTopic.localLogicalTime = this.localLogicalTime;
        groupMessageTopic.message = new ByteSeq(this.message);
        return groupMessageTopic;
    }

    public UUID getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(UUID gatewayId) {
        this.gatewayId = gatewayId;
    }

    public long getLocalLogicalTime() {
        return this.localLogicalTime;
    }

    public void setLocalLogicalTime(long localLogicalTime) {
        this.localLogicalTime = localLogicalTime;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void setMessage(byte[] message) {
        this.message = message;
    }
}

