/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects;

import SddlOpenSpliceTopics.GroupRegionTopic;
import SddlOpenSpliceTopics.PointTopic;
import java.util.ArrayList;
import java.util.List;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.objects.Point;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;

public class GroupRegion
implements ApplicationObject {
    private String groupName;
    private int groupType;
    private int groupId;
    private List<Point> polygon;

    public GroupRegion() {
    }

    public GroupRegion(String groupName, int groupType, int groupId, List<Point> polygon) {
        this.groupId = groupId;
        this.groupName = groupName;
        this.groupType = groupType;
        this.polygon = polygon;
    }

    private void fillPolygon(PointTopic[] polygon) {
        this.polygon = new ArrayList<Point>(polygon.length);
        PointTopic[] pointTopicArray = polygon;
        int n = polygon.length;
        int n2 = 0;
        while (n2 < n) {
            PointTopic pointTopic = pointTopicArray[n2];
            this.polygon.add(new Point(pointTopic.longitude, pointTopic.latitude));
            ++n2;
        }
    }

    public GroupRegion(GroupRegionTopic groupRegionTopic) {
        this.groupId = groupRegionTopic.groupId;
        this.groupName = groupRegionTopic.groupName;
        this.groupType = groupRegionTopic.groupType;
        this.fillPolygon(groupRegionTopic.polygon);
    }

    @Override
    public Object getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        if (this.groupName == null) {
            this.groupName = "";
        }
        if (this.polygon == null) {
            this.polygon = new ArrayList<Point>(0);
        }
        switch (ddsVendor) {
            case OpenSplice: {
                return this.getOpenSpliceTopic();
            }
        }
        return null;
    }

    @Override
    public String getTopicTypeName(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        switch (ddsVendor) {
            case OpenSplice: {
                return GroupRegionTopic.class.getCanonicalName();
            }
        }
        return null;
    }

    private GroupRegionTopic getOpenSpliceTopic() {
        GroupRegionTopic groupRegionTopic = new GroupRegionTopic();
        groupRegionTopic.groupId = this.groupId;
        groupRegionTopic.groupName = this.groupName;
        groupRegionTopic.groupType = this.groupType;
        groupRegionTopic.polygon = this.getPointTopic();
        return groupRegionTopic;
    }

    private PointTopic[] getPointTopic() {
        PointTopic[] pointTopics = new PointTopic[this.polygon.size()];
        int i = 0;
        while (i < pointTopics.length) {
            pointTopics[i] = new PointTopic(this.polygon.get(i).getLatitude(), this.polygon.get(i).getLongitude());
            ++i;
        }
        return pointTopics;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public int getGroupType() {
        return this.groupType;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public List<Point> getPolygon() {
        return this.polygon;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setGroupType(int groupType) {
        this.groupType = groupType;
    }

    public void setPolygon(List<Point> polygon) {
        this.polygon = polygon;
    }

    public String toString() {
        return "GroupRegion [groupName=" + this.groupName + ", groupType=" + this.groupType + ", groupId=" + this.groupId + ", polygon=" + this.polygon + "]";
    }
}

