/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects;

import java.util.UUID;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.topics.rti.LoadReportTopic;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;

public class LoadReport
implements ApplicationObject {
    private UUID participantId;
    private UniversalDDSLayerFactory.ParticipantType participantType;
    private byte cpuUsage;
    private int freeMemory;
    private int numberOfConnectedNodes;
    private String participantIp;

    public LoadReport() {
    }

    public LoadReport(UUID participantId, UniversalDDSLayerFactory.ParticipantType participantType, byte cpuUsage, int freeMemory, int numberOfConnectedNodes, String participantIp) {
        this.participantId = participantId;
        this.participantType = participantType;
        this.cpuUsage = cpuUsage;
        this.freeMemory = freeMemory;
        this.numberOfConnectedNodes = numberOfConnectedNodes;
        this.participantIp = participantIp;
    }

    public LoadReport(lac.cnet.sddl.topics.coredx.LoadReportTopic loadReportTopic) {
        this.cpuUsage = loadReportTopic.cpuUsage;
        this.freeMemory = loadReportTopic.freeMemory;
        this.numberOfConnectedNodes = loadReportTopic.numberOfConnectedVehicles;
        this.participantId = new UUID(loadReportTopic.mostSignificantBitsParticipantId, loadReportTopic.leastSignificantBitsParticipantId);
        this.participantIp = loadReportTopic.participantIp;
        this.participantType = UniversalDDSLayerFactory.ParticipantType.values()[loadReportTopic.participantType];
    }

    public LoadReport(SddlOpenSpliceTopics.LoadReportTopic loadReportTopic) {
        this.cpuUsage = loadReportTopic.cpuUsage;
        this.freeMemory = loadReportTopic.freeMemory;
        this.numberOfConnectedNodes = loadReportTopic.numberOfConnectedVehicles;
        this.participantId = new UUID(loadReportTopic.mostSignificantBitsParticipantId, loadReportTopic.leastSignificantBitsParticipantId);
        this.participantIp = loadReportTopic.participantIp;
        this.participantType = UniversalDDSLayerFactory.ParticipantType.values()[loadReportTopic.participantType];
    }

    public LoadReport(LoadReportTopic loadReportTopic) {
        this.cpuUsage = loadReportTopic.cpuUsage;
        this.freeMemory = loadReportTopic.freeMemory;
        this.numberOfConnectedNodes = loadReportTopic.numberOfConnectedVehicles;
        this.participantId = new UUID(loadReportTopic.mostSignificantBitsParticipantId, loadReportTopic.leastSignificantBitsParticipantId);
        this.participantIp = loadReportTopic.participantIp;
        this.participantType = UniversalDDSLayerFactory.ParticipantType.values()[loadReportTopic.participantType];
    }

    @Override
    public Object getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        if (this.participantId == null) {
            this.participantId = new UUID(0L, 0L);
        }
        if (this.participantIp == null) {
            this.participantIp = "";
        }
        if (this.participantType == null) {
            this.participantType = UniversalDDSLayerFactory.ParticipantType.GATEWAY;
        }
        switch (ddsVendor) {
            case CoreDX: {
                return this.getCoreDxTopic();
            }
            case RTI: {
                return this.getRtiTopic();
            }
            case OpenSplice: {
                return this.getOpenSpliceTopic();
            }
        }
        return null;
    }

    @Override
    public String getTopicTypeName(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        switch (ddsVendor) {
            case CoreDX: {
                return lac.cnet.sddl.topics.coredx.LoadReportTopic.class.getCanonicalName();
            }
            case RTI: {
                return LoadReportTopic.class.getCanonicalName();
            }
            case OpenSplice: {
                return SddlOpenSpliceTopics.LoadReportTopic.class.getCanonicalName();
            }
        }
        return null;
    }

    lac.cnet.sddl.topics.coredx.LoadReportTopic getCoreDxTopic() {
        lac.cnet.sddl.topics.coredx.LoadReportTopic loadReportTopic = new lac.cnet.sddl.topics.coredx.LoadReportTopic();
        loadReportTopic.cpuUsage = this.cpuUsage;
        loadReportTopic.freeMemory = this.freeMemory;
        loadReportTopic.leastSignificantBitsParticipantId = this.participantId.getLeastSignificantBits();
        loadReportTopic.mostSignificantBitsParticipantId = this.participantId.getMostSignificantBits();
        loadReportTopic.numberOfConnectedVehicles = this.numberOfConnectedNodes;
        loadReportTopic.participantIp = this.participantIp;
        loadReportTopic.participantType = (byte)this.participantType.ordinal();
        return loadReportTopic;
    }

    SddlOpenSpliceTopics.LoadReportTopic getOpenSpliceTopic() {
        SddlOpenSpliceTopics.LoadReportTopic loadReportTopic = new SddlOpenSpliceTopics.LoadReportTopic();
        loadReportTopic.cpuUsage = this.cpuUsage;
        loadReportTopic.freeMemory = this.freeMemory;
        loadReportTopic.leastSignificantBitsParticipantId = this.participantId.getLeastSignificantBits();
        loadReportTopic.mostSignificantBitsParticipantId = this.participantId.getMostSignificantBits();
        loadReportTopic.numberOfConnectedVehicles = this.numberOfConnectedNodes;
        loadReportTopic.participantIp = this.participantIp;
        loadReportTopic.participantType = (byte)this.participantType.ordinal();
        return loadReportTopic;
    }

    LoadReportTopic getRtiTopic() {
        LoadReportTopic loadReportTopic = new LoadReportTopic();
        loadReportTopic.cpuUsage = this.cpuUsage;
        loadReportTopic.freeMemory = this.freeMemory;
        loadReportTopic.leastSignificantBitsParticipantId = this.participantId.getLeastSignificantBits();
        loadReportTopic.mostSignificantBitsParticipantId = this.participantId.getMostSignificantBits();
        loadReportTopic.numberOfConnectedVehicles = this.numberOfConnectedNodes;
        loadReportTopic.participantIp = this.participantIp;
        loadReportTopic.participantType = (byte)this.participantType.ordinal();
        return loadReportTopic;
    }

    public UUID getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(UUID participantId) {
        this.participantId = participantId;
    }

    public UniversalDDSLayerFactory.ParticipantType getParticipantType() {
        return this.participantType;
    }

    public void setParticipantType(UniversalDDSLayerFactory.ParticipantType participantType) {
        this.participantType = participantType;
    }

    public byte getCpuUsage() {
        return this.cpuUsage;
    }

    public void setCpuUsage(byte cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    public int getFreeMemory() {
        return this.freeMemory;
    }

    public void setFreeMemory(int freeMemory) {
        this.freeMemory = freeMemory;
    }

    public int getNumberOfConnectedNodes() {
        return this.numberOfConnectedNodes;
    }

    public void setNumberOfConnectedNodes(int numberOfConnectedNodes) {
        this.numberOfConnectedNodes = numberOfConnectedNodes;
    }

    public String getParticipantIp() {
        return this.participantIp;
    }

    public void setParticipantIp(String participantIp) {
        this.participantIp = participantIp;
    }

    public String toString() {
        return "LoadReport [participantId=" + this.participantId + ", participantType=" + (Object)((Object)this.participantType) + ", cpuUsage=" + this.cpuUsage + ", freeMemory=" + this.freeMemory + ", numberOfConnectedNodes=" + this.numberOfConnectedNodes + ", participantIp=" + this.participantIp + "]";
    }
}

