/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects;

import SddlOpenSpliceTopics.GroupTopic;
import com.rti.dds.infrastructure.ByteSeq;
import com.rti.dds.infrastructure.StringSeq;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.objects.GroupCollection;
import lac.cnet.sddl.objects.Utils;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;

public class Message
implements ApplicationObject {
    private UUID senderId;
    private UUID gatewayId;
    private UUID recipientId;
    private UUID recipientGatewayId;
    private Collection<String> stamps;
    private byte[] content;
    private Collection<GroupCollection> groupCollection;
    private int localLogicalTime;

    public Message() {
    }

    public Message(UUID senserId, UUID gatewayId, UUID recipientId, UUID recipientGatewayId, Collection<String> stamps, byte[] content, Collection<GroupCollection> groupCollection, int localLogicalTime) {
        this.senderId = senserId;
        this.gatewayId = gatewayId;
        this.recipientId = recipientId;
        this.recipientGatewayId = recipientGatewayId;
        this.stamps = stamps;
        this.content = content;
        this.groupCollection = groupCollection;
        this.localLogicalTime = localLogicalTime;
    }

    public Message(lac.cnet.sddl.topics.coredx.Message messageTopic) {
        this.senderId = new UUID(messageTopic.mspSenderId, messageTopic.lspSenserId);
        this.gatewayId = new UUID(messageTopic.mspSenderGatewayId, messageTopic.lspSenderGatewayId);
        this.recipientId = new UUID(messageTopic.mspRecipientId, messageTopic.lspRecipientId);
        this.recipientGatewayId = new UUID(messageTopic.mspRecipientGatewayId, messageTopic.lspRecipientGatewayId);
        this.stamps = Utils.convertArrayToCollection(messageTopic.stamps);
        this.content = messageTopic.content;
        this.groupCollection = new ArrayList<GroupCollection>(messageTopic.groupCollection.length);
        int i = 0;
        while (i < messageTopic.groupCollection.length) {
            GroupCollection group = new GroupCollection(messageTopic.groupCollection[i]);
            this.groupCollection.add(group);
            ++i;
        }
        this.localLogicalTime = messageTopic.localLogicalTime;
    }

    public Message(SddlOpenSpliceTopics.Message messageTopic) {
        this.senderId = new UUID(messageTopic.mspSenderId, messageTopic.lspSenserId);
        this.gatewayId = new UUID(messageTopic.mspSenderGatewayId, messageTopic.lspSenderGatewayId);
        this.recipientId = new UUID(messageTopic.mspRecipientId, messageTopic.lspRecipientId);
        this.recipientGatewayId = new UUID(messageTopic.mspRecipientGatewayId, messageTopic.lspRecipientGatewayId);
        this.stamps = Utils.convertArrayToCollection(messageTopic.stamps);
        this.content = messageTopic.content;
        this.groupCollection = new ArrayList<GroupCollection>(messageTopic.groupCollection.length);
        int i = 0;
        while (i < messageTopic.groupCollection.length) {
            GroupCollection group = new GroupCollection(messageTopic.groupCollection[i]);
            this.groupCollection.add(group);
            ++i;
        }
        this.localLogicalTime = messageTopic.localLogicalTime;
    }

    public Message(lac.cnet.sddl.topics.rti.Message messageTopic) {
        this.senderId = new UUID(messageTopic.mspSenderId, messageTopic.lspSenserId);
        this.gatewayId = new UUID(messageTopic.mspSenderGatewayId, messageTopic.lspSenderGatewayId);
        this.recipientId = new UUID(messageTopic.mspRecipientId, messageTopic.lspRecipientId);
        this.recipientGatewayId = new UUID(messageTopic.mspRecipientGatewayId, messageTopic.lspRecipientGatewayId);
        this.stamps = messageTopic.stamps.subList(0, messageTopic.stamps.size());
        this.content = messageTopic.content.toArrayByte(new byte[0]);
        this.groupCollection = new ArrayList<GroupCollection>(messageTopic.groupCollection.size());
        for (Object object : messageTopic.groupCollection) {
            lac.cnet.sddl.topics.rti.GroupTopic groupRti = (lac.cnet.sddl.topics.rti.GroupTopic)object;
            GroupCollection group = new GroupCollection(groupRti);
            this.groupCollection.add(group);
        }
        this.localLogicalTime = messageTopic.localLogicalTime;
    }

    @Override
    public Object getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        if (this.content == null) {
            this.content = new byte[0];
        }
        if (this.gatewayId == null) {
            this.gatewayId = new UUID(0L, 0L);
        }
        if (this.groupCollection == null) {
            this.groupCollection = new ArrayList<GroupCollection>(0);
        }
        if (this.recipientGatewayId == null) {
            this.recipientGatewayId = new UUID(0L, 0L);
        }
        if (this.recipientId == null) {
            this.recipientId = new UUID(0L, 0L);
        }
        if (this.senderId == null) {
            this.senderId = new UUID(0L, 0L);
        }
        if (this.stamps == null) {
            this.stamps = new ArrayList<String>(0);
        }
        switch (ddsVendor) {
            case CoreDX: {
                return this.getCoreDxTopic();
            }
            case RTI: {
                return this.getRtiTopic();
            }
            case OpenSplice: {
                return this.getOpenSpliceTopic();
            }
        }
        return null;
    }

    @Override
    public String getTopicTypeName(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        switch (ddsVendor) {
            case CoreDX: {
                return lac.cnet.sddl.topics.coredx.Message.class.getCanonicalName();
            }
            case RTI: {
                return lac.cnet.sddl.topics.rti.Message.class.getCanonicalName();
            }
            case OpenSplice: {
                return SddlOpenSpliceTopics.Message.class.getCanonicalName();
            }
        }
        return null;
    }

    private lac.cnet.sddl.topics.coredx.Message getCoreDxTopic() {
        lac.cnet.sddl.topics.coredx.Message messageTopic = new lac.cnet.sddl.topics.coredx.Message();
        messageTopic.content = this.content;
        messageTopic.lspRecipientGatewayId = this.recipientGatewayId.getLeastSignificantBits();
        messageTopic.mspRecipientGatewayId = this.recipientGatewayId.getMostSignificantBits();
        messageTopic.lspRecipientId = this.recipientId.getLeastSignificantBits();
        messageTopic.mspRecipientId = this.recipientId.getMostSignificantBits();
        messageTopic.lspSenderGatewayId = this.gatewayId.getLeastSignificantBits();
        messageTopic.mspSenderGatewayId = this.gatewayId.getMostSignificantBits();
        messageTopic.lspSenserId = this.senderId.getLeastSignificantBits();
        messageTopic.mspSenderId = this.senderId.getMostSignificantBits();
        messageTopic.stamps = this.stamps.toArray(new String[0]);
        messageTopic.groupCollection = new lac.cnet.sddl.topics.coredx.GroupTopic[this.groupCollection.size()];
        int i = 0;
        for (GroupCollection groupCollection : this.groupCollection) {
            messageTopic.groupCollection[i] = groupCollection.getCoreDxTopic();
            ++i;
        }
        messageTopic.localLogicalTime = this.localLogicalTime;
        return messageTopic;
    }

    private SddlOpenSpliceTopics.Message getOpenSpliceTopic() {
        SddlOpenSpliceTopics.Message messageTopic = new SddlOpenSpliceTopics.Message();
        messageTopic.content = this.content;
        messageTopic.lspRecipientGatewayId = this.recipientGatewayId.getLeastSignificantBits();
        messageTopic.mspRecipientGatewayId = this.recipientGatewayId.getMostSignificantBits();
        messageTopic.lspRecipientId = this.recipientId.getLeastSignificantBits();
        messageTopic.mspRecipientId = this.recipientId.getMostSignificantBits();
        messageTopic.lspSenderGatewayId = this.gatewayId.getLeastSignificantBits();
        messageTopic.mspSenderGatewayId = this.gatewayId.getMostSignificantBits();
        messageTopic.lspSenserId = this.senderId.getLeastSignificantBits();
        messageTopic.mspSenderId = this.senderId.getMostSignificantBits();
        messageTopic.stamps = this.stamps.toArray(new String[0]);
        messageTopic.groupCollection = new GroupTopic[this.groupCollection.size()];
        int i = 0;
        for (GroupCollection groupCollection : this.groupCollection) {
            messageTopic.groupCollection[i] = groupCollection.getOpenSpliceTopic();
            ++i;
        }
        messageTopic.localLogicalTime = this.localLogicalTime;
        return messageTopic;
    }

    private lac.cnet.sddl.topics.rti.Message getRtiTopic() {
        lac.cnet.sddl.topics.rti.Message messageTopic = new lac.cnet.sddl.topics.rti.Message();
        messageTopic.content = new ByteSeq(this.content);
        messageTopic.lspRecipientGatewayId = this.recipientGatewayId.getLeastSignificantBits();
        messageTopic.mspRecipientGatewayId = this.recipientGatewayId.getMostSignificantBits();
        messageTopic.lspRecipientId = this.recipientId.getLeastSignificantBits();
        messageTopic.mspRecipientId = this.recipientId.getMostSignificantBits();
        messageTopic.lspSenderGatewayId = this.gatewayId.getLeastSignificantBits();
        messageTopic.mspSenderGatewayId = this.gatewayId.getMostSignificantBits();
        messageTopic.lspSenserId = this.senderId.getLeastSignificantBits();
        messageTopic.mspSenderId = this.senderId.getMostSignificantBits();
        messageTopic.stamps = new StringSeq(this.stamps);
        for (GroupCollection groupCollection : this.groupCollection) {
            messageTopic.groupCollection.add(groupCollection.getRtiTopic());
        }
        messageTopic.localLogicalTime = this.localLogicalTime;
        return messageTopic;
    }

    public UUID getSenderId() {
        return this.senderId;
    }

    public void setSenderId(UUID senserId) {
        this.senderId = senserId;
    }

    public UUID getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(UUID gatewayId) {
        this.gatewayId = gatewayId;
    }

    public UUID getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(UUID recipientId) {
        this.recipientId = recipientId;
    }

    public UUID getRecipientGatewayId() {
        return this.recipientGatewayId;
    }

    public void setRecipientGatewayId(UUID recipientGatewayId) {
        this.recipientGatewayId = recipientGatewayId;
    }

    public Collection<String> getStamps() {
        return this.stamps;
    }

    public void setStamps(Collection<String> stamps) {
        this.stamps = stamps;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public Collection<GroupCollection> getGroupCollection() {
        return this.groupCollection;
    }

    public void setGroupCollection(Collection<GroupCollection> groupCollection) {
        this.groupCollection = groupCollection;
    }

    public int getLocalLogicalTime() {
        return this.localLogicalTime;
    }

    public void setLocalLogicalTime(int localLogicalTime) {
        this.localLogicalTime = localLogicalTime;
    }
}

