/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.topics.coredx.UnsentMessageTopic;
import lac.cnet.sddl.topics.rti.MessageStructureTopic;
import lac.cnet.sddl.topics.rti.MessageStructureTopicSeq;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;

public class UnsentMessage
implements ApplicationObject {
    private UUID nodeId;
    private UUID gatewayId;
    private Collection<byte[]> unsentMessageCollection;

    public UnsentMessage() {
    }

    public UnsentMessage(UUID nodeId, UUID gatewayId, Collection<byte[]> unsentMessageCollection) {
        this.gatewayId = gatewayId;
        this.nodeId = nodeId;
        this.unsentMessageCollection = unsentMessageCollection;
    }

    public UnsentMessage(UnsentMessageTopic unsentMessageTopic) {
        this.gatewayId = new UUID(unsentMessageTopic.mostSignificantBitsGatewayId, unsentMessageTopic.leastSignificantBitsGatewayId);
        this.nodeId = new UUID(unsentMessageTopic.mostSignificantBitsVehicleId, unsentMessageTopic.leastSignificantBitsVehicleId);
        this.unsentMessageCollection = new ArrayList<byte[]>(unsentMessageTopic.unsentMessages.length);
        int i = 0;
        while (i < unsentMessageTopic.unsentMessages.length) {
            this.unsentMessageCollection.add(unsentMessageTopic.unsentMessages[i].message);
            ++i;
        }
    }

    public UnsentMessage(SddlOpenSpliceTopics.UnsentMessageTopic unsentMessageTopic) {
        this.gatewayId = new UUID(unsentMessageTopic.mostSignificantBitsGatewayId, unsentMessageTopic.leastSignificantBitsGatewayId);
        this.nodeId = new UUID(unsentMessageTopic.mostSignificantBitsVehicleId, unsentMessageTopic.leastSignificantBitsVehicleId);
        this.unsentMessageCollection = new ArrayList<byte[]>(unsentMessageTopic.unsentMessages.length);
        int i = 0;
        while (i < unsentMessageTopic.unsentMessages.length) {
            this.unsentMessageCollection.add(unsentMessageTopic.unsentMessages[i].message);
            ++i;
        }
    }

    public UnsentMessage(lac.cnet.sddl.topics.rti.UnsentMessageTopic unsentMessageTopic) {
        this.gatewayId = new UUID(unsentMessageTopic.mostSignificantBitsGatewayId, unsentMessageTopic.leastSignificantBitsGatewayId);
        this.nodeId = new UUID(unsentMessageTopic.mostSignificantBitsVehicleId, unsentMessageTopic.leastSignificantBitsVehicleId);
        this.unsentMessageCollection = new ArrayList<byte[]>(unsentMessageTopic.unsentMessages.size());
        for (Object object : unsentMessageTopic.unsentMessages) {
            MessageStructureTopic messageStructureTopic = (MessageStructureTopic)object;
            this.unsentMessageCollection.add(messageStructureTopic.message.toArrayByte(new byte[0]));
        }
    }

    @Override
    public Object getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        if (this.gatewayId == null) {
            this.gatewayId = new UUID(0L, 0L);
        }
        if (this.nodeId == null) {
            this.nodeId = new UUID(0L, 0L);
        }
        if (this.unsentMessageCollection == null) {
            this.unsentMessageCollection = new ArrayList<byte[]>(0);
        }
        switch (ddsVendor) {
            case CoreDX: {
                return this.getCoreDxTopic();
            }
            case RTI: {
                return this.getRtiTopic();
            }
            case OpenSplice: {
                return this.getOpenSpliceTopic();
            }
        }
        return null;
    }

    @Override
    public String getTopicTypeName(UniversalDDSLayerFactory.SupportedDDSVendors ddsVendor) {
        switch (ddsVendor) {
            case CoreDX: {
                return UnsentMessageTopic.class.getCanonicalName();
            }
            case RTI: {
                return lac.cnet.sddl.topics.rti.UnsentMessageTopic.class.getCanonicalName();
            }
            case OpenSplice: {
                return SddlOpenSpliceTopics.UnsentMessageTopic.class.getCanonicalName();
            }
        }
        return null;
    }

    UnsentMessageTopic getCoreDxTopic() {
        UnsentMessageTopic unsentMessageTopic = new UnsentMessageTopic();
        unsentMessageTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        unsentMessageTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        unsentMessageTopic.leastSignificantBitsVehicleId = this.nodeId.getLeastSignificantBits();
        unsentMessageTopic.mostSignificantBitsVehicleId = this.nodeId.getMostSignificantBits();
        unsentMessageTopic.unsentMessages = new lac.cnet.sddl.topics.coredx.MessageStructureTopic[this.unsentMessageCollection.size()];
        int i = 0;
        for (byte[] unsentMessage : this.unsentMessageCollection) {
            unsentMessageTopic.unsentMessages[i] = new lac.cnet.sddl.topics.coredx.MessageStructureTopic(unsentMessage);
            ++i;
        }
        return unsentMessageTopic;
    }

    SddlOpenSpliceTopics.UnsentMessageTopic getOpenSpliceTopic() {
        SddlOpenSpliceTopics.UnsentMessageTopic unsentMessageTopic = new SddlOpenSpliceTopics.UnsentMessageTopic();
        unsentMessageTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        unsentMessageTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        unsentMessageTopic.leastSignificantBitsVehicleId = this.nodeId.getLeastSignificantBits();
        unsentMessageTopic.mostSignificantBitsVehicleId = this.nodeId.getMostSignificantBits();
        unsentMessageTopic.unsentMessages = new SddlOpenSpliceTopics.MessageStructureTopic[this.unsentMessageCollection.size()];
        int i = 0;
        for (byte[] unsentMessage : this.unsentMessageCollection) {
            unsentMessageTopic.unsentMessages[i] = new SddlOpenSpliceTopics.MessageStructureTopic(unsentMessage);
            ++i;
        }
        return unsentMessageTopic;
    }

    lac.cnet.sddl.topics.rti.UnsentMessageTopic getRtiTopic() {
        lac.cnet.sddl.topics.rti.UnsentMessageTopic unsentMessageTopic = new lac.cnet.sddl.topics.rti.UnsentMessageTopic();
        unsentMessageTopic.leastSignificantBitsGatewayId = this.gatewayId.getLeastSignificantBits();
        unsentMessageTopic.mostSignificantBitsGatewayId = this.gatewayId.getMostSignificantBits();
        unsentMessageTopic.leastSignificantBitsVehicleId = this.nodeId.getLeastSignificantBits();
        unsentMessageTopic.mostSignificantBitsVehicleId = this.nodeId.getMostSignificantBits();
        unsentMessageTopic.unsentMessages = new MessageStructureTopicSeq(this.unsentMessageCollection.size());
        for (byte[] unsentMessage : this.unsentMessageCollection) {
            MessageStructureTopic messageStructureTopic = new MessageStructureTopic();
            messageStructureTopic.message.addAllByte(unsentMessage);
            unsentMessageTopic.unsentMessages.add(messageStructureTopic);
        }
        return unsentMessageTopic;
    }

    public void addUnsentMessage(byte[] unsentMessage) {
        if (this.unsentMessageCollection == null) {
            this.unsentMessageCollection = new ArrayList<byte[]>();
        }
        this.unsentMessageCollection.add(unsentMessage);
    }

    public UUID getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public UUID getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(UUID gatewayId) {
        this.gatewayId = gatewayId;
    }

    public Collection<byte[]> getUnsentMessageCollection() {
        return this.unsentMessageCollection;
    }

    public void setUnsentMessageCollection(Collection<byte[]> unsentMessageCollection) {
        this.unsentMessageCollection = unsentMessageCollection;
    }
}

