/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.objects.GroupCollection;
import lac.cnet.sddl.objects.ITopicMapper;
import lac.cnet.sddl.objects.Message;

public abstract class Utils {
    private static ITopicMapper TOPIC_MAPPER = null;
    private static final String TOPIC_PREFIX_NAME = String.valueOf(Utils.class.getPackage().getName()) + ".";

    public static ApplicationObject getApplicationObject(Object topicSample) {
        String topicName = topicSample.getClass().getSimpleName();
        String className = null;
        ApplicationObject applicationObject = null;
        if (TOPIC_MAPPER != null) {
            className = TOPIC_MAPPER.getApplicationObjectClassName(topicSample);
        }
        if (className == null) {
            className = topicName.equals(Message.class.getSimpleName()) || topicName.equals(GroupCollection.class.getSimpleName()) ? String.valueOf(TOPIC_PREFIX_NAME) + topicName : String.valueOf(TOPIC_PREFIX_NAME) + topicName.substring(0, topicName.length() - 5);
        }
        try {
            Class<?> topicSeqClass = Class.forName(className);
            Constructor<?> constructor = topicSeqClass.getConstructor(topicSample.getClass());
            applicationObject = (ApplicationObject)constructor.newInstance(topicSample);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return applicationObject;
    }

    public static Collection<Integer> convertArrayToCollection(int[] array) {
        ArrayList<Integer> collection = new ArrayList<Integer>(array.length);
        int i = 0;
        while (i < array.length) {
            collection.add(array[i]);
            ++i;
        }
        return collection;
    }

    public static <T> Collection<T> convertArrayToCollection(T[] array) {
        ArrayList<T> collection = new ArrayList<T>(array.length);
        int i = 0;
        while (i < array.length) {
            collection.add(array[i]);
            ++i;
        }
        return collection;
    }

    public static int[] convertCollectionToArray(Collection<Integer> collection) {
        int[] array = new int[collection.size()];
        int i = 0;
        Iterator<Integer> iterator = collection.iterator();
        while (iterator.hasNext()) {
            int groupOperation;
            array[i] = groupOperation = iterator.next().intValue();
            ++i;
        }
        return array;
    }

    public static void setTopicMapper(ITopicMapper topicMapper) {
        TOPIC_MAPPER = topicMapper;
    }
}

