/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects.test;

import java.util.UUID;
import junit.framework.TestCase;
import lac.cnet.sddl.objects.ConnectionReport;
import lac.cnet.sddl.topics.rti.ConnectionReportTopic;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import org.junit.Test;

public class ConnectionReportTest
extends TestCase {
    @Test
    public final void testConnectionReport() {
        ConnectionReport connectioReport = new ConnectionReport();
        connectioReport.setConnected(true);
        ConnectionReportTest.assertTrue("set/getConnected ERROR", connectioReport.isConnected());
        connectioReport.setConnected(false);
        ConnectionReportTest.assertFalse("set/getConnected ERROR", connectioReport.isConnected());
        UUID gatewayId = UUID.randomUUID();
        connectioReport.setGatewayId(gatewayId);
        ConnectionReportTest.assertTrue("set/getGatewayId ERROR", connectioReport.getGatewayId().equals(gatewayId));
        UUID nodeId = UUID.randomUUID();
        connectioReport.setNodeId(nodeId);
        ConnectionReportTest.assertTrue("set/getNodeId ERROR", connectioReport.getNodeId().equals(nodeId));
    }

    @Test
    public final void testConnectionReportUUIDUUIDBoolean() {
        UUID nodeId = UUID.randomUUID();
        UUID gatewayId = UUID.randomUUID();
        ConnectionReport connectioReport = new ConnectionReport(nodeId, gatewayId, true);
        ConnectionReportTest.assertTrue("getConnected ERROR", connectioReport.isConnected());
        ConnectionReportTest.assertTrue("getGatewayId ERROR", connectioReport.getGatewayId().equals(gatewayId));
        ConnectionReportTest.assertTrue("getNodeId ERROR", connectioReport.getNodeId().equals(nodeId));
    }

    @Test
    public final void testConnectionReportConnectionReportTopic() {
        UUID nodeId = UUID.randomUUID();
        UUID gatewayId = UUID.randomUUID();
        lac.cnet.sddl.topics.coredx.ConnectionReportTopic connectionReportTopic = new lac.cnet.sddl.topics.coredx.ConnectionReportTopic();
        connectionReportTopic.connected = false;
        connectionReportTopic.leastSignificantBitsGatewayId = gatewayId.getLeastSignificantBits();
        connectionReportTopic.mostSignificantBitsGatewayId = gatewayId.getMostSignificantBits();
        connectionReportTopic.leastSignificantBitsVehicleId = nodeId.getLeastSignificantBits();
        connectionReportTopic.mostSignificantBitsVehicleId = nodeId.getMostSignificantBits();
        ConnectionReport connectioReport = new ConnectionReport(connectionReportTopic);
        lac.cnet.sddl.topics.coredx.ConnectionReportTopic coreDxtopic = (lac.cnet.sddl.topics.coredx.ConnectionReportTopic)connectioReport.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.CoreDX);
        ConnectionReportTest.assertEquals("getSpecificDdsTopic(SupportedDDSVendors.CoreDX) ERROR", connectionReportTopic.connected, coreDxtopic.connected);
        ConnectionReportTest.assertEquals("getSpecificDdsTopic(SupportedDDSVendors.CoreDX) ERROR", connectionReportTopic.leastSignificantBitsGatewayId, coreDxtopic.leastSignificantBitsGatewayId);
        ConnectionReportTest.assertEquals("getSpecificDdsTopic(SupportedDDSVendors.CoreDX) ERROR", connectionReportTopic.mostSignificantBitsGatewayId, coreDxtopic.mostSignificantBitsGatewayId);
        ConnectionReportTest.assertEquals("getSpecificDdsTopic(SupportedDDSVendors.CoreDX) ERROR", connectionReportTopic.leastSignificantBitsVehicleId, coreDxtopic.leastSignificantBitsVehicleId);
        ConnectionReportTest.assertEquals("getSpecificDdsTopic(SupportedDDSVendors.CoreDX) ERROR", connectionReportTopic.mostSignificantBitsVehicleId, coreDxtopic.mostSignificantBitsVehicleId);
    }

    @Test
    public final void testConnectionReportConnectionReportTopic1() {
        UUID nodeId = UUID.randomUUID();
        UUID gatewayId = UUID.randomUUID();
        ConnectionReportTopic connectionReportTopic = new ConnectionReportTopic();
        connectionReportTopic.connected = false;
        connectionReportTopic.leastSignificantBitsGatewayId = gatewayId.getLeastSignificantBits();
        connectionReportTopic.mostSignificantBitsGatewayId = gatewayId.getMostSignificantBits();
        connectionReportTopic.leastSignificantBitsVehicleId = nodeId.getLeastSignificantBits();
        connectionReportTopic.mostSignificantBitsVehicleId = nodeId.getMostSignificantBits();
        ConnectionReport connectioReport = new ConnectionReport(connectionReportTopic);
        ConnectionReportTopic rtiTopic = (ConnectionReportTopic)connectioReport.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.RTI);
        ConnectionReportTest.assertEquals("getSpecificDdsTopic(SupportedDDSVendors.CoreDX) ERROR", connectionReportTopic.connected, rtiTopic.connected);
        ConnectionReportTest.assertEquals("getSpecificDdsTopic(SupportedDDSVendors.CoreDX) ERROR", connectionReportTopic.leastSignificantBitsGatewayId, rtiTopic.leastSignificantBitsGatewayId);
        ConnectionReportTest.assertEquals("getSpecificDdsTopic(SupportedDDSVendors.CoreDX) ERROR", connectionReportTopic.mostSignificantBitsGatewayId, rtiTopic.mostSignificantBitsGatewayId);
        ConnectionReportTest.assertEquals("getSpecificDdsTopic(SupportedDDSVendors.CoreDX) ERROR", connectionReportTopic.leastSignificantBitsVehicleId, rtiTopic.leastSignificantBitsVehicleId);
        ConnectionReportTest.assertEquals("getSpecificDdsTopic(SupportedDDSVendors.CoreDX) ERROR", connectionReportTopic.mostSignificantBitsVehicleId, rtiTopic.mostSignificantBitsVehicleId);
    }

    @Test
    public final void testGetSpecificDdsTopic() {
        this.testConnectionReportConnectionReportTopic();
        this.testConnectionReportConnectionReportTopic1();
    }
}

