/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import junit.framework.TestCase;
import lac.cnet.sddl.objects.GroupCollection;
import lac.cnet.sddl.objects.Utils;
import lac.cnet.sddl.topics.coredx.GroupTopic;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import org.junit.Test;

public class GroupCollectionTest
extends TestCase {
    @Test
    public final void testGroupCollection() {
        GroupCollection object = new GroupCollection();
        int groupType = 74;
        ArrayList<Integer> groupIdCollection = new ArrayList<Integer>();
        int i = 0;
        while (i < 15) {
            groupIdCollection.add(i);
            ++i;
        }
        object.setGroupType(groupType);
        object.setGroupIdCollection(groupIdCollection);
        GroupCollectionTest.assertEquals(groupType, object.getGroupType());
        GroupCollectionTest.assertEquals(groupIdCollection, object.getGroupIdCollection());
    }

    @Test
    public final void testGroupCollectionIntCollectionOfInteger() {
        int groupType = 74;
        ArrayList<Integer> groupIdCollection = new ArrayList<Integer>();
        int i = 0;
        while (i < 15) {
            groupIdCollection.add(i);
            ++i;
        }
        GroupCollection object = new GroupCollection(groupType, groupIdCollection);
        GroupCollectionTest.assertEquals(groupType, object.getGroupType());
        GroupCollectionTest.assertEquals(groupIdCollection, object.getGroupIdCollection());
    }

    @Test
    public final void testGroupCollectionGroupTopic() {
        int groupType = 74;
        ArrayList<Integer> groupIdCollection = new ArrayList<Integer>();
        int i = 0;
        while (i < 15) {
            groupIdCollection.add(i);
            ++i;
        }
        GroupTopic coreDx = new GroupTopic();
        coreDx.groupIDCollection = Utils.convertCollectionToArray(groupIdCollection);
        coreDx.groupType = groupType;
        GroupCollection object = new GroupCollection(coreDx);
        lac.cnet.sddl.topics.rti.GroupTopic rti = (lac.cnet.sddl.topics.rti.GroupTopic)object.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.RTI);
        GroupCollectionTest.assertEquals(coreDx.groupType, rti.groupType);
        GroupCollectionTest.assertTrue(Arrays.equals(coreDx.groupIDCollection, rti.groupIDCollection.toArrayInt(new int[0])));
    }

    @Test
    public final void testGroupCollectionGroupTopic1() {
        int groupType = 74;
        ArrayList<Integer> groupIdCollection = new ArrayList<Integer>();
        int i = 0;
        while (i < 15) {
            groupIdCollection.add(i);
            ++i;
        }
        lac.cnet.sddl.topics.rti.GroupTopic rti = new lac.cnet.sddl.topics.rti.GroupTopic();
        rti.groupIDCollection.addAll(groupIdCollection);
        rti.groupType = groupType;
        GroupCollection object = new GroupCollection(rti);
        GroupTopic coreDx = (GroupTopic)object.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.CoreDX);
        GroupCollectionTest.assertEquals(rti.groupType, coreDx.groupType);
        GroupCollectionTest.assertTrue(Arrays.equals(rti.groupIDCollection.toArrayInt(new int[0]), coreDx.groupIDCollection));
    }

    @Test
    public final void testGetSpecificDdsTopic() {
        this.testGroupCollectionGroupTopic();
        this.testGroupCollectionGroupTopic1();
    }

    @Test
    public final void testAddGroupOperation() {
        GroupCollection object = new GroupCollection();
        LinkedList<Integer> collection = new LinkedList<Integer>();
        int i = 0;
        while (i < 10) {
            collection.add(i);
            object.addGroupId(i);
            ++i;
        }
        GroupCollectionTest.assertEquals(collection, object.getGroupIdCollection());
    }
}

