/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.UUID;
import junit.framework.TestCase;
import lac.cnet.sddl.objects.GroupCollection;
import lac.cnet.sddl.objects.Message;
import lac.cnet.sddl.objects.Utils;
import lac.cnet.sddl.topics.coredx.GroupTopic;
import lac.cnet.sddl.topics.rti.GroupTopicSeq;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import org.junit.Test;

public class MessageTest
extends TestCase {
    @Test
    public final void testMessage() {
        UUID senserId = UUID.randomUUID();
        UUID gatewayId = UUID.randomUUID();
        UUID recipientId = UUID.randomUUID();
        UUID recipientGatewayId = UUID.randomUUID();
        LinkedList<String> stamps = new LinkedList<String>();
        byte[] byArray = new byte[7];
        byArray[0] = 10;
        byArray[1] = 15;
        byArray[2] = 81;
        byArray[4] = 92;
        byArray[5] = 68;
        byArray[6] = 94;
        byte[] content = byArray;
        LinkedList<GroupCollection> groupCollection = new LinkedList<GroupCollection>();
        stamps.add("HelLo!");
        ArrayList<Integer> groupIdCollection = new ArrayList<Integer>(3);
        groupIdCollection.add(54);
        groupIdCollection.add(6952);
        groupIdCollection.add(219);
        GroupCollection group = new GroupCollection(10, groupIdCollection);
        groupCollection.add(group);
        Message object = new Message();
        object.setContent(content);
        object.setGatewayId(gatewayId);
        object.setGroupCollection(groupCollection);
        object.setRecipientGatewayId(recipientGatewayId);
        object.setRecipientId(recipientId);
        object.setSenderId(senserId);
        object.setStamps(stamps);
        MessageTest.assertTrue(Arrays.equals(content, object.getContent()));
        MessageTest.assertEquals(gatewayId, object.getGatewayId());
        MessageTest.assertEquals(groupCollection, object.getGroupCollection());
        MessageTest.assertEquals(recipientGatewayId, object.getRecipientGatewayId());
        MessageTest.assertEquals(recipientId, object.getRecipientId());
        MessageTest.assertEquals(senserId, object.getSenderId());
        MessageTest.assertEquals(stamps, object.getStamps());
    }

    @Test
    public final void testMessageUUIDUUIDUUIDUUIDCollectionOfStringByteArrayCollectionOfGroupCollection() {
        UUID senserId = UUID.randomUUID();
        UUID gatewayId = UUID.randomUUID();
        UUID recipientId = UUID.randomUUID();
        UUID recipientGatewayId = UUID.randomUUID();
        int localLogicalTime = 19;
        LinkedList<String> stamps = new LinkedList<String>();
        byte[] byArray = new byte[7];
        byArray[0] = 10;
        byArray[1] = 15;
        byArray[2] = 81;
        byArray[4] = 92;
        byArray[5] = 68;
        byArray[6] = 94;
        byte[] content = byArray;
        LinkedList<GroupCollection> groupCollection = new LinkedList<GroupCollection>();
        stamps.add("HelLo!");
        ArrayList<Integer> groupIdCollection = new ArrayList<Integer>(3);
        groupIdCollection.add(54);
        groupIdCollection.add(6952);
        groupIdCollection.add(219);
        GroupCollection group = new GroupCollection(10, groupIdCollection);
        groupCollection.add(group);
        Message object = new Message(senserId, gatewayId, recipientId, recipientGatewayId, stamps, content, groupCollection, localLogicalTime);
        MessageTest.assertTrue(Arrays.equals(content, object.getContent()));
        MessageTest.assertEquals(gatewayId, object.getGatewayId());
        MessageTest.assertEquals(groupCollection, object.getGroupCollection());
        MessageTest.assertEquals(recipientGatewayId, object.getRecipientGatewayId());
        MessageTest.assertEquals(recipientId, object.getRecipientId());
        MessageTest.assertEquals(senserId, object.getSenderId());
        MessageTest.assertEquals(stamps, object.getStamps());
        MessageTest.assertEquals(localLogicalTime, object.getLocalLogicalTime());
    }

    @Test
    public final void testMessageMessage() {
        GroupTopic groupTopic;
        UUID senserId = UUID.randomUUID();
        UUID gatewayId = UUID.randomUUID();
        UUID recipientId = UUID.randomUUID();
        UUID recipientGatewayId = UUID.randomUUID();
        LinkedList<String> stamps = new LinkedList<String>();
        byte[] byArray = new byte[7];
        byArray[0] = 10;
        byArray[1] = 15;
        byArray[2] = 81;
        byArray[4] = 92;
        byArray[5] = 68;
        byArray[6] = 94;
        byte[] content = byArray;
        LinkedList<GroupCollection> groupCollection = new LinkedList<GroupCollection>();
        stamps.add("HelLo!");
        ArrayList<Integer> groupIdCollection = new ArrayList<Integer>(3);
        groupIdCollection.add(54);
        groupIdCollection.add(6952);
        groupIdCollection.add(219);
        GroupCollection group = new GroupCollection(10, groupIdCollection);
        groupCollection.add(group);
        lac.cnet.sddl.topics.coredx.Message coreDx = new lac.cnet.sddl.topics.coredx.Message();
        coreDx.content = content;
        coreDx.groupCollection = new GroupTopic[1];
        coreDx.groupCollection[0] = groupTopic = new GroupTopic(group.getGroupType(), Utils.convertCollectionToArray(group.getGroupIdCollection()));
        coreDx.lspRecipientGatewayId = recipientGatewayId.getLeastSignificantBits();
        coreDx.mspRecipientGatewayId = recipientGatewayId.getMostSignificantBits();
        coreDx.lspRecipientId = recipientId.getLeastSignificantBits();
        coreDx.mspRecipientId = recipientId.getMostSignificantBits();
        coreDx.lspSenderGatewayId = gatewayId.getLeastSignificantBits();
        coreDx.mspSenderGatewayId = gatewayId.getMostSignificantBits();
        coreDx.lspSenserId = senserId.getLeastSignificantBits();
        coreDx.mspSenderId = senserId.getMostSignificantBits();
        coreDx.stamps = stamps.toArray(new String[0]);
        Message object = new Message(coreDx);
        MessageTest.assertTrue(Arrays.equals(content, object.getContent()));
        MessageTest.assertEquals(gatewayId, object.getGatewayId());
        MessageTest.assertEquals(groupCollection, object.getGroupCollection());
        MessageTest.assertEquals(recipientGatewayId, object.getRecipientGatewayId());
        MessageTest.assertEquals(recipientId, object.getRecipientId());
        MessageTest.assertEquals(senserId, object.getSenderId());
        MessageTest.assertEquals(stamps, object.getStamps());
        lac.cnet.sddl.topics.rti.Message rti = (lac.cnet.sddl.topics.rti.Message)object.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.RTI);
        MessageTest.assertTrue(Arrays.equals(coreDx.content, rti.content.toArrayByte(new byte[0])));
        MessageTest.assertEquals(coreDx.lspSenderGatewayId, rti.lspSenderGatewayId);
        MessageTest.assertEquals(coreDx.mspSenderGatewayId, rti.mspSenderGatewayId);
        MessageTest.assertEquals(coreDx.groupCollection.length, rti.groupCollection.size());
        int i = 0;
        while (i < coreDx.groupCollection.length) {
            GroupCollection groupCoreDx = new GroupCollection(coreDx.groupCollection[i]);
            GroupCollection groupRti = new GroupCollection((lac.cnet.sddl.topics.rti.GroupTopic)rti.groupCollection.get(i));
            MessageTest.assertEquals(groupCoreDx, groupRti);
            ++i;
        }
        MessageTest.assertEquals(rti.lspRecipientGatewayId, coreDx.lspRecipientGatewayId);
        MessageTest.assertEquals(rti.mspRecipientGatewayId, coreDx.mspRecipientGatewayId);
        MessageTest.assertEquals(rti.lspRecipientId, coreDx.lspRecipientId);
        MessageTest.assertEquals(rti.mspRecipientId, coreDx.mspRecipientId);
        MessageTest.assertEquals(rti.lspSenserId, coreDx.lspSenserId);
        MessageTest.assertEquals(rti.lspSenserId, coreDx.lspSenserId);
        MessageTest.assertTrue(Arrays.equals(rti.stamps.toArray(new String[0]), coreDx.stamps));
    }

    @Test
    public final void testMessageMessage1() {
        UUID senserId = UUID.randomUUID();
        UUID gatewayId = UUID.randomUUID();
        UUID recipientId = UUID.randomUUID();
        UUID recipientGatewayId = UUID.randomUUID();
        LinkedList<String> stamps = new LinkedList<String>();
        byte[] byArray = new byte[7];
        byArray[0] = 10;
        byArray[1] = 15;
        byArray[2] = 81;
        byArray[4] = 92;
        byArray[5] = 68;
        byArray[6] = 94;
        byte[] content = byArray;
        LinkedList<GroupCollection> groupCollection = new LinkedList<GroupCollection>();
        stamps.add("HelLo!");
        ArrayList<Integer> groupIdCollection = new ArrayList<Integer>(3);
        groupIdCollection.add(54);
        groupIdCollection.add(6952);
        groupIdCollection.add(219);
        GroupCollection group = new GroupCollection(10, groupIdCollection);
        groupCollection.add(group);
        lac.cnet.sddl.topics.rti.Message rti = new lac.cnet.sddl.topics.rti.Message();
        rti.content.addAllByte(content);
        rti.groupCollection = new GroupTopicSeq();
        lac.cnet.sddl.topics.rti.GroupTopic groupTopic = new lac.cnet.sddl.topics.rti.GroupTopic();
        groupTopic.groupType = group.getGroupType();
        groupTopic.groupIDCollection.addAll(group.getGroupIdCollection());
        rti.groupCollection.add(groupTopic);
        rti.lspRecipientGatewayId = recipientGatewayId.getLeastSignificantBits();
        rti.mspRecipientGatewayId = recipientGatewayId.getMostSignificantBits();
        rti.lspRecipientId = recipientId.getLeastSignificantBits();
        rti.mspRecipientId = recipientId.getMostSignificantBits();
        rti.lspSenderGatewayId = gatewayId.getLeastSignificantBits();
        rti.mspSenderGatewayId = gatewayId.getMostSignificantBits();
        rti.lspSenserId = senserId.getLeastSignificantBits();
        rti.mspSenderId = senserId.getMostSignificantBits();
        rti.stamps.addAll(stamps);
        Message object = new Message(rti);
        MessageTest.assertTrue(Arrays.equals(content, object.getContent()));
        MessageTest.assertEquals(gatewayId, object.getGatewayId());
        MessageTest.assertEquals(groupCollection, object.getGroupCollection());
        MessageTest.assertEquals(recipientGatewayId, object.getRecipientGatewayId());
        MessageTest.assertEquals(recipientId, object.getRecipientId());
        MessageTest.assertEquals(senserId, object.getSenderId());
        MessageTest.assertEquals(stamps, object.getStamps());
        lac.cnet.sddl.topics.coredx.Message coreDx = (lac.cnet.sddl.topics.coredx.Message)object.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.CoreDX);
        MessageTest.assertTrue(Arrays.equals(coreDx.content, rti.content.toArrayByte(new byte[0])));
        MessageTest.assertEquals(rti.lspSenderGatewayId, coreDx.lspSenderGatewayId);
        MessageTest.assertEquals(rti.mspSenderGatewayId, coreDx.mspSenderGatewayId);
        MessageTest.assertEquals(rti.groupCollection.size(), coreDx.groupCollection.length);
        int i = 0;
        while (i < rti.groupCollection.size()) {
            GroupCollection groupCoreDx = new GroupCollection(coreDx.groupCollection[i]);
            GroupCollection groupRti = new GroupCollection((lac.cnet.sddl.topics.rti.GroupTopic)rti.groupCollection.get(i));
            MessageTest.assertEquals(groupCoreDx, groupRti);
            ++i;
        }
        MessageTest.assertEquals(coreDx.lspRecipientGatewayId, rti.lspRecipientGatewayId);
        MessageTest.assertEquals(coreDx.mspRecipientGatewayId, rti.mspRecipientGatewayId);
        MessageTest.assertEquals(coreDx.lspRecipientId, rti.lspRecipientId);
        MessageTest.assertEquals(coreDx.mspRecipientId, rti.mspRecipientId);
        MessageTest.assertEquals(coreDx.lspSenserId, rti.lspSenserId);
        MessageTest.assertEquals(coreDx.lspSenserId, rti.lspSenserId);
        MessageTest.assertTrue(Arrays.equals(rti.stamps.toArray(new String[0]), coreDx.stamps));
    }

    @Test
    public final void testGetSpecificDdsTopic() {
        this.testMessageMessage();
        this.testMessageMessage1();
    }
}

