/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects.test;

import java.util.UUID;
import junit.framework.TestCase;
import lac.cnet.sddl.objects.Ping;
import lac.cnet.sddl.topics.rti.PingTopic;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import org.junit.Test;

public class PingTest
extends TestCase {
    @Test
    public final void testPing() {
        byte pingId = 47;
        UUID gatewayId = UUID.randomUUID();
        UUID nodeId = UUID.randomUUID();
        long timestamp = 65465L;
        boolean pingCore = false;
        boolean ping = true;
        int groupType = 651;
        int groupId = 21;
        Ping object = new Ping();
        object.setGatewayId(gatewayId);
        object.setGroupId(groupId);
        object.setGroupType(groupType);
        object.setNodeId(nodeId);
        object.setPing(ping);
        object.setPingId(pingId);
        object.setPingCore(pingCore);
        object.setTimestamp(timestamp);
        PingTest.assertEquals(pingId, object.getPingId());
        PingTest.assertEquals(gatewayId, object.getGatewayId());
        PingTest.assertEquals(nodeId, object.getNodeId());
        PingTest.assertEquals(timestamp, object.getTimestamp());
        PingTest.assertEquals(pingCore, object.isPingCore());
        PingTest.assertEquals(ping, object.isPing());
        PingTest.assertEquals(groupType, object.getGroupType());
        PingTest.assertEquals(groupId, object.getGroupId());
    }

    @Test
    public final void testPingByteUUIDUUIDLongBooleanBooleanIntInt() {
        byte pingId = 47;
        UUID gatewayId = UUID.randomUUID();
        UUID nodeId = UUID.randomUUID();
        long timestamp = 65465L;
        boolean pingCore = false;
        boolean ping = true;
        int groupType = 651;
        int groupId = 21;
        Ping object = new Ping(pingId, gatewayId, nodeId, timestamp, pingCore, ping, groupType, groupId);
        PingTest.assertEquals(pingId, object.getPingId());
        PingTest.assertEquals(gatewayId, object.getGatewayId());
        PingTest.assertEquals(nodeId, object.getNodeId());
        PingTest.assertEquals(timestamp, object.getTimestamp());
        PingTest.assertEquals(pingCore, object.isPingCore());
        PingTest.assertEquals(ping, object.isPing());
        PingTest.assertEquals(groupType, object.getGroupType());
        PingTest.assertEquals(groupId, object.getGroupId());
    }

    @Test
    public final void testPingPingTopic() {
        byte pingId = 47;
        UUID gatewayId = UUID.randomUUID();
        UUID nodeId = UUID.randomUUID();
        long timestamp = 65465L;
        boolean pingCore = false;
        boolean ping = true;
        int groupType = 651;
        int groupId = 21;
        lac.cnet.sddl.topics.coredx.PingTopic coreDx = new lac.cnet.sddl.topics.coredx.PingTopic();
        coreDx.groupId = groupId;
        coreDx.groupType = groupType;
        coreDx.leastSignificantBitsGatewayId = gatewayId.getLeastSignificantBits();
        coreDx.mostSignificantBitsGatewayId = gatewayId.getMostSignificantBits();
        coreDx.leastSignificantBitsVehicleId = nodeId.getLeastSignificantBits();
        coreDx.mostSignificantBitsVehicleId = nodeId.getMostSignificantBits();
        coreDx.ping = ping;
        coreDx.pingCore = pingCore;
        coreDx.pingId = pingId;
        coreDx.timestamp = timestamp;
        Ping object = new Ping(coreDx);
        PingTest.assertEquals(pingId, object.getPingId());
        PingTest.assertEquals(gatewayId, object.getGatewayId());
        PingTest.assertEquals(nodeId, object.getNodeId());
        PingTest.assertEquals(timestamp, object.getTimestamp());
        PingTest.assertEquals(pingCore, object.isPingCore());
        PingTest.assertEquals(ping, object.isPing());
        PingTest.assertEquals(groupType, object.getGroupType());
        PingTest.assertEquals(groupId, object.getGroupId());
        PingTopic rti = (PingTopic)object.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.RTI);
        PingTest.assertEquals(coreDx.groupId, rti.groupId);
        PingTest.assertEquals(coreDx.groupType, coreDx.groupType);
        PingTest.assertEquals(coreDx.leastSignificantBitsGatewayId, coreDx.leastSignificantBitsGatewayId);
        PingTest.assertEquals(coreDx.mostSignificantBitsGatewayId, coreDx.mostSignificantBitsGatewayId);
        PingTest.assertEquals(coreDx.leastSignificantBitsVehicleId, coreDx.leastSignificantBitsVehicleId);
        PingTest.assertEquals(coreDx.mostSignificantBitsVehicleId, coreDx.mostSignificantBitsVehicleId);
        PingTest.assertEquals(coreDx.ping, coreDx.ping);
        PingTest.assertEquals(coreDx.pingCore, coreDx.pingCore);
        PingTest.assertEquals(coreDx.pingId, coreDx.pingId);
        PingTest.assertEquals(coreDx.timestamp, coreDx.timestamp);
    }

    @Test
    public final void testPingPingTopic1() {
        byte pingId = 47;
        UUID gatewayId = UUID.randomUUID();
        UUID nodeId = UUID.randomUUID();
        long timestamp = 65465L;
        boolean pingCore = false;
        boolean ping = true;
        int groupType = 651;
        int groupId = 21;
        PingTopic rti = new PingTopic();
        rti.groupId = groupId;
        rti.groupType = groupType;
        rti.leastSignificantBitsGatewayId = gatewayId.getLeastSignificantBits();
        rti.mostSignificantBitsGatewayId = gatewayId.getMostSignificantBits();
        rti.leastSignificantBitsVehicleId = nodeId.getLeastSignificantBits();
        rti.mostSignificantBitsVehicleId = nodeId.getMostSignificantBits();
        rti.ping = ping;
        rti.pingCore = pingCore;
        rti.pingId = pingId;
        rti.timestamp = timestamp;
        Ping object = new Ping(rti);
        PingTest.assertEquals(pingId, object.getPingId());
        PingTest.assertEquals(gatewayId, object.getGatewayId());
        PingTest.assertEquals(nodeId, object.getNodeId());
        PingTest.assertEquals(timestamp, object.getTimestamp());
        PingTest.assertEquals(pingCore, object.isPingCore());
        PingTest.assertEquals(ping, object.isPing());
        PingTest.assertEquals(groupType, object.getGroupType());
        PingTest.assertEquals(groupId, object.getGroupId());
        lac.cnet.sddl.topics.coredx.PingTopic coreDx = (lac.cnet.sddl.topics.coredx.PingTopic)object.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.CoreDX);
        PingTest.assertEquals(coreDx.groupId, rti.groupId);
        PingTest.assertEquals(coreDx.groupType, coreDx.groupType);
        PingTest.assertEquals(coreDx.leastSignificantBitsGatewayId, coreDx.leastSignificantBitsGatewayId);
        PingTest.assertEquals(coreDx.mostSignificantBitsGatewayId, coreDx.mostSignificantBitsGatewayId);
        PingTest.assertEquals(coreDx.leastSignificantBitsVehicleId, coreDx.leastSignificantBitsVehicleId);
        PingTest.assertEquals(coreDx.mostSignificantBitsVehicleId, coreDx.mostSignificantBitsVehicleId);
        PingTest.assertEquals(coreDx.ping, coreDx.ping);
        PingTest.assertEquals(coreDx.pingCore, coreDx.pingCore);
        PingTest.assertEquals(coreDx.pingId, coreDx.pingId);
        PingTest.assertEquals(coreDx.timestamp, coreDx.timestamp);
    }
}

