/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.objects.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import junit.framework.TestCase;
import lac.cnet.sddl.objects.UnsentMessage;
import lac.cnet.sddl.topics.coredx.UnsentMessageTopic;
import lac.cnet.sddl.topics.rti.MessageStructureTopic;
import lac.cnet.sddl.topics.rti.MessageStructureTopicSeq;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import org.junit.Test;

public class UnsentMessageTest
extends TestCase {
    @Test
    public final void testUnsentMessage() {
        UUID nodeId = UUID.randomUUID();
        UUID gatewayId = UUID.randomUUID();
        ArrayList<byte[]> unsentMessageCollection = new ArrayList<byte[]>();
        byte[] array = new byte[]{1, 2, 3};
        byte[] array1 = new byte[]{4, 65, 86, 45, 64};
        unsentMessageCollection.add(array);
        unsentMessageCollection.add(array1);
        UnsentMessage object = new UnsentMessage();
        object.setGatewayId(gatewayId);
        object.setNodeId(nodeId);
        object.setUnsentMessageCollection(unsentMessageCollection);
        UnsentMessageTest.assertEquals(nodeId, object.getNodeId());
        UnsentMessageTest.assertEquals(gatewayId, object.getGatewayId());
        UnsentMessageTest.assertEquals(unsentMessageCollection, object.getUnsentMessageCollection());
    }

    @Test
    public final void testUnsentMessageUUIDUUIDCollectionOfbyte() {
        UUID nodeId = UUID.randomUUID();
        UUID gatewayId = UUID.randomUUID();
        ArrayList<byte[]> unsentMessageCollection = new ArrayList<byte[]>();
        byte[] array = new byte[]{1, 2, 3};
        byte[] array1 = new byte[]{4, 65, 86, 45, 64};
        unsentMessageCollection.add(array);
        unsentMessageCollection.add(array1);
        UnsentMessage object = new UnsentMessage(nodeId, gatewayId, unsentMessageCollection);
        UnsentMessageTest.assertEquals(nodeId, object.getNodeId());
        UnsentMessageTest.assertEquals(gatewayId, object.getGatewayId());
        UnsentMessageTest.assertEquals(unsentMessageCollection, object.getUnsentMessageCollection());
    }

    @Test
    public final void testUnsentMessageUnsentMessageTopic() {
        UUID nodeId = UUID.randomUUID();
        UUID gatewayId = UUID.randomUUID();
        ArrayList<byte[]> unsentMessageCollection = new ArrayList<byte[]>();
        byte[] array = new byte[]{1, 2, 3};
        byte[] array1 = new byte[]{4, 65, 86, 45, 64};
        unsentMessageCollection.add(array);
        unsentMessageCollection.add(array1);
        UnsentMessageTopic coreDx = new UnsentMessageTopic();
        coreDx.leastSignificantBitsGatewayId = gatewayId.getLeastSignificantBits();
        coreDx.mostSignificantBitsGatewayId = gatewayId.getMostSignificantBits();
        coreDx.leastSignificantBitsVehicleId = nodeId.getLeastSignificantBits();
        coreDx.mostSignificantBitsVehicleId = nodeId.getMostSignificantBits();
        coreDx.unsentMessages = new lac.cnet.sddl.topics.coredx.MessageStructureTopic[unsentMessageCollection.size()];
        int i = 0;
        for (byte[] unsentMessage : unsentMessageCollection) {
            coreDx.unsentMessages[i] = new lac.cnet.sddl.topics.coredx.MessageStructureTopic(unsentMessage);
            ++i;
        }
        UnsentMessage object = new UnsentMessage(coreDx);
        UnsentMessageTest.assertEquals(nodeId, object.getNodeId());
        UnsentMessageTest.assertEquals(gatewayId, object.getGatewayId());
        UnsentMessageTest.assertEquals(unsentMessageCollection, object.getUnsentMessageCollection());
        lac.cnet.sddl.topics.rti.UnsentMessageTopic rti = (lac.cnet.sddl.topics.rti.UnsentMessageTopic)object.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.RTI);
        UnsentMessageTest.assertEquals(rti.leastSignificantBitsGatewayId, coreDx.leastSignificantBitsGatewayId);
        UnsentMessageTest.assertEquals(rti.leastSignificantBitsVehicleId, coreDx.leastSignificantBitsVehicleId);
        UnsentMessageTest.assertEquals(rti.mostSignificantBitsGatewayId, coreDx.mostSignificantBitsGatewayId);
        UnsentMessageTest.assertEquals(rti.mostSignificantBitsVehicleId, coreDx.mostSignificantBitsVehicleId);
        i = 0;
        while (i < unsentMessageCollection.size()) {
            UnsentMessageTest.assertTrue(Arrays.equals(((MessageStructureTopic)rti.unsentMessages.get((int)i)).message.toArrayByte(new byte[0]), coreDx.unsentMessages[i].message));
            ++i;
        }
    }

    @Test
    public final void testUnsentMessageUnsentMessageTopic1() {
        UUID nodeId = UUID.randomUUID();
        UUID gatewayId = UUID.randomUUID();
        ArrayList<byte[]> unsentMessageCollection = new ArrayList<byte[]>();
        byte[] array = new byte[]{1, 2, 3};
        byte[] array1 = new byte[]{4, 65, 86, 45, 64};
        unsentMessageCollection.add(array);
        unsentMessageCollection.add(array1);
        lac.cnet.sddl.topics.rti.UnsentMessageTopic rti = new lac.cnet.sddl.topics.rti.UnsentMessageTopic();
        rti.leastSignificantBitsGatewayId = gatewayId.getLeastSignificantBits();
        rti.mostSignificantBitsGatewayId = gatewayId.getMostSignificantBits();
        rti.leastSignificantBitsVehicleId = nodeId.getLeastSignificantBits();
        rti.mostSignificantBitsVehicleId = nodeId.getMostSignificantBits();
        rti.unsentMessages = new MessageStructureTopicSeq();
        int i = 0;
        for (byte[] unsentMessage : unsentMessageCollection) {
            MessageStructureTopic message = new MessageStructureTopic();
            message.message.addAllByte(unsentMessage);
            rti.unsentMessages.add(message);
            ++i;
        }
        UnsentMessage object = new UnsentMessage(rti);
        UnsentMessageTest.assertEquals(nodeId, object.getNodeId());
        UnsentMessageTest.assertEquals(gatewayId, object.getGatewayId());
        UnsentMessageTest.assertEquals(unsentMessageCollection.size(), object.getUnsentMessageCollection().size());
        i = 0;
        while (i < unsentMessageCollection.size()) {
            UnsentMessageTest.assertTrue(Arrays.equals((byte[])unsentMessageCollection.get(i), (byte[])((List)object.getUnsentMessageCollection()).get(i)));
            ++i;
        }
        UnsentMessageTopic coreDx = (UnsentMessageTopic)object.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.CoreDX);
        UnsentMessageTest.assertEquals(coreDx.leastSignificantBitsGatewayId, rti.leastSignificantBitsGatewayId);
        UnsentMessageTest.assertEquals(coreDx.leastSignificantBitsVehicleId, rti.leastSignificantBitsVehicleId);
        UnsentMessageTest.assertEquals(coreDx.mostSignificantBitsGatewayId, rti.mostSignificantBitsGatewayId);
        UnsentMessageTest.assertEquals(coreDx.mostSignificantBitsVehicleId, rti.mostSignificantBitsVehicleId);
        i = 0;
        while (i < unsentMessageCollection.size()) {
            UnsentMessageTest.assertTrue(Arrays.equals(((MessageStructureTopic)rti.unsentMessages.get((int)i)).message.toArrayByte(new byte[0]), coreDx.unsentMessages[i].message));
            ++i;
        }
    }
}

