/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.topics.coredx;

import com.toc.coredx.DDS.CoreDX_FieldDef;
import com.toc.coredx.DDS.DataReader;
import com.toc.coredx.DDS.DataWriter;
import com.toc.coredx.DDS.DomainParticipant;
import com.toc.coredx.DDS.Publisher;
import com.toc.coredx.DDS.ReturnCode_t;
import com.toc.coredx.DDS.SWIGTYPE_p__DataReader;
import com.toc.coredx.DDS.SWIGTYPE_p__DataWriter;
import com.toc.coredx.DDS.Subscriber;
import com.toc.coredx.DDS.Topic;
import com.toc.coredx.DDS.TopicDescription;
import com.toc.coredx.DDS.TypeSupport;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import lac.cnet.sddl.topics.coredx.MessageStructureTopic;
import lac.cnet.sddl.topics.coredx.MessageStructureTopicDataReader;
import lac.cnet.sddl.topics.coredx.MessageStructureTopicDataWriter;

public final class MessageStructureTopicTypeSupport
implements TypeSupport {
    private long cTypeSupport = 0L;

    @Override
    public ReturnCode_t register_type(DomainParticipant dp, String type_name) {
        if (dp.check_version("3", "6", "8") != 0) {
            System.out.println("WARNING: MessageStructureTopic TypeSupport version does not match CoreDX Library version.");
            System.out.println("This may cause software instability or crashes.");
        }
        return dp.register_type(this, type_name);
    }

    @Override
    public String get_type_name() {
        return "MessageStructureTopic";
    }

    @Override
    public long getCTypeSupport() {
        return this.cTypeSupport;
    }

    public MessageStructureTopicTypeSupport() {
        MessageStructureTopic tmp = new MessageStructureTopic();
        this.cTypeSupport = DomainParticipant.createTypeSupport(this, this.getClass().getName(), tmp.getClass().getName());
    }

    @Override
    public DataReader create_datareader(Subscriber sub, TopicDescription td, SWIGTYPE_p__DataReader jni_dr) {
        return new MessageStructureTopicDataReader(sub, td, jni_dr);
    }

    @Override
    public DataWriter create_datawriter(Publisher pub, Topic topic, SWIGTYPE_p__DataWriter jni_dw) {
        return new MessageStructureTopicDataWriter(pub, topic, jni_dw);
    }

    public int marshall(ByteBuffer out_stream, MessageStructureTopic src) {
        int size = 0;
        if (out_stream == null) {
            size = size + 3 & 0xFFFFFFFC;
            size += 4;
            if (src.message != null) {
                int i1 = 0;
                while (i1 < src.message.length) {
                    ++size;
                    ++i1;
                }
            }
            size += 4;
        } else {
            int offset = 0;
            out_stream.clear();
            out_stream.order(ByteOrder.LITTLE_ENDIAN);
            out_stream.put((byte)0);
            out_stream.put((byte)1);
            out_stream.put((byte)0);
            out_stream.put((byte)0);
            while ((offset & 3) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 4;
            out_stream.putInt(src.message.length);
            int i1 = 0;
            while (i1 < src.message.length) {
                ++offset;
                out_stream.put(src.message[i1]);
                ++i1;
            }
            size = out_stream.position();
        }
        return size;
    }

    public int marshall_fixed_size() {
        return 0;
    }

    public int marshall_key(ByteBuffer out_stream, MessageStructureTopic src) {
        int size = 0;
        if (out_stream == null) {
            size += 4;
        } else {
            boolean offset = false;
            out_stream.clear();
            out_stream.order(ByteOrder.LITTLE_ENDIAN);
            out_stream.put((byte)0);
            out_stream.put((byte)1);
            out_stream.put((byte)0);
            out_stream.put((byte)0);
            size = out_stream.position();
        }
        return size;
    }

    public int marshall_key_hash(ByteBuffer out_stream, MessageStructureTopic src) {
        int size = 0;
        if (out_stream != null) {
            boolean offset = false;
            out_stream.clear();
            out_stream.order(ByteOrder.BIG_ENDIAN);
            size = out_stream.position();
        }
        return size;
    }

    public boolean key_must_hash() {
        return false;
    }

    public int unmarshall(MessageStructureTopic t, ByteBuffer data, int s) {
        int offset = 0;
        data.get();
        byte encoding = data.get();
        data.getShort();
        if ((encoding & 1) == 0) {
            data.order(ByteOrder.BIG_ENDIAN);
        } else {
            data.order(ByteOrder.LITTLE_ENDIAN);
        }
        if ((encoding & 0xFE) == 0) {
            while ((offset & 3) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 4;
            int slen1 = data.getInt();
            t.message = new byte[slen1];
            int i1 = 0;
            while (i1 < t.message.length) {
                ++offset;
                t.message[i1] = data.get();
                ++i1;
            }
        }
        return 1;
    }

    public int unmarshall_key(MessageStructureTopic t, ByteBuffer data, int s) {
        boolean offset = false;
        data.get();
        byte encoding = data.get();
        data.getShort();
        if ((encoding & 1) == 0) {
            data.order(ByteOrder.BIG_ENDIAN);
        } else {
            data.order(ByteOrder.LITTLE_ENDIAN);
        }
        return 1;
    }

    public int unmarshall_key_hash(MessageStructureTopic t, ByteBuffer data, int s) {
        boolean offset = false;
        data.order(ByteOrder.BIG_ENDIAN);
        return 0;
    }

    public int gen_typecode(ByteBuffer b) {
        byte[] byArray = new byte[82];
        byArray[0] = 10;
        byArray[4] = 76;
        byArray[8] = 22;
        byArray[12] = 77;
        byArray[13] = 101;
        byArray[14] = 115;
        byArray[15] = 115;
        byArray[16] = 97;
        byArray[17] = 103;
        byArray[18] = 101;
        byArray[19] = 83;
        byArray[20] = 116;
        byArray[21] = 114;
        byArray[22] = 117;
        byArray[23] = 99;
        byArray[24] = 116;
        byArray[25] = 117;
        byArray[26] = 114;
        byArray[27] = 101;
        byArray[28] = 84;
        byArray[29] = 111;
        byArray[30] = 112;
        byArray[31] = 105;
        byArray[32] = 99;
        byArray[36] = 1;
        byArray[40] = 40;
        byArray[44] = 8;
        byArray[48] = 109;
        byArray[49] = 101;
        byArray[50] = 115;
        byArray[51] = 115;
        byArray[52] = 97;
        byArray[53] = 103;
        byArray[54] = 101;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[64] = 14;
        byArray[68] = 12;
        byArray[72] = -1;
        byArray[73] = -1;
        byArray[74] = -1;
        byArray[75] = -1;
        byArray[76] = 9;
        byte[] tc_data = byArray;
        if (b != null) {
            b.put(tc_data, 0, tc_data.length);
        }
        return tc_data.length;
    }

    public int get_typecode_enc() {
        return 1;
    }

    public int get_encoding() {
        return 0;
    }

    public int get_decoding() {
        return 0;
    }

    public boolean has_key() {
        return false;
    }

    public MessageStructureTopic alloc() {
        return new MessageStructureTopic();
    }

    public void clear(MessageStructureTopic instance) {
        instance.clear();
    }

    public void destroy(MessageStructureTopic instance) {
    }

    public void copy(MessageStructureTopic to, MessageStructureTopic from) {
        to.copy(from);
    }

    public boolean get_field(String fieldname, CoreDX_FieldDef fdef) {
        return false;
    }
}

