/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.topics.coredx;

import com.toc.coredx.DDS.CoreDX_FieldDef;
import com.toc.coredx.DDS.DataReader;
import com.toc.coredx.DDS.DataWriter;
import com.toc.coredx.DDS.DomainParticipant;
import com.toc.coredx.DDS.Publisher;
import com.toc.coredx.DDS.ReturnCode_t;
import com.toc.coredx.DDS.SWIGTYPE_p__DataReader;
import com.toc.coredx.DDS.SWIGTYPE_p__DataWriter;
import com.toc.coredx.DDS.Subscriber;
import com.toc.coredx.DDS.Topic;
import com.toc.coredx.DDS.TopicDescription;
import com.toc.coredx.DDS.TypeSupport;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import lac.cnet.sddl.topics.coredx.PingTopic;
import lac.cnet.sddl.topics.coredx.PingTopicDataReader;
import lac.cnet.sddl.topics.coredx.PingTopicDataWriter;

public final class PingTopicTypeSupport
implements TypeSupport {
    private long cTypeSupport = 0L;

    @Override
    public ReturnCode_t register_type(DomainParticipant dp, String type_name) {
        if (dp.check_version("3", "6", "8") != 0) {
            System.out.println("WARNING: PingTopic TypeSupport version does not match CoreDX Library version.");
            System.out.println("This may cause software instability or crashes.");
        }
        return dp.register_type(this, type_name);
    }

    @Override
    public String get_type_name() {
        return "PingTopic";
    }

    @Override
    public long getCTypeSupport() {
        return this.cTypeSupport;
    }

    public PingTopicTypeSupport() {
        PingTopic tmp = new PingTopic();
        this.cTypeSupport = DomainParticipant.createTypeSupport(this, this.getClass().getName(), tmp.getClass().getName());
    }

    @Override
    public DataReader create_datareader(Subscriber sub, TopicDescription td, SWIGTYPE_p__DataReader jni_dr) {
        return new PingTopicDataReader(sub, td, jni_dr);
    }

    @Override
    public DataWriter create_datawriter(Publisher pub, Topic topic, SWIGTYPE_p__DataWriter jni_dw) {
        return new PingTopicDataWriter(pub, topic, jni_dw);
    }

    public int marshall(ByteBuffer out_stream, PingTopic src) {
        int size = 0;
        if (out_stream == null) {
            ++size;
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            ++size;
            ++size;
            size = size + 3 & 0xFFFFFFFC;
            size += 4;
            size = size + 3 & 0xFFFFFFFC;
            size += 4;
            size += 4;
        } else {
            int offset = 0;
            out_stream.clear();
            out_stream.order(ByteOrder.LITTLE_ENDIAN);
            out_stream.put((byte)0);
            out_stream.put((byte)1);
            out_stream.put((byte)0);
            out_stream.put((byte)0);
            ++offset;
            out_stream.put(src.pingId);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.leastSignificantBitsGatewayId);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.mostSignificantBitsGatewayId);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.leastSignificantBitsVehicleId);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.mostSignificantBitsVehicleId);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.timestamp);
            ++offset;
            out_stream.put((byte)(src.pingCore ? 1 : 0));
            ++offset;
            out_stream.put((byte)(src.ping ? 1 : 0));
            while ((offset & 3) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 4;
            out_stream.putInt(src.groupType);
            while ((offset & 3) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 4;
            out_stream.putInt(src.groupId);
            size = out_stream.position();
        }
        return size;
    }

    public int marshall_fixed_size() {
        return 64;
    }

    public int marshall_key(ByteBuffer out_stream, PingTopic src) {
        int size = 0;
        if (out_stream == null) {
            ++size;
            size += 4;
        } else {
            int offset = 0;
            out_stream.clear();
            out_stream.order(ByteOrder.LITTLE_ENDIAN);
            out_stream.put((byte)0);
            out_stream.put((byte)1);
            out_stream.put((byte)0);
            out_stream.put((byte)0);
            ++offset;
            out_stream.put(src.pingId);
            size = out_stream.position();
        }
        return size;
    }

    public int marshall_key_hash(ByteBuffer out_stream, PingTopic src) {
        int size = 0;
        if (out_stream == null) {
            ++size;
        } else {
            int offset = 0;
            out_stream.clear();
            out_stream.order(ByteOrder.BIG_ENDIAN);
            ++offset;
            out_stream.put(src.pingId);
            size = out_stream.position();
        }
        return size;
    }

    public boolean key_must_hash() {
        return false;
    }

    public int unmarshall(PingTopic t, ByteBuffer data, int s) {
        int offset = 0;
        data.get();
        byte encoding = data.get();
        data.getShort();
        if ((encoding & 1) == 0) {
            data.order(ByteOrder.BIG_ENDIAN);
        } else {
            data.order(ByteOrder.LITTLE_ENDIAN);
        }
        if ((encoding & 0xFE) == 0) {
            ++offset;
            t.pingId = data.get();
            while ((offset & 7) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 8;
            t.leastSignificantBitsGatewayId = data.getLong();
            while ((offset & 7) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 8;
            t.mostSignificantBitsGatewayId = data.getLong();
            while ((offset & 7) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 8;
            t.leastSignificantBitsVehicleId = data.getLong();
            while ((offset & 7) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 8;
            t.mostSignificantBitsVehicleId = data.getLong();
            while ((offset & 7) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 8;
            t.timestamp = data.getLong();
            ++offset;
            t.pingCore = data.get() != 0;
            ++offset;
            t.ping = data.get() != 0;
            while ((offset & 3) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 4;
            t.groupType = data.getInt();
            while ((offset & 3) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 4;
            t.groupId = data.getInt();
        }
        return 1;
    }

    public int unmarshall_key(PingTopic t, ByteBuffer data, int s) {
        int offset = 0;
        data.get();
        byte encoding = data.get();
        data.getShort();
        if ((encoding & 1) == 0) {
            data.order(ByteOrder.BIG_ENDIAN);
        } else {
            data.order(ByteOrder.LITTLE_ENDIAN);
        }
        if ((encoding & 0xFE) == 0) {
            ++offset;
            t.pingId = data.get();
        }
        return 1;
    }

    public int unmarshall_key_hash(PingTopic t, ByteBuffer data, int s) {
        int offset = 0;
        data.order(ByteOrder.BIG_ENDIAN);
        ++offset;
        t.pingId = data.get();
        return 0;
    }

    public int gen_typecode(ByteBuffer b) {
        byte[] byArray = new byte[382];
        byArray[0] = 10;
        byArray[4] = 120;
        byArray[5] = 1;
        byArray[8] = 10;
        byArray[12] = 80;
        byArray[13] = 105;
        byArray[14] = 110;
        byArray[15] = 103;
        byArray[16] = 84;
        byArray[17] = 111;
        byArray[18] = 112;
        byArray[19] = 105;
        byArray[20] = 99;
        byArray[24] = 10;
        byArray[28] = 24;
        byArray[32] = 7;
        byArray[36] = 112;
        byArray[37] = 105;
        byArray[38] = 110;
        byArray[39] = 103;
        byArray[40] = 73;
        byArray[41] = 100;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = 1;
        byArray[48] = 9;
        byArray[54] = 46;
        byArray[56] = 30;
        byArray[60] = 108;
        byArray[61] = 101;
        byArray[62] = 97;
        byArray[63] = 115;
        byArray[64] = 116;
        byArray[65] = 83;
        byArray[66] = 105;
        byArray[67] = 103;
        byArray[68] = 110;
        byArray[69] = 105;
        byArray[70] = 102;
        byArray[71] = 105;
        byArray[72] = 99;
        byArray[73] = 97;
        byArray[74] = 110;
        byArray[75] = 116;
        byArray[76] = 66;
        byArray[77] = 105;
        byArray[78] = 116;
        byArray[79] = 115;
        byArray[80] = 71;
        byArray[81] = 97;
        byArray[82] = 116;
        byArray[83] = 101;
        byArray[84] = 119;
        byArray[85] = 97;
        byArray[86] = 121;
        byArray[87] = 73;
        byArray[88] = 100;
        byArray[92] = -1;
        byArray[93] = -1;
        byArray[96] = 17;
        byArray[102] = 46;
        byArray[104] = 29;
        byArray[108] = 109;
        byArray[109] = 111;
        byArray[110] = 115;
        byArray[111] = 116;
        byArray[112] = 83;
        byArray[113] = 105;
        byArray[114] = 103;
        byArray[115] = 110;
        byArray[116] = 105;
        byArray[117] = 102;
        byArray[118] = 105;
        byArray[119] = 99;
        byArray[120] = 97;
        byArray[121] = 110;
        byArray[122] = 116;
        byArray[123] = 66;
        byArray[124] = 105;
        byArray[125] = 116;
        byArray[126] = 115;
        byArray[127] = 71;
        byArray[128] = 97;
        byArray[129] = 116;
        byArray[130] = 101;
        byArray[131] = 119;
        byArray[132] = 97;
        byArray[133] = 121;
        byArray[134] = 73;
        byArray[135] = 100;
        byArray[138] = -1;
        byArray[139] = -1;
        byArray[144] = 17;
        byArray[150] = 46;
        byArray[152] = 30;
        byArray[156] = 108;
        byArray[157] = 101;
        byArray[158] = 97;
        byArray[159] = 115;
        byArray[160] = 116;
        byArray[161] = 83;
        byArray[162] = 105;
        byArray[163] = 103;
        byArray[164] = 110;
        byArray[165] = 105;
        byArray[166] = 102;
        byArray[167] = 105;
        byArray[168] = 99;
        byArray[169] = 97;
        byArray[170] = 110;
        byArray[171] = 116;
        byArray[172] = 66;
        byArray[173] = 105;
        byArray[174] = 116;
        byArray[175] = 115;
        byArray[176] = 86;
        byArray[177] = 101;
        byArray[178] = 104;
        byArray[179] = 105;
        byArray[180] = 99;
        byArray[181] = 108;
        byArray[182] = 101;
        byArray[183] = 73;
        byArray[184] = 100;
        byArray[188] = -1;
        byArray[189] = -1;
        byArray[192] = 17;
        byArray[198] = 46;
        byArray[200] = 29;
        byArray[204] = 109;
        byArray[205] = 111;
        byArray[206] = 115;
        byArray[207] = 116;
        byArray[208] = 83;
        byArray[209] = 105;
        byArray[210] = 103;
        byArray[211] = 110;
        byArray[212] = 105;
        byArray[213] = 102;
        byArray[214] = 105;
        byArray[215] = 99;
        byArray[216] = 97;
        byArray[217] = 110;
        byArray[218] = 116;
        byArray[219] = 66;
        byArray[220] = 105;
        byArray[221] = 116;
        byArray[222] = 115;
        byArray[223] = 86;
        byArray[224] = 101;
        byArray[225] = 104;
        byArray[226] = 105;
        byArray[227] = 99;
        byArray[228] = 108;
        byArray[229] = 101;
        byArray[230] = 73;
        byArray[231] = 100;
        byArray[234] = -1;
        byArray[235] = -1;
        byArray[240] = 17;
        byArray[246] = 26;
        byArray[248] = 10;
        byArray[252] = 116;
        byArray[253] = 105;
        byArray[254] = 109;
        byArray[255] = 101;
        byArray[256] = 115;
        byArray[257] = 116;
        byArray[258] = 97;
        byArray[259] = 109;
        byArray[260] = 112;
        byArray[264] = -1;
        byArray[265] = -1;
        byArray[268] = 17;
        byArray[274] = 26;
        byArray[276] = 9;
        byArray[280] = 112;
        byArray[281] = 105;
        byArray[282] = 110;
        byArray[283] = 103;
        byArray[284] = 67;
        byArray[285] = 111;
        byArray[286] = 114;
        byArray[287] = 101;
        byArray[290] = -1;
        byArray[291] = -1;
        byArray[296] = 7;
        byArray[302] = 22;
        byArray[304] = 5;
        byArray[308] = 112;
        byArray[309] = 105;
        byArray[310] = 110;
        byArray[311] = 103;
        byArray[314] = -1;
        byArray[315] = -1;
        byArray[320] = 7;
        byArray[326] = 26;
        byArray[328] = 10;
        byArray[332] = 103;
        byArray[333] = 114;
        byArray[334] = 111;
        byArray[335] = 117;
        byArray[336] = 112;
        byArray[337] = 84;
        byArray[338] = 121;
        byArray[339] = 112;
        byArray[340] = 101;
        byArray[344] = -1;
        byArray[345] = -1;
        byArray[348] = 2;
        byArray[354] = 26;
        byArray[356] = 8;
        byArray[360] = 103;
        byArray[361] = 114;
        byArray[362] = 111;
        byArray[363] = 117;
        byArray[364] = 112;
        byArray[365] = 73;
        byArray[366] = 100;
        byArray[370] = -1;
        byArray[371] = -1;
        byArray[376] = 2;
        byte[] tc_data = byArray;
        if (b != null) {
            b.put(tc_data, 0, tc_data.length);
        }
        return tc_data.length;
    }

    public int get_typecode_enc() {
        return 1;
    }

    public int get_encoding() {
        return 0;
    }

    public int get_decoding() {
        return 0;
    }

    public boolean has_key() {
        return true;
    }

    public PingTopic alloc() {
        return new PingTopic();
    }

    public void clear(PingTopic instance) {
        instance.clear();
    }

    public void destroy(PingTopic instance) {
    }

    public void copy(PingTopic to, PingTopic from) {
        to.copy(from);
    }

    public boolean get_field(String fieldname, CoreDX_FieldDef fdef) {
        return false;
    }
}

