/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.topics.coredx;

import com.toc.coredx.DDS.CoreDX_FieldDef;
import com.toc.coredx.DDS.DataReader;
import com.toc.coredx.DDS.DataWriter;
import com.toc.coredx.DDS.DomainParticipant;
import com.toc.coredx.DDS.Publisher;
import com.toc.coredx.DDS.ReturnCode_t;
import com.toc.coredx.DDS.SWIGTYPE_p__DataReader;
import com.toc.coredx.DDS.SWIGTYPE_p__DataWriter;
import com.toc.coredx.DDS.Subscriber;
import com.toc.coredx.DDS.Topic;
import com.toc.coredx.DDS.TopicDescription;
import com.toc.coredx.DDS.TypeSupport;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import lac.cnet.sddl.topics.coredx.PrivateMessageTopic;
import lac.cnet.sddl.topics.coredx.PrivateMessageTopicDataReader;
import lac.cnet.sddl.topics.coredx.PrivateMessageTopicDataWriter;

public final class PrivateMessageTopicTypeSupport
implements TypeSupport {
    private long cTypeSupport = 0L;

    @Override
    public ReturnCode_t register_type(DomainParticipant dp, String type_name) {
        if (dp.check_version("3", "6", "8") != 0) {
            System.out.println("WARNING: PrivateMessageTopic TypeSupport version does not match CoreDX Library version.");
            System.out.println("This may cause software instability or crashes.");
        }
        return dp.register_type(this, type_name);
    }

    @Override
    public String get_type_name() {
        return "PrivateMessageTopic";
    }

    @Override
    public long getCTypeSupport() {
        return this.cTypeSupport;
    }

    public PrivateMessageTopicTypeSupport() {
        PrivateMessageTopic tmp = new PrivateMessageTopic();
        this.cTypeSupport = DomainParticipant.createTypeSupport(this, this.getClass().getName(), tmp.getClass().getName());
    }

    @Override
    public DataReader create_datareader(Subscriber sub, TopicDescription td, SWIGTYPE_p__DataReader jni_dr) {
        return new PrivateMessageTopicDataReader(sub, td, jni_dr);
    }

    @Override
    public DataWriter create_datawriter(Publisher pub, Topic topic, SWIGTYPE_p__DataWriter jni_dw) {
        return new PrivateMessageTopicDataWriter(pub, topic, jni_dw);
    }

    public int marshall(ByteBuffer out_stream, PrivateMessageTopic src) {
        int size = 0;
        if (out_stream == null) {
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            size = size + 3 & 0xFFFFFFFC;
            size += 4;
            size = size + 3 & 0xFFFFFFFC;
            size += 4;
            size = size + 3 & 0xFFFFFFFC;
            size += 4;
            if (src.message != null) {
                int i7 = 0;
                while (i7 < src.message.length) {
                    ++size;
                    ++i7;
                }
            }
            size += 4;
        } else {
            int offset = 0;
            out_stream.clear();
            out_stream.order(ByteOrder.LITTLE_ENDIAN);
            out_stream.put((byte)0);
            out_stream.put((byte)1);
            out_stream.put((byte)0);
            out_stream.put((byte)0);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.leastSignificantBitsVehicleId);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.mostSignificantBitsVehicleId);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.leastSignificantBitsGatewayId);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.mostSignificantBitsGatewayId);
            while ((offset & 3) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 4;
            out_stream.putInt(src.groupId);
            while ((offset & 3) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 4;
            out_stream.putInt(src.groupType);
            while ((offset & 3) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 4;
            out_stream.putInt(src.message.length);
            int i7 = 0;
            while (i7 < src.message.length) {
                ++offset;
                out_stream.put(src.message[i7]);
                ++i7;
            }
            size = out_stream.position();
        }
        return size;
    }

    public int marshall_fixed_size() {
        return 0;
    }

    public int marshall_key(ByteBuffer out_stream, PrivateMessageTopic src) {
        int size = 0;
        if (out_stream == null) {
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            size += 4;
        } else {
            int offset = 0;
            out_stream.clear();
            out_stream.order(ByteOrder.LITTLE_ENDIAN);
            out_stream.put((byte)0);
            out_stream.put((byte)1);
            out_stream.put((byte)0);
            out_stream.put((byte)0);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.leastSignificantBitsVehicleId);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.mostSignificantBitsVehicleId);
            size = out_stream.position();
        }
        return size;
    }

    public int marshall_key_hash(ByteBuffer out_stream, PrivateMessageTopic src) {
        int size = 0;
        if (out_stream == null) {
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
            size = size + 7 & 0xFFFFFFF8;
            size += 8;
        } else {
            int offset = 0;
            out_stream.clear();
            out_stream.order(ByteOrder.BIG_ENDIAN);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.leastSignificantBitsVehicleId);
            while ((offset & 7) != 0) {
                ++offset;
                out_stream.put((byte)0);
            }
            offset += 8;
            out_stream.putLong(src.mostSignificantBitsVehicleId);
            size = out_stream.position();
        }
        return size;
    }

    public boolean key_must_hash() {
        return false;
    }

    public int unmarshall(PrivateMessageTopic t, ByteBuffer data, int s) {
        int offset = 0;
        data.get();
        byte encoding = data.get();
        data.getShort();
        if ((encoding & 1) == 0) {
            data.order(ByteOrder.BIG_ENDIAN);
        } else {
            data.order(ByteOrder.LITTLE_ENDIAN);
        }
        if ((encoding & 0xFE) == 0) {
            while ((offset & 7) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 8;
            t.leastSignificantBitsVehicleId = data.getLong();
            while ((offset & 7) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 8;
            t.mostSignificantBitsVehicleId = data.getLong();
            while ((offset & 7) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 8;
            t.leastSignificantBitsGatewayId = data.getLong();
            while ((offset & 7) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 8;
            t.mostSignificantBitsGatewayId = data.getLong();
            while ((offset & 3) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 4;
            t.groupId = data.getInt();
            while ((offset & 3) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 4;
            t.groupType = data.getInt();
            while ((offset & 3) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 4;
            int slen7 = data.getInt();
            t.message = new byte[slen7];
            int i7 = 0;
            while (i7 < t.message.length) {
                ++offset;
                t.message[i7] = data.get();
                ++i7;
            }
        }
        return 1;
    }

    public int unmarshall_key(PrivateMessageTopic t, ByteBuffer data, int s) {
        int offset = 0;
        data.get();
        byte encoding = data.get();
        data.getShort();
        if ((encoding & 1) == 0) {
            data.order(ByteOrder.BIG_ENDIAN);
        } else {
            data.order(ByteOrder.LITTLE_ENDIAN);
        }
        if ((encoding & 0xFE) == 0) {
            while ((offset & 7) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 8;
            t.leastSignificantBitsVehicleId = data.getLong();
            while ((offset & 7) != 0) {
                ++offset;
                data.position(data.position() + 1);
            }
            offset += 8;
            t.mostSignificantBitsVehicleId = data.getLong();
        }
        return 1;
    }

    public int unmarshall_key_hash(PrivateMessageTopic t, ByteBuffer data, int s) {
        int offset = 0;
        data.order(ByteOrder.BIG_ENDIAN);
        while ((offset & 7) != 0) {
            ++offset;
            data.position(data.position() + 1);
        }
        offset += 8;
        t.leastSignificantBitsVehicleId = data.getLong();
        while ((offset & 7) != 0) {
            ++offset;
            data.position(data.position() + 1);
        }
        offset += 8;
        t.mostSignificantBitsVehicleId = data.getLong();
        return 0;
    }

    public int gen_typecode(ByteBuffer b) {
        byte[] byArray = new byte[326];
        byArray[0] = 10;
        byArray[4] = 64;
        byArray[5] = 1;
        byArray[8] = 20;
        byArray[12] = 80;
        byArray[13] = 114;
        byArray[14] = 105;
        byArray[15] = 118;
        byArray[16] = 97;
        byArray[17] = 116;
        byArray[18] = 101;
        byArray[19] = 77;
        byArray[20] = 101;
        byArray[21] = 115;
        byArray[22] = 115;
        byArray[23] = 97;
        byArray[24] = 103;
        byArray[25] = 101;
        byArray[26] = 84;
        byArray[27] = 111;
        byArray[28] = 112;
        byArray[29] = 105;
        byArray[30] = 99;
        byArray[32] = 7;
        byArray[36] = 48;
        byArray[40] = 30;
        byArray[44] = 108;
        byArray[45] = 101;
        byArray[46] = 97;
        byArray[47] = 115;
        byArray[48] = 116;
        byArray[49] = 83;
        byArray[50] = 105;
        byArray[51] = 103;
        byArray[52] = 110;
        byArray[53] = 105;
        byArray[54] = 102;
        byArray[55] = 105;
        byArray[56] = 99;
        byArray[57] = 97;
        byArray[58] = 110;
        byArray[59] = 116;
        byArray[60] = 66;
        byArray[61] = 105;
        byArray[62] = 116;
        byArray[63] = 115;
        byArray[64] = 86;
        byArray[65] = 101;
        byArray[66] = 104;
        byArray[67] = 105;
        byArray[68] = 99;
        byArray[69] = 108;
        byArray[70] = 101;
        byArray[71] = 73;
        byArray[72] = 100;
        byArray[76] = -1;
        byArray[77] = -1;
        byArray[78] = 1;
        byArray[80] = 17;
        byArray[86] = 46;
        byArray[88] = 29;
        byArray[92] = 109;
        byArray[93] = 111;
        byArray[94] = 115;
        byArray[95] = 116;
        byArray[96] = 83;
        byArray[97] = 105;
        byArray[98] = 103;
        byArray[99] = 110;
        byArray[100] = 105;
        byArray[101] = 102;
        byArray[102] = 105;
        byArray[103] = 99;
        byArray[104] = 97;
        byArray[105] = 110;
        byArray[106] = 116;
        byArray[107] = 66;
        byArray[108] = 105;
        byArray[109] = 116;
        byArray[110] = 115;
        byArray[111] = 86;
        byArray[112] = 101;
        byArray[113] = 104;
        byArray[114] = 105;
        byArray[115] = 99;
        byArray[116] = 108;
        byArray[117] = 101;
        byArray[118] = 73;
        byArray[119] = 100;
        byArray[122] = -1;
        byArray[123] = -1;
        byArray[124] = 1;
        byArray[128] = 17;
        byArray[134] = 46;
        byArray[136] = 30;
        byArray[140] = 108;
        byArray[141] = 101;
        byArray[142] = 97;
        byArray[143] = 115;
        byArray[144] = 116;
        byArray[145] = 83;
        byArray[146] = 105;
        byArray[147] = 103;
        byArray[148] = 110;
        byArray[149] = 105;
        byArray[150] = 102;
        byArray[151] = 105;
        byArray[152] = 99;
        byArray[153] = 97;
        byArray[154] = 110;
        byArray[155] = 116;
        byArray[156] = 66;
        byArray[157] = 105;
        byArray[158] = 116;
        byArray[159] = 115;
        byArray[160] = 71;
        byArray[161] = 97;
        byArray[162] = 116;
        byArray[163] = 101;
        byArray[164] = 119;
        byArray[165] = 97;
        byArray[166] = 121;
        byArray[167] = 73;
        byArray[168] = 100;
        byArray[172] = -1;
        byArray[173] = -1;
        byArray[176] = 17;
        byArray[182] = 46;
        byArray[184] = 29;
        byArray[188] = 109;
        byArray[189] = 111;
        byArray[190] = 115;
        byArray[191] = 116;
        byArray[192] = 83;
        byArray[193] = 105;
        byArray[194] = 103;
        byArray[195] = 110;
        byArray[196] = 105;
        byArray[197] = 102;
        byArray[198] = 105;
        byArray[199] = 99;
        byArray[200] = 97;
        byArray[201] = 110;
        byArray[202] = 116;
        byArray[203] = 66;
        byArray[204] = 105;
        byArray[205] = 116;
        byArray[206] = 115;
        byArray[207] = 71;
        byArray[208] = 97;
        byArray[209] = 116;
        byArray[210] = 101;
        byArray[211] = 119;
        byArray[212] = 97;
        byArray[213] = 121;
        byArray[214] = 73;
        byArray[215] = 100;
        byArray[218] = -1;
        byArray[219] = -1;
        byArray[224] = 17;
        byArray[230] = 26;
        byArray[232] = 8;
        byArray[236] = 103;
        byArray[237] = 114;
        byArray[238] = 111;
        byArray[239] = 117;
        byArray[240] = 112;
        byArray[241] = 73;
        byArray[242] = 100;
        byArray[246] = -1;
        byArray[247] = -1;
        byArray[252] = 2;
        byArray[258] = 26;
        byArray[260] = 10;
        byArray[264] = 103;
        byArray[265] = 114;
        byArray[266] = 111;
        byArray[267] = 117;
        byArray[268] = 112;
        byArray[269] = 84;
        byArray[270] = 121;
        byArray[271] = 112;
        byArray[272] = 101;
        byArray[276] = -1;
        byArray[277] = -1;
        byArray[280] = 2;
        byArray[286] = 38;
        byArray[288] = 8;
        byArray[292] = 109;
        byArray[293] = 101;
        byArray[294] = 115;
        byArray[295] = 115;
        byArray[296] = 97;
        byArray[297] = 103;
        byArray[298] = 101;
        byArray[302] = -1;
        byArray[303] = -1;
        byArray[308] = 14;
        byArray[312] = 12;
        byArray[316] = -1;
        byArray[317] = -1;
        byArray[318] = -1;
        byArray[319] = -1;
        byArray[320] = 9;
        byte[] tc_data = byArray;
        if (b != null) {
            b.put(tc_data, 0, tc_data.length);
        }
        return tc_data.length;
    }

    public int get_typecode_enc() {
        return 1;
    }

    public int get_encoding() {
        return 0;
    }

    public int get_decoding() {
        return 0;
    }

    public boolean has_key() {
        return true;
    }

    public PrivateMessageTopic alloc() {
        return new PrivateMessageTopic();
    }

    public void clear(PrivateMessageTopic instance) {
        instance.clear();
    }

    public void destroy(PrivateMessageTopic instance) {
    }

    public void copy(PrivateMessageTopic to, PrivateMessageTopic from) {
        to.copy(from);
    }

    public boolean get_field(String fieldname, CoreDX_FieldDef fdef) {
        return false;
    }
}

