/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.udi.core;

import com.toc.coredx.DDS.Topic;
import com.toc.coredx.DDS.TopicDescription;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.List;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.udi.core.OpenSpliceLayer;
import lac.cnet.sddl.udi.core.SddlLayer;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import lac.cnet.sddl.udi.core.listener.UDIDataReaderListener;
import lac.cnet.sddl.udi.core.qos.DataReaderQos;
import lac.cnet.sddl.udi.core.qos.DataWriterQos;
import lac.cnet.sddl.udi.core.qos.QosProfile;
import lac.cnet.sddl.udi.coredx.CoreDXAbstractionComponent;
import lac.cnet.sddl.udi.coredx.listener.CoreDXDataReaderListener;

public class CoreDXLayer
implements SddlLayer {
    private final CoreDXAbstractionComponent coreDXInstance = new CoreDXAbstractionComponent();

    @Override
    public boolean createParticipant(long domainID) {
        return this.coreDXInstance.createParticipant(domainID) != null;
    }

    @Override
    public boolean createParticipant(String domainID) {
        return this.coreDXInstance.createParticipant(domainID) != null;
    }

    @Override
    public boolean createParticipant(long domainID, String license) {
        return this.coreDXInstance.createParticipant(domainID, null, license) != null;
    }

    @Override
    public boolean createParticipant(String domainID, String license) {
        return this.coreDXInstance.createParticipant(domainID, null, license) != null;
    }

    @Override
    public void createSubscriber() {
        this.coreDXInstance.createSubscriber(null, null);
    }

    @Override
    public void createPublisher() {
        this.coreDXInstance.createPublisher(null, null);
    }

    @Override
    public Object createTopic(String typeName, String topicName) {
        return this.coreDXInstance.createTopic(typeName, topicName);
    }

    @Override
    public Object createTopic(Class<? extends ApplicationObject> applicationObjectClass, String topicName) {
        Constructor<? extends ApplicationObject> constructor = null;
        ApplicationObject applicationObject = null;
        try {
            constructor = applicationObjectClass.getConstructor(new Class[0]);
            applicationObject = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.createTopic(applicationObject.getTopicTypeName(UniversalDDSLayerFactory.SupportedDDSVendors.CoreDX), topicName);
    }

    @Override
    public Object createContentFilteredTopic(String topicName, Object topic, String logicExpression, List<String> parameters) {
        if (topic instanceof Topic) {
            return this.coreDXInstance.createContentFilteredTopic(topicName, (Topic)topic, logicExpression, parameters);
        }
        return null;
    }

    @Override
    public boolean createDataReader(Object topicDescription, UDIDataReaderListener<Object> applicationDataReaderListener) {
        return this.createDataReader(topicDescription, new DataReaderQos(), applicationDataReaderListener);
    }

    @Override
    public boolean createDataReader(Object topicDescription, DataReaderQos dataReaderQoS, UDIDataReaderListener<Object> applicationDataReaderListener) {
        if (topicDescription instanceof TopicDescription) {
            CoreDXDataReaderListener<Object> listener = new CoreDXDataReaderListener<Object>(applicationDataReaderListener);
            this.coreDXInstance.createDataReader((TopicDescription)topicDescription, this.getDataReaderQoS(dataReaderQoS), listener);
            return true;
        }
        return false;
    }

    @Override
    public boolean createDataReader(UDIDataReaderListener<ApplicationObject> applicationDataReaderListener, Object topicDescription) {
        return this.createDataReader(applicationDataReaderListener, topicDescription, new DataReaderQos());
    }

    @Override
    public boolean createDataReader(UDIDataReaderListener<ApplicationObject> applicationDataReaderListener, Object topicDescription, DataReaderQos dataReaderQoS) {
        if (topicDescription instanceof TopicDescription) {
            CoreDXDataReaderListener<ApplicationObject> listener = new CoreDXDataReaderListener<ApplicationObject>(applicationDataReaderListener, true);
            this.coreDXInstance.createDataReader((TopicDescription)topicDescription, this.getDataReaderQoS(dataReaderQoS), listener);
            return true;
        }
        return false;
    }

    @Override
    public boolean createDataWriter(Object topic) {
        return this.createDataWriter(topic, new DataWriterQos());
    }

    @Override
    public boolean createDataWriter(Object topic, DataWriterQos dataWriterQoS) {
        if (topic instanceof Topic) {
            this.coreDXInstance.createDataWriter((Topic)topic, this.getDataWriterQoS(dataWriterQoS), null);
            return true;
        }
        return false;
    }

    @Override
    public boolean writeTopic(String topicName, Object topic) {
        return this.coreDXInstance.writeTopic(topicName, topic);
    }

    @Override
    public boolean writeTopic(String topicName, ApplicationObject applicationObject) {
        return this.coreDXInstance.writeTopic(topicName, applicationObject.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.CoreDX));
    }

    @Override
    public boolean deleteParticipant() {
        return this.coreDXInstance.deleteParticipant();
    }

    @Override
    public boolean deletePublisher() {
        return this.coreDXInstance.deletePublisher();
    }

    @Override
    public boolean deleteSubscriber() {
        return this.coreDXInstance.deleteSubscriber();
    }

    @Override
    public boolean deleteTopic(Object topic) {
        if (topic instanceof Topic) {
            return this.coreDXInstance.deleteTopic((Topic)topic);
        }
        return false;
    }

    @Override
    public boolean close() {
        return this.close();
    }

    @Override
    public String getBooleanRepresentation(boolean value) {
        if (value) {
            return "1";
        }
        return "0";
    }

    protected com.toc.coredx.DDS.DataReaderQos getDataReaderQoS(DataReaderQos dataReaderQos) {
        com.toc.coredx.DDS.DataReaderQos ddsQos = this.coreDXInstance.getDefaultDataReaderQoS();
        if (dataReaderQos != null) {
            dataReaderQos.fillEntityQos(ddsQos);
        }
        return ddsQos;
    }

    public com.toc.coredx.DDS.DataWriterQos getDataWriterQoS(DataWriterQos dataWriterQos) {
        com.toc.coredx.DDS.DataWriterQos ddsQos = this.coreDXInstance.getDefaultDataWriterQoS();
        if (dataWriterQos != null) {
            dataWriterQos.fillEntityQos(ddsQos);
        }
        return ddsQos;
    }

    @Override
    public boolean createDataReader(Object topicDescription, String dataReaderQoSFileName, UDIDataReaderListener<Object> applicationDataReaderListener) throws IOException {
        DataReaderQos dataReaderQos = OpenSpliceLayer.readDataReaderQosFromJsonFile(dataReaderQoSFileName);
        return this.createDataReader(topicDescription, dataReaderQos, applicationDataReaderListener);
    }

    @Override
    public boolean createDataWriter(Object topic, String dataWriterQoSFileName) throws IOException {
        DataWriterQos dataWriterQos = OpenSpliceLayer.readDataWriterQosFromJsonFile(dataWriterQoSFileName);
        return this.createDataWriter(topic, dataWriterQos);
    }

    @Override
    public boolean createDataReader(UDIDataReaderListener<ApplicationObject> applicationDataReaderListener, Object topicDescription, String dataReaderQoSFileName) throws IOException {
        DataReaderQos dataReaderQos = OpenSpliceLayer.readDataReaderQosFromJsonFile(dataReaderQoSFileName);
        return this.createDataReader(applicationDataReaderListener, topicDescription, dataReaderQos);
    }

    @Override
    public boolean writeQosProfileToJsonFile(QosProfile entityQos, String fileName) throws IOException {
        return OpenSpliceLayer.writeToJsonFile(entityQos, fileName);
    }
}

