/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.udi.core;

import DDS.Topic;
import DDS.TopicDescription;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.List;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.udi.core.SddlLayer;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import lac.cnet.sddl.udi.core.listener.UDIDataReaderListener;
import lac.cnet.sddl.udi.core.qos.DataReaderQos;
import lac.cnet.sddl.udi.core.qos.DataWriterQos;
import lac.cnet.sddl.udi.core.qos.QosProfile;
import lac.cnet.sddl.udi.opensplice.OpenSpliceAbstractionComponent;
import lac.cnet.sddl.udi.opensplice.listener.OpenSpliceDataReaderListener;

public class OpenSpliceLayer
implements SddlLayer {
    private final OpenSpliceAbstractionComponent openSpliceInstance = new OpenSpliceAbstractionComponent();

    @Override
    public boolean createParticipant(long domainID) {
        return this.openSpliceInstance.createParticipant(domainID) != null;
    }

    @Override
    public boolean createParticipant(String domainID) {
        return this.openSpliceInstance.createParticipant(domainID) != null;
    }

    @Override
    public boolean createParticipant(long domainID, String license) {
        return this.openSpliceInstance.createParticipant(domainID, null, license) != null;
    }

    @Override
    public boolean createParticipant(String domainID, String license) {
        return this.openSpliceInstance.createParticipant(domainID, null, license) != null;
    }

    @Override
    public void createSubscriber() {
        this.openSpliceInstance.createSubscriber(null, null);
    }

    @Override
    public void createPublisher() {
        this.openSpliceInstance.createPublisher(null, null);
    }

    @Override
    public Object createTopic(String typeName, String topicName) {
        return this.openSpliceInstance.createTopic(typeName, topicName);
    }

    @Override
    public Object createTopic(Class<? extends ApplicationObject> applicationObjectClass, String topicName) {
        Constructor<? extends ApplicationObject> constructor = null;
        ApplicationObject applicationObject = null;
        try {
            constructor = applicationObjectClass.getConstructor(new Class[0]);
            applicationObject = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.createTopic(applicationObject.getTopicTypeName(UniversalDDSLayerFactory.SupportedDDSVendors.OpenSplice), topicName);
    }

    @Override
    public Object createContentFilteredTopic(String topicName, Object topic, String logicExpression, List<String> parameters) {
        if (topic instanceof Topic) {
            return this.openSpliceInstance.createContentFilteredTopic(topicName, (Topic)topic, logicExpression, parameters);
        }
        return null;
    }

    @Override
    public boolean createDataReader(Object topicDescription, UDIDataReaderListener<Object> applicationDataReaderListener) {
        return this.createDataReader(topicDescription, new DataReaderQos(), applicationDataReaderListener);
    }

    @Override
    public boolean createDataReader(Object topicDescription, DataReaderQos dataReaderQoS, UDIDataReaderListener<Object> applicationDataReaderListener) {
        if (topicDescription instanceof TopicDescription) {
            OpenSpliceDataReaderListener<Object> listener = new OpenSpliceDataReaderListener<Object>(applicationDataReaderListener);
            this.openSpliceInstance.createDataReader((TopicDescription)topicDescription, this.getDataReaderQoS(dataReaderQoS), listener);
            return true;
        }
        return false;
    }

    @Override
    public boolean createDataReader(UDIDataReaderListener<ApplicationObject> applicationDataReaderListener, Object topicDescription) {
        return this.createDataReader(applicationDataReaderListener, topicDescription, new DataReaderQos());
    }

    @Override
    public boolean createDataReader(UDIDataReaderListener<ApplicationObject> applicationDataReaderListener, Object topicDescription, DataReaderQos dataReaderQoS) {
        if (topicDescription instanceof TopicDescription) {
            OpenSpliceDataReaderListener<ApplicationObject> listener = new OpenSpliceDataReaderListener<ApplicationObject>(applicationDataReaderListener, true);
            this.openSpliceInstance.createDataReader((TopicDescription)topicDescription, this.getDataReaderQoS(dataReaderQoS), listener);
            return true;
        }
        return false;
    }

    @Override
    public boolean createDataWriter(Object topic) {
        return this.createDataWriter(topic, new DataWriterQos());
    }

    @Override
    public boolean createDataWriter(Object topic, DataWriterQos dataWriterQoS) {
        if (topic instanceof Topic) {
            this.openSpliceInstance.createDataWriter((Topic)topic, this.getDataWriterQoS(dataWriterQoS), null);
            return true;
        }
        return false;
    }

    @Override
    public boolean writeTopic(String topicName, Object topic) {
        return this.openSpliceInstance.writeTopic(topicName, topic);
    }

    @Override
    public boolean writeTopic(String topicName, ApplicationObject applicationObject) {
        return this.openSpliceInstance.writeTopic(topicName, applicationObject.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.OpenSplice));
    }

    @Override
    public boolean deleteParticipant() {
        return this.openSpliceInstance.deleteParticipant();
    }

    @Override
    public boolean deletePublisher() {
        return this.openSpliceInstance.deletePublisher();
    }

    @Override
    public boolean deleteSubscriber() {
        return this.openSpliceInstance.deleteSubscriber();
    }

    @Override
    public boolean deleteTopic(Object topic) {
        if (topic instanceof Topic) {
            return this.openSpliceInstance.deleteTopic((Topic)topic);
        }
        return false;
    }

    @Override
    public boolean close() {
        return this.close();
    }

    @Override
    public String getBooleanRepresentation(boolean value) {
        if (value) {
            return "'true'";
        }
        return "'false'";
    }

    protected DDS.DataReaderQos getDataReaderQoS(DataReaderQos dataReaderQos) {
        DDS.DataReaderQos ddsQos = this.openSpliceInstance.getDefaultDataReaderQoS();
        if (dataReaderQos != null) {
            dataReaderQos.fillEntityQos(ddsQos);
        }
        return ddsQos;
    }

    protected DDS.DataWriterQos getDataWriterQoS(DataWriterQos dataWriterQos) {
        DDS.DataWriterQos ddsQos = this.openSpliceInstance.getDefaultDataWriterQoS();
        if (dataWriterQos != null) {
            dataWriterQos.fillEntityQos(ddsQos);
        }
        return ddsQos;
    }

    @Override
    public boolean createDataReader(Object topicDescription, String dataReaderQoSFileName, UDIDataReaderListener<Object> applicationDataReaderListener) throws IOException {
        DataReaderQos dataReaderQos = OpenSpliceLayer.readDataReaderQosFromJsonFile(dataReaderQoSFileName);
        return this.createDataReader(topicDescription, dataReaderQos, applicationDataReaderListener);
    }

    @Override
    public boolean createDataWriter(Object topic, String dataWriterQoSFileName) throws IOException {
        DataWriterQos dataWriterQos = OpenSpliceLayer.readDataWriterQosFromJsonFile(dataWriterQoSFileName);
        return this.createDataWriter(topic, dataWriterQos);
    }

    @Override
    public boolean createDataReader(UDIDataReaderListener<ApplicationObject> applicationDataReaderListener, Object topicDescription, String dataReaderQoSFileName) throws IOException {
        DataReaderQos dataReaderQos = OpenSpliceLayer.readDataReaderQosFromJsonFile(dataReaderQoSFileName);
        return this.createDataReader(applicationDataReaderListener, topicDescription, dataReaderQos);
    }

    public static DataReaderQos readDataReaderQosFromJsonFile(String dataReaderQoSFileName) throws IOException {
        return OpenSpliceLayer.readFromJsonFile((String)dataReaderQoSFileName).dataReaderQos;
    }

    public static DataWriterQos readDataWriterQosFromJsonFile(String dataWriterQoSFileName) throws IOException {
        return OpenSpliceLayer.readFromJsonFile((String)dataWriterQoSFileName).dataWriterQos;
    }

    public static QosProfile readQosProfileFromJsonFile(String dataWriterQoSFileName) throws IOException {
        return OpenSpliceLayer.readFromJsonFile(dataWriterQoSFileName);
    }

    private static QosProfile readFromJsonFile(String qoSFileName) throws IOException {
        Gson gson = new Gson();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(qoSFileName));
        QosProfile qos = gson.fromJson((Reader)bufferedReader, QosProfile.class);
        bufferedReader.close();
        return qos;
    }

    @Override
    public boolean writeQosProfileToJsonFile(QosProfile qosProfile, String fileName) throws IOException {
        return OpenSpliceLayer.writeToJsonFile(qosProfile, fileName);
    }

    public static boolean writeToJsonFile(Object entityQos, String fileName) throws IOException {
        Gson gson = new Gson();
        String json = gson.toJson(entityQos);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(fileName));
        bufferedWriter.write(json);
        bufferedWriter.close();
        return true;
    }
}

