/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.udi.core;

import com.rti.dds.topic.Topic;
import com.rti.dds.topic.TopicDescription;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.List;
import lac.cnet.sddl.objects.ApplicationObject;
import lac.cnet.sddl.udi.core.OpenSpliceLayer;
import lac.cnet.sddl.udi.core.SddlLayer;
import lac.cnet.sddl.udi.core.UniversalDDSLayerFactory;
import lac.cnet.sddl.udi.core.listener.UDIDataReaderListener;
import lac.cnet.sddl.udi.core.qos.DataReaderQos;
import lac.cnet.sddl.udi.core.qos.DataWriterQos;
import lac.cnet.sddl.udi.core.qos.QosProfile;
import lac.cnet.sddl.udi.rti.RTIAbstractionComponent;
import lac.cnet.sddl.udi.rti.listener.RTIDataReaderListener;

public class RTILayer
implements SddlLayer {
    private final RTIAbstractionComponent rtiInstance = new RTIAbstractionComponent();

    @Override
    public boolean createParticipant(long domainID) {
        return this.rtiInstance.createParticipant(domainID) != null;
    }

    @Override
    public boolean createParticipant(String domainID) {
        return this.rtiInstance.createParticipant(domainID) != null;
    }

    @Override
    public boolean createParticipant(long domainID, String license) {
        return this.rtiInstance.createParticipant(domainID, null, license) != null;
    }

    @Override
    public boolean createParticipant(String domainID, String license) {
        return this.rtiInstance.createParticipant(domainID, null, license) != null;
    }

    @Override
    public void createSubscriber() {
        this.rtiInstance.createSubscriber(null, null);
    }

    @Override
    public void createPublisher() {
        this.rtiInstance.createPublisher(null, null);
    }

    @Override
    public Object createTopic(String typeName, String topicName) {
        return this.rtiInstance.createTopic(typeName, topicName);
    }

    @Override
    public Object createTopic(Class<? extends ApplicationObject> applicationObjectClass, String topicName) {
        Constructor<? extends ApplicationObject> constructor = null;
        ApplicationObject applicationObject = null;
        try {
            constructor = applicationObjectClass.getConstructor(new Class[0]);
            applicationObject = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.createTopic(applicationObject.getTopicTypeName(UniversalDDSLayerFactory.SupportedDDSVendors.RTI), topicName);
    }

    @Override
    public Object createContentFilteredTopic(String topicName, Object topic, String logicExpression, List<String> parameters) {
        if (topic instanceof Topic) {
            return this.rtiInstance.createContentFilteredTopic(topicName, (Topic)topic, logicExpression, parameters);
        }
        return null;
    }

    @Override
    public boolean createDataReader(Object topicDescription, UDIDataReaderListener<Object> applicationDataReaderListener) {
        return this.createDataReader(topicDescription, new DataReaderQos(), applicationDataReaderListener);
    }

    @Override
    public boolean createDataReader(Object topicDescription, DataReaderQos dataReaderQoS, UDIDataReaderListener<Object> applicationDataReaderListener) {
        if (topicDescription instanceof TopicDescription) {
            RTIDataReaderListener<Object> listener = new RTIDataReaderListener<Object>(applicationDataReaderListener);
            this.rtiInstance.createDataReader((TopicDescription)topicDescription, this.getDataReaderQoS(dataReaderQoS), listener);
            return true;
        }
        return false;
    }

    @Override
    public boolean createDataReader(UDIDataReaderListener<ApplicationObject> applicationDataReaderListener, Object topicDescription) {
        return this.createDataReader(applicationDataReaderListener, topicDescription, new DataReaderQos());
    }

    @Override
    public boolean createDataReader(UDIDataReaderListener<ApplicationObject> applicationDataReaderListener, Object topicDescription, DataReaderQos dataReaderQoS) {
        if (topicDescription instanceof TopicDescription) {
            RTIDataReaderListener<ApplicationObject> listener = new RTIDataReaderListener<ApplicationObject>(applicationDataReaderListener, true);
            this.rtiInstance.createDataReader((TopicDescription)topicDescription, this.getDataReaderQoS(dataReaderQoS), listener);
            return true;
        }
        return false;
    }

    @Override
    public boolean createDataWriter(Object topic) {
        return this.createDataWriter(topic, new DataWriterQos());
    }

    @Override
    public boolean createDataWriter(Object topic, DataWriterQos dataWriterQoS) {
        if (topic instanceof Topic) {
            this.rtiInstance.createDataWriter((Topic)topic, this.getDataWriterQoS(dataWriterQoS), null);
            return true;
        }
        return false;
    }

    @Override
    public boolean writeTopic(String topicName, Object topic) {
        return this.rtiInstance.writeTopic(topicName, topic);
    }

    @Override
    public boolean writeTopic(String topicName, ApplicationObject applicationObject) {
        return this.rtiInstance.writeTopic(topicName, applicationObject.getSpecificDdsTopic(UniversalDDSLayerFactory.SupportedDDSVendors.RTI));
    }

    @Override
    public boolean deleteParticipant() {
        return this.rtiInstance.deleteParticipant();
    }

    @Override
    public boolean deletePublisher() {
        return this.rtiInstance.deletePublisher();
    }

    @Override
    public boolean deleteSubscriber() {
        return this.rtiInstance.deleteSubscriber();
    }

    @Override
    public boolean deleteTopic(Object topic) {
        if (topic instanceof Topic) {
            return this.rtiInstance.deleteTopic((Topic)topic);
        }
        return false;
    }

    @Override
    public boolean close() {
        return this.close();
    }

    @Override
    public String getBooleanRepresentation(boolean value) {
        if (value) {
            return "true";
        }
        return "false";
    }

    protected com.rti.dds.subscription.DataReaderQos getDataReaderQoS(DataReaderQos dataReaderQos) {
        com.rti.dds.subscription.DataReaderQos ddsQos = this.rtiInstance.getDefaultDataReaderQoS();
        if (dataReaderQos != null) {
            dataReaderQos.fillEntityQos(ddsQos);
        }
        return ddsQos;
    }

    protected com.rti.dds.publication.DataWriterQos getDataWriterQoS(DataWriterQos dataWriterQos) {
        com.rti.dds.publication.DataWriterQos ddsQos = this.rtiInstance.getDefaultDataWriterQoS();
        if (dataWriterQos != null) {
            dataWriterQos.fillEntityQos(ddsQos);
        }
        return ddsQos;
    }

    @Override
    public boolean createDataReader(Object topicDescription, String dataReaderQoSFileName, UDIDataReaderListener<Object> applicationDataReaderListener) throws IOException {
        DataReaderQos dataReaderQos = OpenSpliceLayer.readDataReaderQosFromJsonFile(dataReaderQoSFileName);
        return this.createDataReader(topicDescription, dataReaderQos, applicationDataReaderListener);
    }

    @Override
    public boolean createDataWriter(Object topic, String dataWriterQoSFileName) throws IOException {
        DataWriterQos dataWriterQos = OpenSpliceLayer.readDataWriterQosFromJsonFile(dataWriterQoSFileName);
        return this.createDataWriter(topic, dataWriterQos);
    }

    @Override
    public boolean createDataReader(UDIDataReaderListener<ApplicationObject> applicationDataReaderListener, Object topicDescription, String dataReaderQoSFileName) throws IOException {
        DataReaderQos dataReaderQos = OpenSpliceLayer.readDataReaderQosFromJsonFile(dataReaderQoSFileName);
        return this.createDataReader(applicationDataReaderListener, topicDescription, dataReaderQos);
    }

    @Override
    public boolean writeQosProfileToJsonFile(QosProfile entityQos, String fileName) throws IOException {
        return OpenSpliceLayer.writeToJsonFile(entityQos, fileName);
    }
}

