/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.udi.core;

import java.util.UUID;
import lac.cnet.sddl.objects.ITopicMapper;
import lac.cnet.sddl.objects.Utils;
import lac.cnet.sddl.udi.core.CoreDXLayer;
import lac.cnet.sddl.udi.core.OpenSpliceLayer;
import lac.cnet.sddl.udi.core.RTILayer;
import lac.cnet.sddl.udi.core.SddlLayer;

public abstract class UniversalDDSLayerFactory {
    public static final int CNET_DOMAIN = 0;
    public static final int BROADCAST_FLAG = -1;
    public static final UUID BROADCAST_ID = new UUID(-1L, -1L);
    public static SupportedDDSVendors DEFAULT_VENDOR = SupportedDDSVendors.OpenSplice;

    public static SddlLayer getInstance(SupportedDDSVendors ddsVendor) {
        switch (ddsVendor) {
            case CoreDX: {
                return new CoreDXLayer();
            }
            case RTI: {
                return new RTILayer();
            }
            case OpenSplice: {
                return new OpenSpliceLayer();
            }
        }
        return null;
    }

    public static SddlLayer getInstance() {
        return UniversalDDSLayerFactory.getInstance(DEFAULT_VENDOR);
    }

    public static SupportedDDSVendors convertStrToSupportedDDSVendor(String strDDSVendor) {
        if (strDDSVendor == null) {
            throw new IllegalArgumentException("Invalid argument strDDSVendor");
        }
        String strTemp = strDDSVendor.toLowerCase().trim();
        if (strTemp.equals("coredx") || strTemp.equals("coredxdds")) {
            return SupportedDDSVendors.CoreDX;
        }
        if (strTemp.equals("opensplice") || strTemp.equals("opensplicedds") || strTemp.equals("ospl")) {
            return SupportedDDSVendors.OpenSplice;
        }
        if (strTemp.equals("rti")) {
            return SupportedDDSVendors.RTI;
        }
        throw new IllegalArgumentException("Invalid argument strDDSVendor");
    }

    public static void addCustomTopicMapper(ITopicMapper topicMapper) {
        Utils.setTopicMapper(topicMapper);
    }

    public static enum ParticipantType {
        GATEWAY,
        GROUPDEFINER,
        MONITOR,
        PoAMAN;

    }

    public static enum SupportedDDSVendors {
        CoreDX,
        RTI,
        OpenSplice;

    }
}

