/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.udi.coredx;

import com.toc.coredx.DDS.ContentFilteredTopic;
import com.toc.coredx.DDS.DataReader;
import com.toc.coredx.DDS.DataReaderListener;
import com.toc.coredx.DDS.DataReaderQos;
import com.toc.coredx.DDS.DataWriter;
import com.toc.coredx.DDS.DataWriterListener;
import com.toc.coredx.DDS.DataWriterQos;
import com.toc.coredx.DDS.DestinationOrderQosPolicyKind;
import com.toc.coredx.DDS.DomainParticipant;
import com.toc.coredx.DDS.DomainParticipantFactory;
import com.toc.coredx.DDS.DomainParticipantQos;
import com.toc.coredx.DDS.HistoryQosPolicyKind;
import com.toc.coredx.DDS.Publisher;
import com.toc.coredx.DDS.PublisherListener;
import com.toc.coredx.DDS.PublisherQos;
import com.toc.coredx.DDS.ReliabilityQosPolicyKind;
import com.toc.coredx.DDS.ReturnCode_t;
import com.toc.coredx.DDS.Subscriber;
import com.toc.coredx.DDS.SubscriberListener;
import com.toc.coredx.DDS.SubscriberQos;
import com.toc.coredx.DDS.Topic;
import com.toc.coredx.DDS.TopicDescription;
import com.toc.coredx.DDS.TypeSupport;
import com.toc.coredx.DDS.coredx;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import lac.cnet.sddl.udi.core.DDSStandardAPI;
import lac.cnet.sddl.udi.coredx.WriterField;
import lac.contextnet.highlyscalablemap.ReadWriteLockMap;

public class CoreDXAbstractionComponent
implements DDSStandardAPI<Topic, TypeSupport, ContentFilteredTopic, DomainParticipantQos, SubscriberQos, DomainParticipant, Subscriber, Publisher, PublisherQos, SubscriberListener, PublisherListener, DataReaderListener, DataWriterListener, DataReaderQos, DataWriterQos, DataWriter, DataReader, TopicDescription> {
    protected DomainParticipantFactory domainParticipantFactory;
    protected DomainParticipant domainParticipant;
    protected Subscriber subscriber;
    protected Publisher publisher;
    protected Map<String, DataReader> dataReaderCollection;
    protected Map<String, WriterField> dataWriterCollection;

    @Override
    public DomainParticipant createParticipant(long domainID) {
        return this.createParticipant(domainID, null, null);
    }

    @Override
    public DomainParticipant createParticipant(String domainID) {
        return this.createParticipant((long)domainID.hashCode(), null, null);
    }

    @Override
    public DomainParticipant createParticipant(long domainID, DomainParticipantQos qos) {
        return this.createParticipant(domainID, qos, (String)null);
    }

    @Override
    public DomainParticipant createParticipant(String domainID, DomainParticipantQos qos) {
        return this.createParticipant((long)domainID.hashCode(), qos, (String)null);
    }

    @Override
    public DomainParticipant createParticipant(long domainID, DomainParticipantQos qos, String license) {
        this.domainParticipantFactory = DomainParticipantFactory.get_instance();
        if (license != null) {
            this.domainParticipantFactory.set_license(license);
        }
        this.domainParticipant = this.domainParticipantFactory.create_participant(domainID, qos, null, 0L);
        return this.domainParticipant;
    }

    @Override
    public DomainParticipant createParticipant(String domainID, DomainParticipantQos qos, String license) {
        return this.createParticipant((long)domainID.hashCode(), qos, license);
    }

    @Override
    public ContentFilteredTopic createContentFilteredTopic(String topicName, Topic topic, String logicalExpression, List<String> parameters) {
        Vector<String> parameterVector = null;
        parameterVector = parameters != null ? new Vector<String>(parameters) : new Vector(0);
        return this.domainParticipant.create_contentfilteredtopic(topicName, topic, logicalExpression, parameterVector);
    }

    @Override
    public Subscriber createSubscriber(SubscriberQos sub_qos, SubscriberListener sub_listener) {
        this.subscriber = this.domainParticipant.create_subscriber(sub_qos, sub_listener, 0L);
        this.dataReaderCollection = new ReadWriteLockMap<String, DataReader>(false, false);
        return this.subscriber;
    }

    @Override
    public Publisher createPublisher(PublisherQos pub_qos, PublisherListener pub_listener) {
        this.publisher = this.domainParticipant.create_publisher(pub_qos, pub_listener, 0L);
        this.dataWriterCollection = new ReadWriteLockMap<String, WriterField>(false, false);
        return this.publisher;
    }

    @Override
    public DataReaderQos getDefaultDataReaderQoS() {
        DataReaderQos dataReaderQoS = new DataReaderQos();
        this.subscriber.get_default_datareader_qos(dataReaderQoS);
        dataReaderQoS.reliability.kind = ReliabilityQosPolicyKind.RELIABLE_RELIABILITY_QOS;
        dataReaderQoS.history.kind = HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS;
        dataReaderQoS.destination_order.kind = DestinationOrderQosPolicyKind.BY_SOURCE_TIMESTAMP_DESTINATIONORDER_QOS;
        return dataReaderQoS;
    }

    @Override
    public DataWriterQos getDefaultDataWriterQoS() {
        DataWriterQos dataWriterQoS = new DataWriterQos();
        this.publisher.get_default_datawriter_qos(dataWriterQoS);
        dataWriterQoS.reliability.kind = ReliabilityQosPolicyKind.RELIABLE_RELIABILITY_QOS;
        dataWriterQoS.history.kind = HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS;
        dataWriterQoS.rtps_writer.enable_batch_msg = true;
        dataWriterQoS.rtps_writer.max_buffer_size = Long.MAX_VALUE;
        dataWriterQoS.destination_order.kind = DestinationOrderQosPolicyKind.BY_SOURCE_TIMESTAMP_DESTINATIONORDER_QOS;
        return dataWriterQoS;
    }

    @Override
    public Topic createTopic(String typeName, String topicName) {
        try {
            Class<?> typeSupportClass = Class.forName(String.valueOf(typeName) + "TypeSupport");
            TypeSupport typeSupportInstance = (TypeSupport)typeSupportClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return this.createTopic(typeSupportInstance, topicName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Topic createTopic(TypeSupport topicTypeSupport, String topicName) {
        topicTypeSupport.register_type(this.domainParticipant, null);
        TopicDescription topicDescription = this.domainParticipant.lookup_topicdescription(topicName);
        if (topicDescription != null) {
            return (Topic)topicDescription;
        }
        Topic topic = this.domainParticipant.create_topic(topicName, topicTypeSupport.get_type_name(), null, null, 0L);
        return topic;
    }

    @Override
    public DataReader createDataReader(TopicDescription topicDescription, DataReaderQos dataReaderQoS, DataReaderListener dataReaderListener) {
        String dataReaderName = this.getCompleteTopicName(topicDescription);
        if (dataReaderQoS == null) {
            dataReaderQoS = this.getDefaultDataReaderQoS();
        }
        DataReader dataReader = this.subscriber.create_datareader(topicDescription, dataReaderQoS, dataReaderListener, coredx.getDDS_DATA_AVAILABLE_STATUS());
        this.dataReaderCollection.put(dataReaderName, dataReader);
        return dataReader;
    }

    @Override
    public DataWriter createDataWriter(Topic topic, DataWriterQos dataWriterQoS, DataWriterListener dataWriterListener) {
        String dataWriterName = this.getCompleteTopicName(topic);
        WriterField writerField = this.dataWriterCollection.get(dataWriterName);
        if (writerField == null) {
            if (dataWriterQoS == null) {
                dataWriterQoS = this.getDefaultDataWriterQoS();
            }
            DataWriter dataWriter = this.publisher.create_datawriter(topic, dataWriterQoS, dataWriterListener, 0L);
            writerField = new WriterField(dataWriter);
            this.dataWriterCollection.put(dataWriterName, writerField);
        }
        return writerField.getDataWriter();
    }

    @Override
    public boolean writeTopic(String topicName, Object topic) {
        WriterField writerField = this.dataWriterCollection.get(this.getCompleteTopicName(topicName, topic));
        if (writerField != null) {
            return writerField.writeTopic(topic);
        }
        return false;
    }

    @Override
    public boolean deleteParticipant() {
        this.domainParticipant.delete_contained_entities();
        ReturnCode_t returnCode = this.domainParticipantFactory.delete_participant(this.domainParticipant);
        return returnCode == ReturnCode_t.RETCODE_OK;
    }

    @Override
    public boolean deletePublisher() {
        ReturnCode_t returnCode = this.domainParticipant.delete_publisher(this.publisher);
        return returnCode == ReturnCode_t.RETCODE_OK;
    }

    @Override
    public boolean deleteSubscriber() {
        ReturnCode_t returnCode = this.domainParticipant.delete_subscriber(this.subscriber);
        return returnCode == ReturnCode_t.RETCODE_OK;
    }

    @Override
    public boolean deleteDataReader(String dataReaderName) {
        DataReader dataReader = this.dataReaderCollection.get(dataReaderName);
        if (dataReader != null) {
            dataReader.delete_contained_entities();
            ReturnCode_t returnCode = this.subscriber.delete_datareader(dataReader);
            if (returnCode == ReturnCode_t.RETCODE_OK) {
                this.dataReaderCollection.remove(dataReaderName);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean deleteDataWriter(String dataWriterName) {
        ReturnCode_t returnCode;
        DataWriter dataWriter = this.dataWriterCollection.get(dataWriterName).getDataWriter();
        if (dataWriter != null && (returnCode = this.publisher.delete_datawriter(dataWriter)) == ReturnCode_t.RETCODE_OK) {
            this.dataWriterCollection.remove(dataWriterName);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteTopic(Topic topic) {
        ReturnCode_t returnCode = this.domainParticipant.delete_topic(topic);
        return returnCode == ReturnCode_t.RETCODE_OK;
    }

    @Override
    public boolean close() {
        return this.domainParticipant.delete_contained_entities() == ReturnCode_t.RETCODE_OK & this.domainParticipantFactory.delete_participant(this.domainParticipant) == ReturnCode_t.RETCODE_OK;
    }

    public String getCompleteTopicName(TopicDescription topic) {
        return String.valueOf(topic.get_type_name()) + topic.get_name();
    }

    public String getCompleteTopicName(String topicName, Object topic) {
        return String.valueOf(topic.getClass().getSimpleName()) + topicName;
    }

    public DataReader getDataReader(String dataReaderCompleteName) {
        return this.dataReaderCollection.get(dataReaderCompleteName);
    }

    public DataWriter getDataWriter(String dataReaderCompleteName) {
        return this.dataWriterCollection.get(dataReaderCompleteName).getDataWriter();
    }
}

