/*
 * Decompiled with CFR 0.152.
 */
package lac.cnet.sddl.udi.opensplice;

import DDS.ContentFilteredTopic;
import DDS.DataReader;
import DDS.DataReaderListener;
import DDS.DataReaderQos;
import DDS.DataReaderQosHolder;
import DDS.DataWriter;
import DDS.DataWriterListener;
import DDS.DataWriterQos;
import DDS.DataWriterQosHolder;
import DDS.DestinationOrderQosPolicyKind;
import DDS.DomainParticipant;
import DDS.DomainParticipantFactory;
import DDS.DomainParticipantQos;
import DDS.HistoryQosPolicyKind;
import DDS.PARTICIPANT_QOS_DEFAULT;
import DDS.Publisher;
import DDS.PublisherListener;
import DDS.PublisherQos;
import DDS.PublisherQosHolder;
import DDS.ReliabilityQosPolicyKind;
import DDS.Subscriber;
import DDS.SubscriberListener;
import DDS.SubscriberQos;
import DDS.SubscriberQosHolder;
import DDS.Topic;
import DDS.TopicDescription;
import DDS.TopicQosHolder;
import DDS.TypeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lac.cnet.sddl.udi.core.DDSStandardAPI;
import lac.cnet.sddl.udi.opensplice.OpenSpliceWriterField;
import lac.contextnet.highlyscalablemap.ReadWriteLockMap;

public class OpenSpliceAbstractionComponent
implements DDSStandardAPI<Topic, TypeSupport, ContentFilteredTopic, DomainParticipantQos, SubscriberQos, DomainParticipant, Subscriber, Publisher, PublisherQos, SubscriberListener, PublisherListener, DataReaderListener, DataWriterListener, DataReaderQos, DataWriterQos, DataWriter, DataReader, TopicDescription> {
    protected DomainParticipantFactory domainParticipantFactory;
    protected DomainParticipant domainParticipant;
    protected Subscriber subscriber;
    protected Publisher publisher;
    protected Map<String, DataReader> dataReaderCollection;
    protected Map<String, OpenSpliceWriterField> dataWriterCollection;

    @Override
    public DomainParticipant createParticipant(long domainID) {
        return this.createParticipant(domainID, null, null);
    }

    @Override
    public DomainParticipant createParticipant(String domainID) {
        return this.createParticipant((long)domainID.hashCode(), null, null);
    }

    @Override
    public DomainParticipant createParticipant(long domainID, DomainParticipantQos qos) {
        return this.createParticipant(domainID, qos, (String)null);
    }

    @Override
    public DomainParticipant createParticipant(String domainID, DomainParticipantQos qos) {
        return this.createParticipant((long)domainID.hashCode(), qos, (String)null);
    }

    @Override
    public DomainParticipant createParticipant(long domainID, DomainParticipantQos qos, String license) {
        if (qos == null) {
            qos = PARTICIPANT_QOS_DEFAULT.value;
        }
        this.domainParticipantFactory = DomainParticipantFactory.get_instance();
        this.domainParticipant = this.domainParticipantFactory.create_participant((int)domainID, qos, null, 0);
        return this.domainParticipant;
    }

    @Override
    public DomainParticipant createParticipant(String domainID, DomainParticipantQos qos, String license) {
        if (qos == null) {
            qos = PARTICIPANT_QOS_DEFAULT.value;
        }
        return this.createParticipant((long)domainID.hashCode(), qos, license);
    }

    @Override
    public ContentFilteredTopic createContentFilteredTopic(String topicName, Topic topic, String logicalExpression, List<String> parameters) {
        if (parameters == null) {
            parameters = new ArrayList<String>(0);
        } else {
            int i = 0;
            while (i < parameters.size()) {
                parameters.set(i, parameters.get(i).replace("'", ""));
                ++i;
            }
        }
        topicName = String.valueOf(topicName) + "Filter";
        return this.domainParticipant.create_contentfilteredtopic(topicName, topic, logicalExpression, parameters.toArray(new String[0]));
    }

    @Override
    public Subscriber createSubscriber(SubscriberQos sub_qos, SubscriberListener sub_listener) {
        if (sub_qos == null) {
            SubscriberQosHolder subQos = new SubscriberQosHolder();
            this.domainParticipant.get_default_subscriber_qos(subQos);
            subQos.value.partition.name = new String[1];
            subQos.value.partition.name[0] = "LAC";
            sub_qos = subQos.value;
        }
        this.subscriber = this.domainParticipant.create_subscriber(sub_qos, sub_listener, 0);
        this.dataReaderCollection = new ReadWriteLockMap<String, DataReader>(false, false);
        return this.subscriber;
    }

    @Override
    public Publisher createPublisher(PublisherQos pub_qos, PublisherListener pub_listener) {
        if (pub_qos == null) {
            PublisherQosHolder pubQos = new PublisherQosHolder();
            this.domainParticipant.get_default_publisher_qos(pubQos);
            pubQos.value.partition.name = new String[1];
            pubQos.value.partition.name[0] = "LAC";
            pub_qos = pubQos.value;
        }
        this.publisher = this.domainParticipant.create_publisher(pub_qos, pub_listener, 0);
        this.dataWriterCollection = new ReadWriteLockMap<String, OpenSpliceWriterField>(false, false);
        return this.publisher;
    }

    @Override
    public DataReaderQos getDefaultDataReaderQoS() {
        DataReaderQosHolder dataReaderQoS = new DataReaderQosHolder();
        this.subscriber.get_default_datareader_qos(dataReaderQoS);
        dataReaderQoS.value.reliability.kind = ReliabilityQosPolicyKind.RELIABLE_RELIABILITY_QOS;
        dataReaderQoS.value.history.kind = HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS;
        dataReaderQoS.value.destination_order.kind = DestinationOrderQosPolicyKind.BY_SOURCE_TIMESTAMP_DESTINATIONORDER_QOS;
        return dataReaderQoS.value;
    }

    @Override
    public DataWriterQos getDefaultDataWriterQoS() {
        DataWriterQosHolder dataWriterQoS = new DataWriterQosHolder();
        this.publisher.get_default_datawriter_qos(dataWriterQoS);
        dataWriterQoS.value.reliability.kind = ReliabilityQosPolicyKind.RELIABLE_RELIABILITY_QOS;
        dataWriterQoS.value.history.kind = HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS;
        dataWriterQoS.value.destination_order.kind = DestinationOrderQosPolicyKind.BY_SOURCE_TIMESTAMP_DESTINATIONORDER_QOS;
        return dataWriterQoS.value;
    }

    @Override
    public Topic createTopic(String typeName, String topicName) {
        try {
            Class<?> typeSupportClass = Class.forName(String.valueOf(typeName) + "TypeSupport");
            TypeSupport typeSupportInstance = (TypeSupport)typeSupportClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return this.createTopic(typeSupportInstance, topicName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Topic createTopic(TypeSupport topicTypeSupport, String topicName) {
        topicTypeSupport.register_type(this.domainParticipant, topicTypeSupport.get_type_name());
        TopicDescription topicDescription = this.domainParticipant.lookup_topicdescription(topicName);
        if (topicDescription != null) {
            return (Topic)topicDescription;
        }
        TopicQosHolder topicQos = new TopicQosHolder();
        this.domainParticipant.get_default_topic_qos(topicQos);
        Topic topic = this.domainParticipant.create_topic(topicName, topicTypeSupport.get_type_name(), topicQos.value, null, 0);
        return topic;
    }

    @Override
    public DataReader createDataReader(TopicDescription topicDescription, DataReaderQos dataReaderQoS, DataReaderListener dataReaderListener) {
        String dataReaderName = this.getCompleteTopicName(topicDescription);
        if (dataReaderQoS == null) {
            dataReaderQoS = this.getDefaultDataReaderQoS();
        }
        DataReader dataReader = this.subscriber.create_datareader(topicDescription, dataReaderQoS, dataReaderListener, 1024);
        this.dataReaderCollection.put(dataReaderName, dataReader);
        return dataReader;
    }

    @Override
    public DataWriter createDataWriter(Topic topic, DataWriterQos dataWriterQoS, DataWriterListener dataWriterListener) {
        String dataWriterName = this.getCompleteTopicName(topic);
        OpenSpliceWriterField openSpliceWriterField = this.dataWriterCollection.get(dataWriterName);
        if (openSpliceWriterField == null) {
            if (dataWriterQoS == null) {
                dataWriterQoS = this.getDefaultDataWriterQoS();
            }
            DataWriter dataWriter = this.publisher.create_datawriter(topic, dataWriterQoS, dataWriterListener, 0);
            openSpliceWriterField = new OpenSpliceWriterField(dataWriter);
            this.dataWriterCollection.put(dataWriterName, openSpliceWriterField);
        }
        return openSpliceWriterField.getDataWriter();
    }

    @Override
    public boolean writeTopic(String topicName, Object topic) {
        OpenSpliceWriterField openSpliceWriterField = this.dataWriterCollection.get(this.getCompleteTopicName(topicName, topic));
        if (openSpliceWriterField != null) {
            return openSpliceWriterField.writeTopic(topic);
        }
        return false;
    }

    @Override
    public boolean deleteParticipant() {
        this.domainParticipant.delete_contained_entities();
        int returnCode = this.domainParticipantFactory.delete_participant(this.domainParticipant);
        return returnCode == 0;
    }

    @Override
    public boolean deletePublisher() {
        int returnCode = this.domainParticipant.delete_publisher(this.publisher);
        return returnCode == 0;
    }

    @Override
    public boolean deleteSubscriber() {
        int returnCode = this.domainParticipant.delete_subscriber(this.subscriber);
        return returnCode == 0;
    }

    @Override
    public boolean deleteDataReader(String dataReaderName) {
        DataReader dataReader = this.dataReaderCollection.get(dataReaderName);
        if (dataReader != null) {
            dataReader.delete_contained_entities();
            int returnCode = this.subscriber.delete_datareader(dataReader);
            if (returnCode == 0) {
                this.dataReaderCollection.remove(dataReaderName);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean deleteDataWriter(String dataWriterName) {
        int returnCode;
        DataWriter dataWriter = this.dataWriterCollection.get(dataWriterName).getDataWriter();
        if (dataWriter != null && (returnCode = this.publisher.delete_datawriter(dataWriter)) == 0) {
            this.dataWriterCollection.remove(dataWriterName);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteTopic(Topic topic) {
        int returnCode = this.domainParticipant.delete_topic(topic);
        return returnCode == 0;
    }

    @Override
    public boolean close() {
        return this.domainParticipant.delete_contained_entities() == 0 & this.domainParticipantFactory.delete_participant(this.domainParticipant) == 0;
    }

    public String getCompleteTopicName(TopicDescription topic) {
        String name = String.valueOf(topic.get_type_name()) + topic.get_name();
        int position = name.indexOf(":");
        String x = name.substring(position + 2);
        return name.substring(position + 2);
    }

    public String getCompleteTopicName(String topicName, Object topic) {
        String x = String.valueOf(topic.getClass().getSimpleName()) + topicName;
        return String.valueOf(topic.getClass().getSimpleName()) + topicName;
    }

    public DataReader getDataReader(String dataReaderCompleteName) {
        return this.dataReaderCollection.get(dataReaderCompleteName);
    }

    public DataWriter getDataWriter(String dataReaderCompleteName) {
        return this.dataWriterCollection.get(dataReaderCompleteName).getDataWriter();
    }
}

